/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.Map;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;
import org.leadpony.justify.internal.keyword.assertion.format.EvaluatableFormat;
import org.leadpony.justify.spi.FormatAttribute;

@KeywordType(value="format")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class Format
extends AbstractAssertion {
    public static KeywordMapper mapper() {
        return (value, context) -> {
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                String name = ((JsonString)value).getString();
                FormatAttribute attribute = context.getFormateAttribute(name);
                if (attribute != null) {
                    return new EvaluatableFormat(value, attribute);
                }
                return new Format(value, name);
            }
            throw new IllegalArgumentException();
        };
    }

    public Format(JsonValue json, String attribute) {
        super(json);
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
    }
}

