/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatMatcher;

class Ipv4Matcher
extends AbstractFormatMatcher {
    private boolean allowLeadingZeros = false;

    Ipv4Matcher(CharSequence input) {
        super(input);
    }

    Ipv4Matcher withLeadingZerosAllowed() {
        this.allowLeadingZeros = true;
        return this;
    }

    Ipv4Matcher(CharSequence input, int start, int end) {
        super(input, start, end);
    }

    @Override
    boolean test() {
        return this.dottedQuad();
    }

    boolean dottedQuad() {
        int mark = this.pos();
        if (this.decbyte() && this.next() == 46 && this.decbyte() && this.next() == 46 && this.decbyte() && this.next() == 46 && this.decbyte() && !this.hasNext()) {
            return true;
        }
        return this.backtrack(mark);
    }

    boolean decbyte() {
        if (!this.hasNext()) {
            return false;
        }
        int c = this.next();
        if (!AsciiCode.isDigit(c)) {
            return false;
        }
        int value = Ipv4Matcher.digitToValue(c);
        if (value == 0 && !this.allowLeadingZeros) {
            return !this.hasNext() || this.peek() == 46;
        }
        if (this.hasNext() && this.peek() != 46) {
            c = this.next();
            if (!AsciiCode.isDigit(c)) {
                return false;
            }
            value = value * 10 + Ipv4Matcher.digitToValue(c);
            if (this.hasNext() && this.peek() != 46) {
                c = this.next();
                if (!AsciiCode.isDigit(c)) {
                    return false;
                }
                value = value * 10 + Ipv4Matcher.digitToValue(c);
            }
            if (this.hasNext() && this.peek() != 46) {
                return false;
            }
            return value <= 255;
        }
        return true;
    }

    static int digitToValue(int codePoint) {
        return codePoint - 48;
    }
}

