/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.Ipv4Matcher;

class Ipv6Matcher
extends Ipv4Matcher {
    private static final int MAX_PIECES = 8;

    Ipv6Matcher(CharSequence input) {
        super(input);
    }

    Ipv6Matcher(CharSequence input, int start, int end) {
        super(input, start, end);
    }

    @Override
    boolean test() {
        int pieces = 0;
        boolean compressed = false;
        if (this.hasNext(58)) {
            this.next();
            if (this.hasNext(58)) {
                this.next();
                compressed = true;
                ++pieces;
            } else {
                return false;
            }
        }
        while (pieces < 8 && this.h16()) {
            ++pieces;
            if (!this.hasNext()) break;
            if (this.next() == 58) {
                if (!this.hasNext(58)) continue;
                this.next();
                if (compressed) {
                    return false;
                }
                compressed = true;
                ++pieces;
                continue;
            }
            return false;
        }
        if (this.hasNext()) {
            if (this.ipv4address()) {
                pieces += 2;
            } else {
                return false;
            }
        }
        if (compressed) {
            return pieces <= 8;
        }
        return pieces == 8;
    }

    boolean ipv4address() {
        return this.dottedQuad();
    }

    boolean h16() {
        int mark = this.pos();
        if (this.hasNext() && AsciiCode.isHexDigit(this.peek())) {
            this.next();
            for (int digits = 1; digits < 4 && this.hasNext() && AsciiCode.isHexDigit(this.peek()); ++digits) {
                this.next();
            }
            if (!this.hasNext() || this.peek() == 58) {
                return true;
            }
            return this.backtrack(mark);
        }
        return false;
    }
}

