/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatMatcher;

abstract class RegExpMatcher
extends AbstractFormatMatcher {
    private static final BitSet SYNTAX_CHAR_SET = new BitSet(){
        {
            this.set(94);
            this.set(36);
            this.set(92);
            this.set(46);
            this.set(42);
            this.set(43);
            this.set(63);
            this.set(40);
            this.set(41);
            this.set(91);
            this.set(93);
            this.set(123);
            this.set(125);
            this.set(124);
        }
    };
    private int maxCapturingGroupNumber;
    private int leftCapturingParentheses;
    private Set<String> groups;
    private Set<String> groupReferences;
    protected int lastNumericValue;
    private ClassAtom lastClassAtom;

    RegExpMatcher(CharSequence input) {
        super(input);
    }

    @Override
    public boolean test() {
        this.disjunction();
        if (this.hasNext()) {
            return false;
        }
        this.checkCapturingNumber();
        this.checkGroupReferences();
        return true;
    }

    Set<String> groupNames() {
        return this.groups;
    }

    private void disjunction() {
        this.alternative();
        while (this.hasNext(124)) {
            this.next();
            this.alternative();
        }
    }

    private void alternative() {
        while (this.hasNext() && this.term()) {
        }
    }

    private boolean term() {
        if (this.assertion()) {
            return true;
        }
        return this.atom() && RegExpMatcher.optional(this.quantifier());
    }

    private boolean assertion() {
        int mark = this.pos();
        int c = this.next();
        if (c == 94 || c == 36) {
            return true;
        }
        if (c == 92) {
            if (this.hasNext() && ((c = this.next()) == 98 || c == 66)) {
                return true;
            }
        } else if (c == 40 && this.hasNext(63)) {
            this.next();
            if (this.hasNext(60)) {
                this.next();
            }
            if (this.hasNext() && ((c = this.next()) == 61 || c == 33)) {
                return this.capturingGroup();
            }
        }
        return this.backtrack(mark);
    }

    private boolean quantifier() {
        if (this.quantifierPrefix()) {
            if (this.hasNext(63)) {
                this.next();
            }
            return true;
        }
        return false;
    }

    private boolean quantifierPrefix() {
        if (!this.hasNext()) {
            return false;
        }
        int mark = this.pos();
        int c = this.peek();
        if (c == 42 || c == 43 || c == 63) {
            this.next();
            return true;
        }
        if (c == 123) {
            this.next();
            if (this.decimalDigits()) {
                int first = this.lastNumericValue;
                if (this.hasNext()) {
                    c = this.next();
                    if (c == 125) {
                        return true;
                    }
                    if (c == 44) {
                        if (this.hasNext(125)) {
                            this.next();
                            return true;
                        }
                        if (this.decimalDigits()) {
                            int second = this.lastNumericValue;
                            if (this.hasNext(125)) {
                                this.next();
                                return RegExpMatcher.checkQuantifierRange(first, second);
                            }
                        }
                    }
                }
            }
        }
        return this.backtrack(mark);
    }

    private boolean atom() {
        if (this.patternCharacter() || this.characterClass()) {
            return true;
        }
        int mark = this.pos();
        int c = this.peek();
        if (c == 46) {
            this.next();
            return true;
        }
        if (c == 92) {
            this.next();
            if (this.atomEscape()) {
                return true;
            }
        } else if (c == 40) {
            this.next();
            int parenthesis = this.pos();
            if (this.hasNext(63)) {
                this.next();
                if (this.hasNext(58)) {
                    return this.capturingGroup();
                }
                this.backtrack(parenthesis);
            }
            if (this.groupSpecifier()) {
                return this.capturingGroup();
            }
        }
        return this.backtrack(mark);
    }

    protected boolean syntaxCharacter() {
        if (this.hasNext() && RegExpMatcher.isSyntaxCharacter(this.peek())) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean patternCharacter() {
        if (this.hasNext() && !RegExpMatcher.isSyntaxCharacter(this.peek())) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean atomEscape() {
        if (this.decimalEscape() || this.characterClassEscape()) {
            return true;
        }
        if (this.characterEscape()) {
            return true;
        }
        if (this.hasNext(107)) {
            this.next();
            if (this.groupName(true)) {
                return true;
            }
        }
        return false;
    }

    private boolean characterEscape() {
        if (!this.hasNext()) {
            return false;
        }
        if (this.controlEscape() || this.hexEscapeSequence() || this.regExpUnicodeEscapeSequence() || this.identityEscape()) {
            return true;
        }
        int mark = this.pos();
        int c = this.peek();
        if (c == 99) {
            this.next();
            if (this.controlLetter()) {
                return true;
            }
        } else if (c == 48) {
            this.next();
            if (!this.hasNext() || !AsciiCode.isDigit(this.peek())) {
                return this.withClassAtomOf(0);
            }
        }
        return this.backtrack(mark);
    }

    private boolean controlEscape() {
        int value;
        if (!this.hasNext()) {
            return false;
        }
        switch (this.peek()) {
            case 116: {
                value = 9;
                break;
            }
            case 110: {
                value = 10;
                break;
            }
            case 118: {
                value = 11;
                break;
            }
            case 102: {
                value = 12;
                break;
            }
            case 114: {
                value = 13;
                break;
            }
            default: {
                return false;
            }
        }
        return this.withClassAtomOf(value);
    }

    private boolean controlLetter() {
        if (!this.hasNext()) {
            return false;
        }
        int c = this.peek();
        if (RegExpMatcher.isControlLetter(c)) {
            this.next();
            return this.withClassAtomOf(c % 32);
        }
        return false;
    }

    private boolean groupSpecifier() {
        if (this.hasNext(63)) {
            int mark = this.pos();
            this.next();
            if (this.groupName(false)) {
                return true;
            }
            this.backtrack(mark);
        }
        return true;
    }

    private boolean groupName(boolean reference) {
        if (!this.hasNext(60)) {
            return false;
        }
        int mark = this.pos();
        this.next();
        int nameStart = this.pos();
        if (this.regExpIdentifierName()) {
            String name = this.extract(nameStart);
            if (this.hasNext(62)) {
                this.next();
                if (reference) {
                    this.addGroupReference(name);
                } else {
                    this.addGroup(name);
                }
                return true;
            }
        }
        return this.backtrack(mark);
    }

    private boolean regExpIdentifierName() {
        if (!this.regExpIdentifierStart()) {
            return false;
        }
        while (this.regExpIdentifierPart()) {
        }
        return true;
    }

    private boolean regExpIdentifierStart() {
        if (!this.hasNext()) {
            return false;
        }
        int mark = this.pos();
        int c = this.peek();
        if (RegExpMatcher.isRegExpIdentifierStart(c)) {
            this.next();
            return true;
        }
        if (c == 92) {
            this.next();
            if (this.regExpUnicodeEscapeSequence()) {
                if (RegExpMatcher.isRegExpIdentifierStart(this.lastNumericValue)) {
                    return true;
                }
                return RegExpMatcher.earlyError();
            }
        }
        return this.backtrack(mark);
    }

    private boolean regExpIdentifierPart() {
        if (!this.hasNext()) {
            return false;
        }
        int mark = this.pos();
        int c = this.peek();
        if (RegExpMatcher.isRegExpIdentifierPart(c)) {
            this.next();
            return true;
        }
        if (c == 92) {
            this.next();
            if (this.regExpUnicodeEscapeSequence()) {
                if (RegExpMatcher.isRegExpIdentifierPart(this.lastNumericValue)) {
                    return true;
                }
                RegExpMatcher.earlyError();
            }
        }
        return this.backtrack(mark);
    }

    protected boolean regExpUnicodeEscapeSequence() {
        if (!this.hasNext(117)) {
            return false;
        }
        int mark = this.pos();
        this.next();
        if (this.hex4Digits()) {
            return this.withClassAtomOf(this.lastNumericValue);
        }
        return this.backtrack(mark);
    }

    protected abstract boolean identityEscape();

    private boolean decimalEscape() {
        if (!this.hasNext() || !RegExpMatcher.isNonZeroDigit(this.peek())) {
            return false;
        }
        int number = RegExpMatcher.digitToValue(this.next());
        while (this.hasNext() && AsciiCode.isDigit(this.peek())) {
            number = number * 10 + RegExpMatcher.digitToValue(this.next());
        }
        if (number > this.maxCapturingGroupNumber) {
            this.maxCapturingGroupNumber = number;
        }
        return true;
    }

    private boolean characterClassEscape() {
        if (this.testCharacterClassEscape()) {
            this.lastClassAtom = ClassAtom.CHARACTER_CLASS;
            return true;
        }
        return false;
    }

    private boolean characterClass() {
        if (!this.hasNext(91)) {
            return false;
        }
        int mark = this.pos();
        this.next();
        if (this.peek() == 94) {
            this.next();
        }
        this.classRanges();
        if (this.hasNext(93)) {
            this.next();
            return true;
        }
        return this.backtrack(mark);
    }

    private void classRanges() {
        while (this.hasNext() && this.nonemptyClassRanges()) {
        }
    }

    private boolean nonemptyClassRanges() {
        if (this.classAtom()) {
            ClassAtom first = this.lastClassAtom;
            if (this.hasNext(45)) {
                int mark = this.pos();
                this.next();
                if (this.classAtom()) {
                    ClassAtom second = this.lastClassAtom;
                    return RegExpMatcher.checkClassRange(first, second);
                }
                this.backtrack(mark);
            } else if (this.nonemptyClassRangesNoDash()) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean nonemptyClassRangesNoDash() {
        int mark = this.pos();
        if (this.classAtomNoDash()) {
            ClassAtom first = this.lastClassAtom;
            if (this.hasNext(45)) {
                this.next();
                if (this.classAtom()) {
                    ClassAtom second = this.lastClassAtom;
                    return RegExpMatcher.checkClassRange(first, second);
                }
            } else if (this.nonemptyClassRangesNoDash()) {
                return true;
            }
        }
        this.backtrack(mark);
        return this.classAtom();
    }

    private boolean classAtom() {
        if (this.hasNext(45)) {
            return this.withClassAtomOf(this.next());
        }
        return this.classAtomNoDash();
    }

    private boolean classAtomNoDash() {
        if (!this.hasNext()) {
            return false;
        }
        int c = this.peek();
        if (c == 92) {
            int mark = this.pos();
            this.next();
            if (this.classEscape()) {
                return true;
            }
            return this.backtrack(mark);
        }
        if (c == 93 || c == 45) {
            return false;
        }
        return this.withClassAtomOf(this.next());
    }

    private boolean classEscape() {
        if (!this.hasNext()) {
            return false;
        }
        int c = this.peek();
        if (c == 98) {
            this.next();
            return this.withClassAtomOf(8);
        }
        if (c == 45) {
            return this.withClassAtomOf(this.next());
        }
        return this.characterClassEscape() || this.characterEscape();
    }

    private boolean decimalDigits() {
        if (!this.hasNext()) {
            return false;
        }
        int c = this.peek();
        if (AsciiCode.isDigit(c)) {
            this.next();
            int value = c - 48;
            while (this.hasNext() && AsciiCode.isDigit(this.peek())) {
                c = this.next();
                value = value * 10 + (c - 48);
            }
            this.lastNumericValue = value;
            return true;
        }
        return false;
    }

    private boolean hexEscapeSequence() {
        int second;
        int first;
        if (!this.hasNext(120)) {
            return false;
        }
        int mark = this.pos();
        this.next();
        if (this.hasNext() && AsciiCode.isHexDigit(first = this.next()) && this.hasNext() && AsciiCode.isHexDigit(second = this.next())) {
            int value = AsciiCode.hexDigitToValue(first) * 16 + AsciiCode.hexDigitToValue(second);
            return this.withClassAtomOf(value);
        }
        return this.backtrack(mark);
    }

    protected boolean hex4Digits() {
        int c;
        int mark = this.pos();
        int value = 0;
        int digits = 0;
        while (this.hasNext() && AsciiCode.isHexDigit(c = this.next())) {
            value = value * 16 + AsciiCode.hexDigitToValue(c);
            if (++digits < 4) continue;
            this.lastNumericValue = value;
            return true;
        }
        return this.backtrack(mark);
    }

    protected boolean testCharacterClassEscape() {
        int c = this.peek();
        if (c == 100 || c == 68 || c == 115 || c == 83 || c == 119 || c == 87) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean capturingGroup() {
        ++this.leftCapturingParentheses;
        this.disjunction();
        if (this.next() != 41) {
            return RegExpMatcher.fail();
        }
        return true;
    }

    protected boolean withClassAtomOf(int codePoint) {
        this.lastClassAtom = ClassAtom.of(codePoint);
        return true;
    }

    private void addGroup(String name) {
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        if (this.groups.contains(name)) {
            RegExpMatcher.earlyError();
        } else {
            this.groups.add(name);
        }
    }

    private void addGroupReference(String name) {
        if (this.groupReferences == null) {
            this.groupReferences = new HashSet<String>();
        }
        this.groupReferences.add(name);
    }

    private boolean findGroup(String name) {
        if (this.groups == null) {
            return false;
        }
        return this.groups.contains(name);
    }

    private static boolean checkQuantifierRange(int first, int second) {
        if (first <= second) {
            return true;
        }
        return RegExpMatcher.earlyError();
    }

    private static boolean checkClassRange(ClassAtom lower, ClassAtom upper) {
        if (lower.isCharacterClass() || upper.isCharacterClass()) {
            return RegExpMatcher.earlyError();
        }
        if (lower.codePoint() > upper.codePoint()) {
            return RegExpMatcher.earlyError();
        }
        return true;
    }

    private boolean checkCapturingNumber() {
        if (this.maxCapturingGroupNumber <= this.leftCapturingParentheses) {
            return true;
        }
        return RegExpMatcher.earlyError();
    }

    private boolean checkGroupReferences() {
        if (this.groupReferences == null) {
            return true;
        }
        for (String ref : this.groupReferences) {
            if (this.findGroup(ref)) continue;
            return RegExpMatcher.earlyError();
        }
        return true;
    }

    protected static boolean isSyntaxCharacter(int c) {
        return SYNTAX_CHAR_SET.get(c);
    }

    protected static boolean isNonZeroDigit(int c) {
        return c >= 49 && c <= 57;
    }

    protected static boolean isRegExpIdentifierStart(int c) {
        return Character.isUnicodeIdentifierStart(c) || c == 36 || c == 95;
    }

    protected static boolean isRegExpIdentifierPart(int c) {
        return Character.isUnicodeIdentifierPart(c) || c == 36 || c == 8204 || c == 8205;
    }

    protected static boolean isControlLetter(int c) {
        return AsciiCode.isAlphabetic(c);
    }

    protected static int digitToValue(int c) {
        return c - 48;
    }

    protected static boolean optional(boolean result) {
        return true;
    }

    protected static boolean earlyError() {
        return RegExpMatcher.fail();
    }

    static interface ClassAtom {
        public static final ClassAtom CHARACTER_CLASS = new ClassAtom(){

            @Override
            public boolean isCharacterClass() {
                return true;
            }

            @Override
            public int codePoint() {
                throw new IllegalStateException();
            }
        };

        public boolean isCharacterClass();

        public int codePoint();

        public static ClassAtom of(int c) {
            return new DefaultClassAtom(c);
        }
    }

    private static class DefaultClassAtom
    implements ClassAtom {
        private final int codePoint;

        DefaultClassAtom(int codePoint) {
            this.codePoint = codePoint;
        }

        @Override
        public boolean isCharacterClass() {
            return false;
        }

        @Override
        public int codePoint() {
            return this.codePoint;
        }
    }
}

