/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import org.leadpony.justify.api.Localizable;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatAttribute;
import org.leadpony.justify.internal.keyword.assertion.format.NonUnicodeRegExpMatcher;
import org.leadpony.justify.internal.keyword.assertion.format.UnicodeRegExpMatcher;

@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
class Regex
extends AbstractFormatAttribute {
    Regex() {
    }

    @Override
    public String name() {
        return "regex";
    }

    @Override
    public Localizable localizedName() {
        return Message.FORMAT_REGEX;
    }

    @Override
    public boolean test(String value) {
        return this.testWithoutUnicodeFlag(value);
    }

    public boolean test(String value, String flags) {
        if (flags.indexOf(117) >= 0) {
            return this.testWithUnicodeFlag(value);
        }
        return this.testWithoutUnicodeFlag(value);
    }

    private boolean testWithUnicodeFlag(String value) {
        return new UnicodeRegExpMatcher(value).matches();
    }

    private boolean testWithoutUnicodeFlag(String value) {
        return new NonUnicodeRegExpMatcher(value).matches();
    }
}

