/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import org.leadpony.justify.api.Localizable;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatAttribute;
import org.leadpony.justify.internal.keyword.assertion.format.JsonPointer;

@Spec(value=SpecVersion.DRAFT_07)
class RelativeJsonPointer
extends AbstractFormatAttribute {
    private final JsonPointer jsonPointer = new JsonPointer();

    RelativeJsonPointer() {
    }

    @Override
    public String name() {
        return "relative-json-pointer";
    }

    @Override
    public Localizable localizedName() {
        return Message.FORMAT_RELATIVE_JSON_POINTER;
    }

    @Override
    public boolean test(String value) {
        int length = value.length();
        if (value.isEmpty()) {
            return false;
        }
        char c = value.charAt(0);
        if (c == '0') {
            return this.testAfterPrefix(value, 1);
        }
        if (c >= '1' && c <= '9') {
            int offset = 0;
            while (++offset < length && AsciiCode.isDigit(c = value.charAt(offset))) {
            }
            return this.testAfterPrefix(value, offset);
        }
        return false;
    }

    private boolean testAfterPrefix(String value, int offset) {
        int length = value.length();
        if (offset >= length) {
            return true;
        }
        char c = value.charAt(offset);
        if (c == '#') {
            return offset + 1 >= length;
        }
        if (c == '/') {
            return this.jsonPointer.test(value.substring(offset));
        }
        return false;
    }
}

