/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.leadpony.justify.api.Localizable;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatAttribute;

@Spec(value=SpecVersion.DRAFT_07)
class Time
extends AbstractFormatAttribute {
    private static final Pattern LOCAL_TIME_PATTERN = Pattern.compile("(\\d{2})\\:(\\d{2})\\:(\\d{2})(\\.\\d+)?");
    private static final Pattern TIME_OFFSET_PATTERN = Pattern.compile("(\\d{2})\\:(\\d{2})");
    private static final int MAX_HOURS = 23;
    private static final int MAX_MINUTES = 59;
    private static final int MAX_SECONDS = 60;

    Time() {
    }

    @Override
    public String name() {
        return "time";
    }

    @Override
    public Localizable localizedName() {
        return Message.FORMAT_TIME;
    }

    @Override
    public boolean test(String value) {
        if (value.endsWith("Z") || value.endsWith("z")) {
            String part = value.substring(0, value.length() - 1);
            return Time.testLocalTimePart(part);
        }
        String[] parts = value.split("\\+|\\-");
        if (parts.length != 2) {
            return false;
        }
        return Time.testLocalTimePart(parts[0]) && Time.testTimeOffsetPart(parts[1]);
    }

    private static boolean testLocalTimePart(String value) {
        Matcher m = LOCAL_TIME_PATTERN.matcher(value);
        if (!m.matches()) {
            return false;
        }
        int hours = Integer.parseInt(m.group(1));
        if (hours > 23) {
            return false;
        }
        int minutes = Integer.parseInt(m.group(2));
        if (minutes > 59) {
            return false;
        }
        int seconds = Integer.parseInt(m.group(3));
        return seconds <= 60;
    }

    private static boolean testTimeOffsetPart(String value) {
        Matcher m = TIME_OFFSET_PATTERN.matcher(value);
        if (!m.matches()) {
            return false;
        }
        int hours = Integer.parseInt(m.group(1));
        if (hours > 23) {
            return false;
        }
        int minutes = Integer.parseInt(m.group(2));
        return minutes <= 59;
    }
}

