/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import java.util.BitSet;
import org.leadpony.justify.internal.base.text.AsciiCode;

final class UriCode {
    private static final int[] GEN_DELIMS = new int[]{58, 47, 63, 35, 91, 93, 64};
    private static final int[] SUB_DELIMS = new int[]{33, 36, 38, 39, 40, 41, 42, 43, 44, 59, 61};
    private static final BitSet GEN_DELIMS_SET = new BitSet();
    private static final BitSet SUB_DELIMS_SET = new BitSet();
    private static final BitSet RESERVED = new BitSet();

    private UriCode() {
    }

    static boolean isReserved(int c) {
        return RESERVED.get(c);
    }

    static boolean isSubDelim(int c) {
        return SUB_DELIMS_SET.get(c);
    }

    static boolean isUnreserved(int c) {
        return AsciiCode.isAlphanumeric(c) || c == 45 || c == 46 || c == 95 || c == 126;
    }

    static boolean isIunreserved(int c) {
        return UriCode.isUnreserved(c) || UriCode.isUcschar(c);
    }

    static boolean isUcschar(int c) {
        return 160 <= c && c <= 55295 || 63744 <= c && c <= 64975 || 65008 <= c && c <= 65519 || 65536 <= c && c <= 131069 || 131072 <= c && c <= 196605 || 196608 <= c && c <= 262141 || 262144 <= c && c <= 327677 || 327680 <= c && c <= 393213 || 393216 <= c && c <= 458749 || 458752 <= c && c <= 524285 || 524288 <= c && c <= 589821 || 589824 <= c && c <= 655357 || 655360 <= c && c <= 720893 || 720896 <= c && c <= 786429 || 786432 <= c && c <= 851965 || 851968 <= c && c <= 917501 || 917504 <= c && c <= 983037;
    }

    static boolean isIprivate(int c) {
        return 57344 <= c && c <= 63743 || 983040 <= c && c <= 1048573 || 0x100000 <= c && c <= 1114109;
    }

    static {
        for (int c : GEN_DELIMS) {
            GEN_DELIMS_SET.set(c);
        }
        for (int c : SUB_DELIMS) {
            SUB_DELIMS_SET.set(c);
        }
        RESERVED.or(GEN_DELIMS_SET);
        RESERVED.or(SUB_DELIMS_SET);
    }
}

