/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatMatcher;
import org.leadpony.justify.internal.keyword.assertion.format.UriCode;

class UriTemplateMatcher
extends AbstractFormatMatcher {
    UriTemplateMatcher(CharSequence input) {
        super(input);
    }

    @Override
    boolean test() {
        while (this.hasNext()) {
            if (this.literals() || this.expression()) continue;
            return false;
        }
        return true;
    }

    boolean literals() {
        int c = this.peek();
        if (c == 33 || 35 <= c && c <= 36 || c == 38 || 40 <= c && c <= 59 || c == 61 || 63 <= c && c <= 91 || c == 93 || c == 95 || 97 <= c && c <= 122 || c == 126 || UriCode.isUcschar(c) || UriCode.isIprivate(c)) {
            this.next();
            return true;
        }
        return this.pctEncoded();
    }

    boolean expression() {
        if (!this.hasNext(123)) {
            return false;
        }
        this.next();
        if (this.hasNext()) {
            this.operator();
            if (this.variableList() && this.hasNext(125)) {
                this.next();
                return true;
            }
        }
        return UriTemplateMatcher.fail();
    }

    boolean operator() {
        switch (this.peek()) {
            case 33: 
            case 35: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 124: {
                this.next();
                return true;
            }
        }
        return false;
    }

    boolean variableList() {
        if (!this.hasNext() || !this.varspec()) {
            return false;
        }
        while (this.hasNext(44)) {
            this.next();
            if (this.varspec()) continue;
            return UriTemplateMatcher.fail();
        }
        return true;
    }

    boolean varspec() {
        if (this.varname()) {
            this.modifierLevel4();
            return true;
        }
        return false;
    }

    boolean varname() {
        if (!this.varchar()) {
            return false;
        }
        while (this.hasNext()) {
            if (this.hasNext(46)) {
                this.next();
                if (this.varchar()) continue;
                return UriTemplateMatcher.fail();
            }
            if (this.varchar()) continue;
            break;
        }
        return true;
    }

    boolean varchar() {
        if (this.hasNext()) {
            int c = this.peek();
            if (AsciiCode.isAlphanumeric(c) || c == 95) {
                this.next();
                return true;
            }
            if (this.pctEncoded()) {
                return true;
            }
        }
        return false;
    }

    boolean modifierLevel4() {
        return this.prefix() || this.explode();
    }

    boolean prefix() {
        if (this.hasNext(58)) {
            this.next();
            if (this.maxLength()) {
                return true;
            }
            return UriTemplateMatcher.fail();
        }
        return false;
    }

    boolean maxLength() {
        if (!this.hasNext()) {
            return false;
        }
        int c = this.next();
        if (c == 48 || !AsciiCode.isDigit(c)) {
            return false;
        }
        int digits = 1;
        while (this.hasNext() && AsciiCode.isDigit(this.peek())) {
            if (++digits < 5) {
                this.next();
                continue;
            }
            return false;
        }
        return true;
    }

    boolean explode() {
        if (this.hasNext(42)) {
            this.next();
            return true;
        }
        return false;
    }

    boolean pctEncoded() {
        if (!this.hasNext(37)) {
            return false;
        }
        this.next();
        if (this.hasNext() && AsciiCode.isHexDigit(this.next()) && this.hasNext() && AsciiCode.isHexDigit(this.next())) {
            return true;
        }
        return UriTemplateMatcher.fail();
    }
}

