/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.leadpony.justify.internal.keyword.assertion.format.UriReferenceMatcher;

class VerboseUriReferenceMatcher
extends UriReferenceMatcher {
    private static final Logger LOG = Logger.getLogger(VerboseUriReferenceMatcher.class.getName());
    private final List<String> components = new ArrayList<String>();

    VerboseUriReferenceMatcher(CharSequence input) {
        super(input);
    }

    @Override
    boolean test() {
        boolean result = super.test();
        if (result) {
            this.printComponents();
        }
        return result;
    }

    @Override
    boolean scheme() {
        int start = this.pos();
        if (super.scheme()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    boolean userinfo() {
        int start = this.pos();
        if (super.userinfo()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    boolean host() {
        int start = this.pos();
        if (super.host()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    void port() {
        int start = this.pos();
        super.port();
        this.addComponent(start);
    }

    @Override
    boolean pathAbempty() {
        int start = this.pos();
        if (super.pathAbempty()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    boolean pathNoscheme() {
        int start = this.pos();
        if (super.pathNoscheme()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    boolean pathAbsolute() {
        int start = this.pos();
        if (super.pathAbsolute()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    boolean pathRootless() {
        int start = this.pos();
        if (super.pathRootless()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    boolean pathEmpty() {
        int start = this.pos();
        if (super.pathEmpty()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    boolean query() {
        int start = this.pos();
        if (super.query()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    boolean fragment() {
        int start = this.pos();
        if (super.fragment()) {
            this.addComponent(start);
            return true;
        }
        return false;
    }

    @Override
    boolean relativeRef() {
        this.components.clear();
        return super.relativeRef();
    }

    private void addComponent(int offset) {
        this.components.add(this.extract(offset, this.pos()));
    }

    private void printComponents() {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.input()).append(" -> ").append(this.components.stream().collect(Collectors.joining(", ", "[", "]")));
        LOG.fine(b.toString());
    }
}

