/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.problem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.internal.problem.LineFormat;
import org.leadpony.justify.internal.problem.ProblemRenderer;

class BasicProblemRenderer
implements ProblemRenderer {
    private final LineFormat lineFormat;

    BasicProblemRenderer(LineFormat lineFormat) {
        this.lineFormat = lineFormat;
    }

    @Override
    public void render(Problem problem, Locale locale, Consumer<String> consumer) {
        this.renderProblem(problem, locale, consumer, "");
    }

    @Override
    public String render(Problem problem, Locale locale) {
        if (!problem.hasBranches()) {
            return this.lineFormat.format(problem, locale);
        }
        ArrayList lines = new ArrayList();
        this.renderProblem(problem, locale, lines::add, "");
        return lines.stream().collect(Collectors.joining("\n"));
    }

    private void renderProblem(Problem problem, Locale locale, Consumer<String> consumer, String prefix) {
        int numOfBranches = problem.countBranches();
        if (numOfBranches > 1) {
            this.renderBranchingProblem(problem, locale, consumer, prefix);
        } else if (numOfBranches == 1) {
            this.renderFirstBranchOnly(problem, locale, consumer, prefix);
        } else {
            this.renderSimpleProblem(problem, locale, consumer, prefix);
        }
    }

    private void renderBranchingProblem(Problem problem, Locale locale, Consumer<String> consumer, String prefix) {
        int numOfBranches = problem.countBranches();
        consumer.accept(prefix + problem.getMessage(locale));
        prefix = BasicProblemRenderer.spaces(prefix.length());
        for (int i = 0; i < numOfBranches; ++i) {
            String marker = i + 1 + ") ";
            String newPrefix = prefix + marker;
            Iterator<Problem> it = problem.getBranch(i).iterator();
            this.renderProblem(it.next(), locale, consumer, newPrefix);
            newPrefix = prefix + BasicProblemRenderer.spaces(marker.length());
            while (it.hasNext()) {
                this.renderProblem(it.next(), locale, consumer, newPrefix);
            }
        }
    }

    private void renderFirstBranchOnly(Problem problem, Locale locale, Consumer<String> consumer, String prefix) {
        Iterator<Problem> it = problem.getBranch(0).iterator();
        this.renderProblem(it.next(), locale, consumer, prefix);
        prefix = BasicProblemRenderer.spaces(prefix.length());
        while (it.hasNext()) {
            this.renderProblem(it.next(), locale, consumer, prefix);
        }
    }

    private void renderSimpleProblem(Problem problem, Locale locale, Consumer<String> consumer, String prefix) {
        consumer.accept(prefix + this.lineFormat.format(problem, locale));
    }

    private static String spaces(int count) {
        StringBuilder b = new StringBuilder();
        while (count-- > 0) {
            b.append(' ');
        }
        return b.toString();
    }
}

