/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.problem;

import java.util.Locale;
import java.util.function.Consumer;
import org.leadpony.justify.api.ProblemHandler;
import org.leadpony.justify.api.ProblemPrinterBuilder;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.problem.BasicProblemRenderer;
import org.leadpony.justify.internal.problem.LineFormat;
import org.leadpony.justify.internal.problem.ProblemPrinter;

public class DefaultProblemPrinterBuilder
implements ProblemPrinterBuilder {
    private final Consumer<String> lineConsumer;
    private Locale locale = Locale.getDefault();
    private boolean location = true;
    private boolean pointer = true;

    public DefaultProblemPrinterBuilder(Consumer<String> lineConsumer) {
        this.lineConsumer = lineConsumer;
    }

    @Override
    public ProblemHandler build() {
        LineFormat format = LineFormat.get(this.location, this.pointer);
        BasicProblemRenderer renderer = new BasicProblemRenderer(format);
        return new ProblemPrinter(renderer, this.lineConsumer, this.locale);
    }

    @Override
    public ProblemPrinterBuilder withLocale(Locale locale) {
        Arguments.requireNonNull(locale, "locale");
        this.locale = locale;
        return this;
    }

    @Override
    public ProblemPrinterBuilder withLocation(boolean present) {
        this.location = present;
        return this;
    }

    @Override
    public ProblemPrinterBuilder withPointer(boolean present) {
        this.pointer = present;
        return this;
    }
}

