/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.problem;

import jakarta.json.stream.JsonLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.problem.ProblemList;
import org.leadpony.justify.internal.problem.ProblemRenderer;

public class ProblemBuilder {
    private final JsonLocation location;
    private final String pointer;
    private JsonSchema schema;
    private String keyword;
    private boolean resolvable = true;
    private Message message;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private List<List<Problem>> branches;

    ProblemBuilder(JsonLocation location, String pointer) {
        this.location = location;
        this.pointer = pointer;
    }

    public ProblemBuilder withKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public ProblemBuilder withSchema(JsonSchema schema) {
        this.schema = schema;
        return this;
    }

    public ProblemBuilder withResolvability(boolean resolvable) {
        this.resolvable = resolvable;
        return this;
    }

    public ProblemBuilder withMessage(Message message) {
        this.message = message;
        return this;
    }

    public ProblemBuilder withParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public ProblemBuilder withBranch(ProblemList branch) {
        if (this.branches == null) {
            this.branches = new ArrayList<List<Problem>>();
        }
        this.branches.add(Collections.unmodifiableList(branch));
        return this;
    }

    public ProblemBuilder withBranches(List<ProblemList> branches) {
        for (ProblemList branch : branches) {
            this.withBranch(branch);
        }
        return this;
    }

    public Problem build() {
        if (this.branches == null || this.branches.isEmpty()) {
            return new SimpleProblem(this);
        }
        return new CompositeProblem(this);
    }

    private static class SimpleProblem
    implements Problem {
        private final JsonSchema schema;
        private final String keyword;
        private final boolean resolvable;
        private final Message message;
        private final Map<String, Object> parameters;
        private final JsonLocation location;
        private final String pointer;

        protected SimpleProblem(ProblemBuilder builder) {
            this.schema = builder.schema;
            this.keyword = builder.keyword;
            this.resolvable = builder.resolvable;
            this.message = builder.message;
            this.parameters = Collections.unmodifiableMap(builder.parameters);
            this.location = builder.location;
            this.pointer = builder.pointer;
        }

        @Override
        public String getMessage(Locale locale) {
            Arguments.requireNonNull(locale, "locale");
            return this.buildMessage(locale);
        }

        @Override
        public String getContextualMessage(Locale locale) {
            Arguments.requireNonNull(locale, "locale");
            return ProblemRenderer.DEFAULT_RENDERER.render(this, locale);
        }

        @Override
        public void print(Consumer<String> lineConsumer, Locale locale) {
            Arguments.requireNonNull(lineConsumer, "lineConsumer");
            Arguments.requireNonNull(locale, "locale");
            ProblemRenderer.DEFAULT_RENDERER.render(this, locale, lineConsumer);
        }

        @Override
        public JsonLocation getLocation() {
            return this.location;
        }

        @Override
        public String getPointer() {
            return this.pointer;
        }

        @Override
        public JsonSchema getSchema() {
            return this.schema;
        }

        @Override
        public String getKeyword() {
            return this.keyword;
        }

        @Override
        public Map<String, ?> parametersAsMap() {
            return this.parameters;
        }

        @Override
        public boolean isResolvable() {
            return this.resolvable;
        }

        @Override
        public String toString() {
            return this.getContextualMessage();
        }

        private String buildMessage(Locale locale) {
            return this.message.format(this.parameters, locale);
        }
    }

    private static class CompositeProblem
    extends SimpleProblem {
        private final List<List<Problem>> branches;

        CompositeProblem(ProblemBuilder builder) {
            super(builder);
            this.branches = Collections.unmodifiableList(builder.branches);
        }

        @Override
        public boolean hasBranches() {
            return true;
        }

        @Override
        public int countBranches() {
            return this.branches.size();
        }

        @Override
        public List<Problem> getBranch(int index) {
            return this.branches.get(index);
        }
    }
}

