/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.provider;

import jakarta.json.JsonValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.keyword.KeywordFactory;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.annotation.Default;
import org.leadpony.justify.internal.keyword.annotation.Description;
import org.leadpony.justify.internal.keyword.annotation.Title;
import org.leadpony.justify.internal.keyword.applicator.AdditionalItems;
import org.leadpony.justify.internal.keyword.applicator.AdditionalProperties;
import org.leadpony.justify.internal.keyword.applicator.AllOf;
import org.leadpony.justify.internal.keyword.applicator.AnyOf;
import org.leadpony.justify.internal.keyword.applicator.Contains;
import org.leadpony.justify.internal.keyword.applicator.Definitions;
import org.leadpony.justify.internal.keyword.applicator.Dependencies;
import org.leadpony.justify.internal.keyword.applicator.Else;
import org.leadpony.justify.internal.keyword.applicator.If;
import org.leadpony.justify.internal.keyword.applicator.Items;
import org.leadpony.justify.internal.keyword.applicator.Not;
import org.leadpony.justify.internal.keyword.applicator.OneOf;
import org.leadpony.justify.internal.keyword.applicator.PatternProperties;
import org.leadpony.justify.internal.keyword.applicator.Properties;
import org.leadpony.justify.internal.keyword.applicator.PropertyNames;
import org.leadpony.justify.internal.keyword.applicator.Then;
import org.leadpony.justify.internal.keyword.assertion.Const;
import org.leadpony.justify.internal.keyword.assertion.Draft04Maximum;
import org.leadpony.justify.internal.keyword.assertion.Draft04Minimum;
import org.leadpony.justify.internal.keyword.assertion.Draft04Type;
import org.leadpony.justify.internal.keyword.assertion.Enum;
import org.leadpony.justify.internal.keyword.assertion.ExclusiveMaximum;
import org.leadpony.justify.internal.keyword.assertion.ExclusiveMinimum;
import org.leadpony.justify.internal.keyword.assertion.MaxItems;
import org.leadpony.justify.internal.keyword.assertion.MaxLength;
import org.leadpony.justify.internal.keyword.assertion.MaxProperties;
import org.leadpony.justify.internal.keyword.assertion.Maximum;
import org.leadpony.justify.internal.keyword.assertion.MinItems;
import org.leadpony.justify.internal.keyword.assertion.MinLength;
import org.leadpony.justify.internal.keyword.assertion.MinProperties;
import org.leadpony.justify.internal.keyword.assertion.Minimum;
import org.leadpony.justify.internal.keyword.assertion.MultipleOf;
import org.leadpony.justify.internal.keyword.assertion.Pattern;
import org.leadpony.justify.internal.keyword.assertion.Required;
import org.leadpony.justify.internal.keyword.assertion.Type;
import org.leadpony.justify.internal.keyword.assertion.UniqueItems;
import org.leadpony.justify.internal.keyword.assertion.content.ContentEncoding;
import org.leadpony.justify.internal.keyword.assertion.content.ContentMediaType;
import org.leadpony.justify.internal.keyword.assertion.format.Format;
import org.leadpony.justify.internal.keyword.core.Comment;
import org.leadpony.justify.internal.keyword.core.Id;
import org.leadpony.justify.internal.keyword.core.Ref;
import org.leadpony.justify.internal.keyword.core.Schema;

class StandardKeywordFactory
implements KeywordFactory {
    private static final Class<?>[] KEYWORD_CLASSES = new Class[]{Comment.class, Id.class, Ref.class, Schema.class, AdditionalItems.class, AdditionalProperties.class, AllOf.class, AnyOf.class, Comment.class, Const.class, Contains.class, ContentEncoding.class, ContentMediaType.class, Default.class, Definitions.class, Dependencies.class, Description.class, Draft04Maximum.class, Draft04Maximum.ExclusiveMaximum.class, Draft04Minimum.class, Draft04Minimum.ExclusiveMinimum.class, Draft04Type.class, Else.class, Enum.class, ExclusiveMaximum.class, ExclusiveMinimum.class, Format.class, If.class, Items.class, Maximum.class, MaxItems.class, MaxLength.class, MaxProperties.class, Minimum.class, MinItems.class, MinLength.class, MinProperties.class, MultipleOf.class, Not.class, OneOf.class, Pattern.class, PatternProperties.class, PropertyNames.class, Properties.class, Required.class, Then.class, Title.class, Type.class, UniqueItems.class};
    private final Map<String, KeywordMapper> mappers;

    StandardKeywordFactory(Map<String, KeywordMapper> mappers) {
        this.mappers = mappers;
    }

    StandardKeywordFactory(SpecVersion version) {
        this.mappers = this.findMappers(version);
    }

    @Override
    public SchemaKeyword createKeyword(String name, JsonValue value, KeywordFactory.CreationContext context) {
        KeywordMapper mapper = this.mappers.get(name);
        if (mapper == null) {
            return null;
        }
        try {
            return mapper.map(value, context);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private Map<String, KeywordMapper> findMappers(SpecVersion version) {
        HashMap<String, KeywordMapper> mappers = new HashMap<String, KeywordMapper>();
        block0: for (Class<?> clazz : KEYWORD_CLASSES) {
            for (Spec spec : (Spec[])clazz.getAnnotationsByType(Spec.class)) {
                if (spec.value() != version) continue;
                KeywordType keywordType = clazz.getAnnotation(KeywordType.class);
                String name = spec.name();
                if (name.isEmpty()) {
                    name = keywordType.value();
                }
                mappers.put(name, StandardKeywordFactory.getMapper(clazz, name));
                continue block0;
            }
        }
        return mappers;
    }

    private static KeywordMapper getMapper(Class<?> clazz, String name) {
        try {
            Method method = clazz.getMethod("mapper", String.class);
            return (KeywordMapper)method.invoke(null, name);
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = clazz.getMethod("mapper", new Class[0]);
                return (KeywordMapper)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                throw new IllegalStateException(e2);
            }
        }
    }
}

