/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.provider;

import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.base.json.DefaultPointerAwareJsonParser;
import org.leadpony.justify.internal.base.json.JsonService;
import org.leadpony.justify.internal.keyword.KeywordFactory;
import org.leadpony.justify.internal.keyword.assertion.content.ContentAttributes;
import org.leadpony.justify.internal.keyword.assertion.format.FormatAttributes;
import org.leadpony.justify.internal.provider.StandardKeywordFactory;
import org.leadpony.justify.internal.schema.SchemaSpec;
import org.leadpony.justify.internal.schema.io.JsonSchemaReaderImpl;
import org.leadpony.justify.spi.ContentEncodingScheme;
import org.leadpony.justify.spi.ContentMimeType;
import org.leadpony.justify.spi.FormatAttribute;

abstract class StandardSchemaSpec
implements SchemaSpec {
    private final SpecVersion version;
    private final Map<String, FormatAttribute> formatAttributes;
    private final KeywordFactory keywordFactory;
    private final JsonSchema metaschema;
    private final Map<String, ContentEncodingScheme> encodingSchemes = new HashMap<String, ContentEncodingScheme>();
    private final Map<String, ContentMimeType> mimeTypes = new HashMap<String, ContentMimeType>();

    static SchemaSpec[] values(JsonService jsonService) {
        return new SchemaSpec[]{new Draft04SchemaSpec(jsonService), new Draft06SchemaSpec(jsonService), new Draft07SchemaSpec(jsonService)};
    }

    protected StandardSchemaSpec(SpecVersion version, JsonService jsonService) {
        this.version = version;
        this.formatAttributes = FormatAttributes.getAttributes(version);
        this.keywordFactory = new StandardKeywordFactory(version);
        this.metaschema = this.loadMetaschema(version, jsonService);
        this.encodingSchemes.putAll(ContentAttributes.encodingSchemes());
        this.mimeTypes.putAll(ContentAttributes.mimeTypes(jsonService.getJsonProvider()));
    }

    @Override
    public SpecVersion getVersion() {
        return this.version;
    }

    @Override
    public JsonSchema getMetaschema() {
        return this.metaschema;
    }

    @Override
    public KeywordFactory getKeywordFactory() {
        return this.keywordFactory;
    }

    @Override
    public FormatAttribute getFormatAttribute(String name) {
        return this.formatAttributes.get(name);
    }

    @Override
    public ContentEncodingScheme getEncodingScheme(String name) {
        return this.encodingSchemes.get(name);
    }

    @Override
    public ContentMimeType getMimeType(String value) {
        return this.mimeTypes.get(value);
    }

    private JsonSchema loadMetaschema(SpecVersion version, JsonService jsonService) {
        String name = version.toString().toLowerCase() + ".json";
        InputStream in = this.getClass().getResourceAsStream(name);
        JsonProvider jsonProvider = jsonService.getJsonProvider();
        JsonParser realParser = jsonProvider.createParser(in);
        DefaultPointerAwareJsonParser parser = new DefaultPointerAwareJsonParser(realParser, jsonProvider);
        try (JsonSchemaReaderImpl reader = new JsonSchemaReaderImpl(parser, jsonService, this, Collections.emptyMap());){
            JsonSchema jsonSchema = reader.read();
            return jsonSchema;
        }
    }

    private static class Draft04SchemaSpec
    extends StandardSchemaSpec {
        Draft04SchemaSpec(JsonService jsonService) {
            super(SpecVersion.DRAFT_04, jsonService);
        }
    }

    private static class Draft06SchemaSpec
    extends StandardSchemaSpec {
        Draft06SchemaSpec(JsonService jsonService) {
            super(SpecVersion.DRAFT_06, jsonService);
        }
    }

    private static class Draft07SchemaSpec
    extends StandardSchemaSpec {
        Draft07SchemaSpec(JsonService jsonService) {
            super(SpecVersion.DRAFT_07, jsonService);
        }
    }
}

