/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.evaluator.Evaluators;
import org.leadpony.justify.internal.evaluator.LogicalEvaluator;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.annotation.Description;
import org.leadpony.justify.internal.keyword.annotation.Title;
import org.leadpony.justify.internal.problem.ProblemBuilder;
import org.leadpony.justify.internal.problem.ProblemBuilderFactory;
import org.leadpony.justify.internal.schema.AbstractJsonSchema;

public abstract class BasicJsonSchema
extends AbstractJsonSchema
implements ProblemBuilderFactory {
    public static JsonSchema of(URI id, JsonObject json, Map<String, SchemaKeyword> keywords) {
        List<Evaluatable> evaluatables = BasicJsonSchema.collectEvaluatables(keywords);
        if (evaluatables.isEmpty()) {
            return new None(id, json, keywords);
        }
        if (evaluatables.size() == 1) {
            return new One(id, json, keywords, evaluatables.get(0));
        }
        return new Many(id, json, keywords, evaluatables);
    }

    protected BasicJsonSchema(URI id, JsonObject json, Map<String, SchemaKeyword> keywords) {
        super(id, (JsonValue)json, keywords);
    }

    @Override
    public String title() {
        if (!this.containsKeyword("title")) {
            return null;
        }
        Title keyword = (Title)this.getKeyword("title");
        return (String)keyword.value();
    }

    @Override
    public String description() {
        if (!this.containsKeyword("description")) {
            return null;
        }
        Description keyword = (Description)this.getKeyword("description");
        return (String)keyword.value();
    }

    @Override
    public ProblemBuilder createProblemBuilder(EvaluatorContext context) {
        return ProblemBuilderFactory.super.createProblemBuilder(context).withSchema(this);
    }

    private static List<Evaluatable> collectEvaluatables(Map<String, SchemaKeyword> keywords) {
        ArrayList<Evaluatable> evaluatables = new ArrayList<Evaluatable>();
        for (SchemaKeyword keyword : keywords.values()) {
            keyword.addToEvaluatables(evaluatables, keywords);
        }
        return evaluatables;
    }

    private static final class None
    extends BasicJsonSchema {
        private None(URI id, JsonObject json, Map<String, SchemaKeyword> keywords) {
            super(id, json, keywords);
        }

        @Override
        public Evaluator createEvaluator(EvaluatorContext context, InstanceType type) {
            Arguments.requireNonNull(type, "type");
            return Evaluator.ALWAYS_TRUE;
        }

        @Override
        public Evaluator createNegatedEvaluator(EvaluatorContext context, InstanceType type) {
            Arguments.requireNonNull(type, "type");
            return Evaluators.alwaysFalse(this, context);
        }
    }

    private static final class One
    extends BasicJsonSchema {
        private final Evaluatable evaluatable;

        private One(URI id, JsonObject json, Map<String, SchemaKeyword> keywords, Evaluatable evaluatable) {
            super(id, json, keywords);
            this.evaluatable = evaluatable;
        }

        @Override
        public Evaluator createEvaluator(EvaluatorContext context, InstanceType type) {
            Arguments.requireNonNull(type, "type");
            return this.evaluatable.createEvaluator(context, type);
        }

        @Override
        public Evaluator createNegatedEvaluator(EvaluatorContext context, InstanceType type) {
            Arguments.requireNonNull(type, "type");
            return this.evaluatable.createNegatedEvaluator(context, type);
        }
    }

    private static final class Many
    extends BasicJsonSchema {
        private final List<Evaluatable> evaluatables;

        private Many(URI id, JsonObject json, Map<String, SchemaKeyword> keywords, List<Evaluatable> evaluatables) {
            super(id, json, keywords);
            this.evaluatables = evaluatables;
        }

        @Override
        public Evaluator createEvaluator(EvaluatorContext context, InstanceType type) {
            Arguments.requireNonNull(type, "type");
            return this.createCombinedEvaluator(context, type);
        }

        @Override
        public Evaluator createNegatedEvaluator(EvaluatorContext context, InstanceType type) {
            Arguments.requireNonNull(type, "type");
            return this.createCombinedNegatedEvaluator(context, type);
        }

        private Evaluator createCombinedEvaluator(EvaluatorContext context, InstanceType type) {
            LogicalEvaluator evaluator = Evaluators.conjunctive(type);
            for (Evaluatable evaluatable : this.evaluatables) {
                Evaluator child = evaluatable.createEvaluator(context, type);
                evaluator.append(child);
            }
            return evaluator;
        }

        private Evaluator createCombinedNegatedEvaluator(EvaluatorContext context, InstanceType type) {
            LogicalEvaluator evaluator = Evaluators.disjunctive(context, type);
            evaluator.withProblemBuilderFactory(this);
            for (Evaluatable evaluatable : this.evaluatables) {
                Evaluator child = evaluatable.createNegatedEvaluator(context, type);
                evaluator.append(child);
            }
            return evaluator;
        }
    }
}

