/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema.io;

import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaReader;
import org.leadpony.justify.api.JsonSchemaResolver;
import org.leadpony.justify.api.JsonValidatingException;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.problem.ProblemBuilder;
import org.leadpony.justify.internal.problem.ProblemBuilderFactory;

abstract class AbstractJsonSchemaReader
implements JsonSchemaReader,
ProblemBuilderFactory {
    static final URI DEFAULT_INITIAL_BASE_URI = URI.create("");
    private final Map<String, Object> config;
    private final boolean strictWithKeywords;
    private final boolean strictWithFormats;
    private final List<JsonSchemaResolver> resolvers;
    private boolean alreadyRead;
    private boolean alreadyClosed;
    private final List<Problem> problems = new ArrayList<Problem>();

    protected AbstractJsonSchemaReader(Map<String, Object> config) {
        this.config = config;
        this.strictWithKeywords = config.get("org.leadpony.justify.api.JsonSchemaReader.STRICT_KEYWORDS") == Boolean.TRUE;
        this.strictWithFormats = config.get("org.leadpony.justify.api.JsonSchemaReader.STRICT_FORMATS") == Boolean.TRUE;
        this.resolvers = config.getOrDefault("org.leadpony.justify.api.JsonSchemaReader.RESOLVERS", Collections.emptyList());
    }

    @Override
    public final JsonSchema read() {
        if (this.alreadyClosed) {
            throw new IllegalStateException("already closed.");
        }
        if (this.alreadyRead) {
            throw new IllegalStateException("already read.");
        }
        try {
            JsonSchema jsonSchema = this.readSchema();
            return jsonSchema;
        }
        finally {
            this.alreadyRead = true;
        }
    }

    @Override
    public final void close() {
        if (!this.alreadyClosed) {
            try {
                this.closeParser();
            }
            finally {
                this.alreadyClosed = true;
            }
        }
    }

    final Map<String, Object> getConfig() {
        return this.config;
    }

    final boolean isStrictWithKeywords() {
        return this.strictWithKeywords;
    }

    final boolean isStrictWithFormats() {
        return this.strictWithFormats;
    }

    final List<JsonSchemaResolver> getResolvers() {
        return this.resolvers;
    }

    protected void addProblem(Problem problem) {
        this.problems.add(problem);
    }

    protected void addProblem(ProblemBuilder problemBuilder) {
        this.addProblem(problemBuilder.build());
    }

    protected void addProblems(List<Problem> problems) {
        this.problems.addAll(problems);
    }

    protected void dispatchProblems() {
        if (!this.problems.isEmpty()) {
            throw new JsonValidatingException(this.problems);
        }
    }

    protected JsonParsingException newUnexpectedEndException() {
        String message = Message.SCHEMA_PROBLEM_EOI.getLocalized();
        return new JsonParsingException(message, this.getLocation());
    }

    protected abstract JsonSchema readSchema();

    protected abstract JsonLocation getLocation();

    protected abstract void closeParser();
}

