/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema.io;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.internal.schema.SchemaReference;

class InfiniteLoopDetector {
    private final Set<SchemaReference> checkPoints = new HashSet<SchemaReference>();

    InfiniteLoopDetector() {
    }

    boolean detectInfiniteLoop(SchemaReference ref) {
        this.checkPoints.add(ref);
        boolean result = this.detectLoopFrom(ref.getReferencedSchema());
        this.checkPoints.remove(ref);
        assert (this.checkPoints.isEmpty());
        return result;
    }

    private boolean detectLoopFrom(JsonSchema schema) {
        if (this.checkPoints.contains(schema)) {
            return true;
        }
        if (schema instanceof SchemaReference) {
            SchemaReference ref = (SchemaReference)schema;
            this.checkPoints.add(ref);
            boolean result = this.detectLoopFrom(ref.getReferencedSchema());
            this.checkPoints.remove(ref);
            return result;
        }
        Iterator it = schema.getInPlaceSubschemas().iterator();
        while (it.hasNext()) {
            if (!this.detectLoopFrom((JsonSchema)it.next())) continue;
            return true;
        }
        return false;
    }
}

