/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema.io;

import jakarta.json.JsonException;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaReader;
import org.leadpony.justify.api.JsonSchemaReaderFactory;
import org.leadpony.justify.api.JsonSchemaReaderFactoryBuilder;
import org.leadpony.justify.api.JsonSchemaResolver;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.base.ResettableInputStream;
import org.leadpony.justify.internal.base.ResettableReader;
import org.leadpony.justify.internal.base.json.DefaultPointerAwareJsonParser;
import org.leadpony.justify.internal.base.json.JsonService;
import org.leadpony.justify.internal.base.json.PointerAwareJsonParser;
import org.leadpony.justify.internal.schema.SchemaCatalog;
import org.leadpony.justify.internal.schema.SchemaSpec;
import org.leadpony.justify.internal.schema.SchemaSpecRegistry;
import org.leadpony.justify.internal.schema.io.AbstractProbeSchemaReader;
import org.leadpony.justify.internal.schema.io.JsonSchemaReaderImpl;
import org.leadpony.justify.internal.validator.JsonValidator;

public class JsonSchemaReaderFactoryImpl
implements JsonSchemaReaderFactory {
    private final JsonService jsonService;
    protected final JsonParserFactory jsonParserFactory;
    private final SchemaSpecRegistry specRegistry;
    protected final SpecVersion defaultVersion;
    private final JsonSchema metaschema;
    private final Map<String, Object> config;

    public static JsonSchemaReaderFactoryBuilder builder(JsonService jsonService, SchemaSpecRegistry specRegistry) {
        return new Builder(jsonService, specRegistry);
    }

    protected JsonSchemaReaderFactoryImpl(Builder builder) {
        this.jsonService = builder.jsonService;
        this.jsonParserFactory = this.jsonService.getJsonParserFactory();
        this.specRegistry = builder.specRegistry;
        this.config = builder.getConfigAsMap();
        this.defaultVersion = (SpecVersion)((Object)this.config.get("org.leadpony.justify.api.JsonSchemaReader.DEFAULT_SPEC_VERSION"));
        this.metaschema = (JsonSchema)this.config.get("org.leadpony.justify.api.JsonSchemaReader.METASCHEMA");
    }

    @Override
    public JsonSchemaReader createSchemaReader(InputStream in) {
        Arguments.requireNonNull(in, "in");
        SchemaSpec spec = this.getSpec(this.defaultVersion);
        JsonParser realParser = this.jsonParserFactory.createParser(in);
        return this.createSpecificSchemaReader(realParser, spec);
    }

    @Override
    public JsonSchemaReader createSchemaReader(InputStream in, Charset charset) {
        Arguments.requireNonNull(in, "in");
        Arguments.requireNonNull(charset, "charset");
        SchemaSpec spec = this.getSpec(this.defaultVersion);
        JsonParser realParser = this.jsonParserFactory.createParser(in, charset);
        return this.createSpecificSchemaReader(realParser, spec);
    }

    @Override
    public JsonSchemaReader createSchemaReader(Reader reader) {
        Arguments.requireNonNull(reader, "reader");
        SchemaSpec spec = this.getSpec(this.defaultVersion);
        JsonParser realParser = this.jsonParserFactory.createParser(reader);
        return this.createSpecificSchemaReader(realParser, spec);
    }

    @Override
    public JsonSchemaReader createSchemaReader(Path path) {
        Arguments.requireNonNull(path, "path");
        try {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            return this.createSchemaReader(in);
        }
        catch (NoSuchFileException e) {
            throw JsonSchemaReaderFactoryImpl.newJsonException(e, Message.SCHEMA_PROBLEM_NOT_FOUND, path);
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public JsonSchemaReader createSchemaReader(JsonParser parser) {
        Arguments.requireNonNull(parser, "parser");
        SchemaSpec spec = this.getSpec(this.defaultVersion);
        return this.createSpecificSchemaReader(parser, spec);
    }

    protected SchemaSpec getSpec(SpecVersion version) {
        return this.specRegistry.getSpec(version, this.testOption("org.leadpony.justify.api.JsonSchemaReader.CUSTOM_FORMATS"));
    }

    private PointerAwareJsonParser createParser(JsonParser realParser, SchemaSpec spec) {
        if (this.testOption("org.leadpony.justify.api.JsonSchemaReader.SCHEMA_VALIDATION")) {
            JsonSchema metascheam = this.getMetaschema(spec);
            return new JsonValidator(realParser, metascheam, this.jsonService.getJsonProvider());
        }
        return new DefaultPointerAwareJsonParser(realParser, this.jsonService.getJsonProvider());
    }

    private JsonSchema getMetaschema(SchemaSpec spec) {
        if (this.metaschema != null) {
            return this.metaschema;
        }
        return spec.getMetaschema();
    }

    protected JsonSchemaReader createSpecificSchemaReader(JsonParser realParser, SchemaSpec spec) {
        PointerAwareJsonParser parser = this.createParser(realParser, spec);
        return new JsonSchemaReaderImpl(parser, this.jsonService, spec, this.config);
    }

    private static JsonException newJsonException(NoSuchFileException e, Message message, Path path) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("path", path);
        String formatted = message.format(arguments);
        return new JsonException(formatted, (Throwable)e);
    }

    private boolean testOption(String option) {
        return this.config.get(option) == Boolean.TRUE;
    }

    private static final class Builder
    implements JsonSchemaReaderFactoryBuilder {
        private final JsonService jsonService;
        private final SchemaSpecRegistry specRegistry;
        private Map<String, Object> properties;

        private Builder(JsonService jsonService, SchemaSpecRegistry specRegistry) {
            this.jsonService = jsonService;
            this.specRegistry = specRegistry;
        }

        Map<String, Object> getConfigAsMap() {
            return Collections.unmodifiableMap(this.getProperties());
        }

        @Override
        public JsonSchemaReaderFactory build() {
            Map<String, Object> props = this.getProperties();
            JsonSchemaReaderFactoryImpl factory = props.get("org.leadpony.justify.api.JsonSchemaReader.SPEC_VERSION_DETECTION") == Boolean.TRUE ? new DetectableJsonSchemaReaderFactory(this) : new JsonSchemaReaderFactoryImpl(this);
            this.properties = null;
            return factory;
        }

        @Override
        public JsonSchemaReaderFactoryBuilder withStrictKeywords(boolean strict) {
            this.getProperties().put("org.leadpony.justify.api.JsonSchemaReader.STRICT_KEYWORDS", strict);
            return this;
        }

        @Override
        public JsonSchemaReaderFactoryBuilder withStrictFormats(boolean strict) {
            this.getProperties().put("org.leadpony.justify.api.JsonSchemaReader.STRICT_FORMATS", strict);
            return this;
        }

        @Override
        public JsonSchemaReaderFactoryBuilder withSchemaResolver(JsonSchemaResolver resolver) {
            Arguments.requireNonNull(resolver, "resolver");
            List resolvers = (List)this.getProperties().get("org.leadpony.justify.api.JsonSchemaReader.RESOLVERS");
            resolvers.add(resolver);
            return this;
        }

        @Override
        public JsonSchemaReaderFactoryBuilder withCustomFormatAttributes(boolean enabled) {
            this.getProperties().put("org.leadpony.justify.api.JsonSchemaReader.CUSTOM_FORMATS", enabled);
            return this;
        }

        @Override
        public JsonSchemaReaderFactoryBuilder withDefaultSpecVersion(SpecVersion version) {
            Arguments.requireNonNull(version, "version");
            this.getProperties().put("org.leadpony.justify.api.JsonSchemaReader.DEFAULT_SPEC_VERSION", (Object)version);
            return this;
        }

        @Override
        public JsonSchemaReaderFactoryBuilder withSchemaValidation(boolean enabled) {
            this.getProperties().put("org.leadpony.justify.api.JsonSchemaReader.SCHEMA_VALIDATION", enabled);
            return this;
        }

        @Override
        public JsonSchemaReaderFactoryBuilder withSpecVersionDetection(boolean enabled) {
            this.getProperties().put("org.leadpony.justify.api.JsonSchemaReader.SPEC_VERSION_DETECTION", enabled);
            return this;
        }

        @Override
        public JsonSchemaReaderFactoryBuilder withMetaschema(JsonSchema metaschema) {
            Arguments.requireNonNull(metaschema, "metaschema");
            this.getProperties().put("org.leadpony.justify.api.JsonSchemaReader.METASCHEMA", metaschema);
            return this;
        }

        private Map<String, Object> getProperties() {
            if (this.properties == null) {
                this.properties = this.createDefaultProperties();
            }
            return this.properties;
        }

        private Map<String, Object> createDefaultProperties() {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("org.leadpony.justify.api.JsonSchemaReader.CUSTOM_FORMATS", true);
            props.put("org.leadpony.justify.api.JsonSchemaReader.DEFAULT_SPEC_VERSION", (Object)SpecVersion.current());
            props.put("org.leadpony.justify.api.JsonSchemaReader.SCHEMA_VALIDATION", true);
            props.put("org.leadpony.justify.api.JsonSchemaReader.SPEC_VERSION_DETECTION", true);
            ArrayList<SchemaCatalog> resolvers = new ArrayList<SchemaCatalog>();
            resolvers.add(this.specRegistry.getMetaschemaCatalog());
            props.put("org.leadpony.justify.api.JsonSchemaReader.RESOLVERS", resolvers);
            return props;
        }
    }

    private static final class DetectableJsonSchemaReaderFactory
    extends JsonSchemaReaderFactoryImpl {
        private DetectableJsonSchemaReaderFactory(Builder builder) {
            super(builder);
        }

        @Override
        public JsonSchemaReader createSchemaReader(InputStream in) {
            Arguments.requireNonNull(in, "in");
            final ResettableInputStream probeStream = new ResettableInputStream(in);
            JsonParser probeParser = this.jsonParserFactory.createParser((InputStream)probeStream);
            return new AbstractProbeSchemaReader(probeParser, this.defaultVersion){

                @Override
                protected JsonSchemaReader createSchemaReader(SpecVersion version) {
                    SchemaSpec spec = this.getSpec(version);
                    JsonParser realParser = jsonParserFactory.createParser(probeStream.createResettedStream());
                    return this.createSpecificSchemaReader(realParser, spec);
                }
            };
        }

        @Override
        public JsonSchemaReader createSchemaReader(InputStream in, final Charset charset) {
            Arguments.requireNonNull(in, "in");
            Arguments.requireNonNull(charset, "charset");
            final ResettableInputStream probeStream = new ResettableInputStream(in);
            JsonParser probeParser = this.jsonParserFactory.createParser((InputStream)probeStream, charset);
            return new AbstractProbeSchemaReader(probeParser, this.defaultVersion){

                @Override
                protected JsonSchemaReader createSchemaReader(SpecVersion version) {
                    SchemaSpec spec = this.getSpec(version);
                    JsonParser realParser = jsonParserFactory.createParser(probeStream.createResettedStream(), charset);
                    return this.createSpecificSchemaReader(realParser, spec);
                }
            };
        }

        @Override
        public JsonSchemaReader createSchemaReader(Reader reader) {
            Arguments.requireNonNull(reader, "reader");
            final ResettableReader probeReader = new ResettableReader(reader);
            JsonParser probeParser = this.jsonParserFactory.createParser((Reader)probeReader);
            return new AbstractProbeSchemaReader(probeParser, this.defaultVersion){

                @Override
                protected JsonSchemaReader createSchemaReader(SpecVersion version) {
                    SchemaSpec spec = this.getSpec(version);
                    JsonParser realParser = jsonParserFactory.createParser(probeReader.createResettedReader());
                    return this.createSpecificSchemaReader(realParser, spec);
                }
            };
        }
    }
}

