/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.validator;

import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.internal.base.json.JsonValueParser;
import org.leadpony.justify.internal.validator.JsonValidator;

public class DefaultizingJsonValidator
extends JsonValidator {
    private final JsonParser realParser;
    private final Map<String, JsonValue> defaultProperties = new LinkedHashMap<String, JsonValue>();
    private final List<JsonValue> defaultItems = new ArrayList<JsonValue>();
    private boolean defaultValuesInserted;

    public DefaultizingJsonValidator(JsonParser realParser, JsonSchema rootSchema, JsonProvider jsonProvider) {
        super(realParser, rootSchema, jsonProvider);
        this.realParser = realParser;
    }

    public boolean isFilling() {
        return this.getCurrentParser() != this.realParser;
    }

    @Override
    public boolean acceptsDefaultValues() {
        return true;
    }

    @Override
    public void putDefaultProperties(Map<String, JsonValue> properties) {
        this.defaultProperties.putAll(properties);
        this.defaultValuesInserted = true;
    }

    @Override
    public void putDefaultItems(List<JsonValue> items) {
        if (this.defaultItems.isEmpty()) {
            this.defaultItems.addAll(items);
        } else {
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                if (i < this.defaultItems.size()) {
                    this.defaultItems.set(i, items.get(i));
                    continue;
                }
                this.defaultItems.add(items.get(i));
            }
        }
        this.defaultValuesInserted = true;
    }

    @Override
    protected JsonParser.Event process(JsonParser.Event event) {
        super.process(event);
        if (this.defaultValuesInserted) {
            this.replaceParser();
            this.defaultValuesInserted = false;
            return this.getCurrentParser().next();
        }
        return event;
    }

    @Override
    protected void dispatchProblems() {
        if (!this.isFilling()) {
            super.dispatchProblems();
        }
    }

    private void replaceParser() {
        this.setCurrentParser(this.createDefaultValueParser());
        this.setEventHandler(this::handleEventFromDefaultValues);
    }

    private JsonParser createDefaultValueParser() {
        if (!this.defaultProperties.isEmpty()) {
            return new JsonValueParser(this.defaultProperties);
        }
        if (!this.defaultItems.isEmpty()) {
            return new JsonValueParser(this.defaultItems);
        }
        throw new IllegalStateException();
    }

    private void handleEventFromDefaultValues(JsonParser.Event event, JsonParser parser) {
        if (!this.getCurrentParser().hasNext()) {
            this.setCurrentParser(this.realParser);
            this.resetEventHandler();
            this.defaultProperties.clear();
            this.defaultItems.clear();
            if (this.hasProblems()) {
                this.dispatchProblems();
            }
        }
    }
}

