/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.validator;

import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemHandler;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.json.DefaultPointerAwareJsonParser;
import org.leadpony.justify.internal.base.json.ParserEvents;
import org.leadpony.justify.internal.problem.DefaultProblemDispatcher;
import org.leadpony.justify.internal.validator.ParserEventHandler;

public class JsonValidator
extends DefaultPointerAwareJsonParser
implements EvaluatorContext,
DefaultProblemDispatcher,
ParserEventHandler {
    private final JsonSchema rootSchema;
    private ProblemHandler problemHandler;
    private ParserEventHandler eventHandler;
    private Evaluator evaluator;
    private int depth;
    private final List<Problem> currentProblems = new ArrayList<Problem>();

    public JsonValidator(JsonParser realParser, JsonSchema rootSchema, JsonProvider jsonProvider) {
        super(realParser, jsonProvider);
        this.rootSchema = rootSchema;
        this.problemHandler = ProblemHandler.throwing();
        this.eventHandler = this::handleFirstEvent;
    }

    public JsonValidator withHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
        return this;
    }

    @Override
    protected JsonParser.Event process(JsonParser.Event event) {
        this.eventHandler.handleParserEvent(event, this.getParser());
        return event;
    }

    @Override
    protected void postprocess() {
        if (this.hasProblems()) {
            this.dispatchProblems();
        }
    }

    @Override
    public JsonParser getParser() {
        return this.getCurrentParser();
    }

    @Override
    public boolean acceptsDefaultValues() {
        return false;
    }

    @Override
    public void putDefaultProperties(Map<String, JsonValue> defaultValues) {
        assert (false);
    }

    @Override
    public void putDefaultItems(List<JsonValue> items) {
        assert (false);
    }

    @Override
    public void dispatchProblem(Problem problem) {
        Arguments.requireNonNull(problem, "problem");
        this.currentProblems.add(problem);
    }

    private void handleFirstEvent(JsonParser.Event event, JsonParser parser) {
        InstanceType type = ParserEvents.toBroadInstanceType(event);
        this.evaluator = this.rootSchema.createEvaluator(this, type);
        if (this.evaluator != null) {
            this.handleParserEvent(event, parser);
        }
        this.eventHandler = this.evaluator != null ? this : ParserEventHandler.IDLE;
    }

    @Override
    public void handleParserEvent(JsonParser.Event event, JsonParser parser) {
        super.process(event);
        if (ParserEvents.isEndOfContainer(event) && --this.depth == 0) {
            this.eventHandler = ParserEventHandler.IDLE;
        }
        Evaluator.Result result = this.evaluator.evaluate(event, this.depth, this);
        if (ParserEvents.isStartOfContainer(event)) {
            ++this.depth;
        }
        if (result != Evaluator.Result.PENDING) {
            this.evaluator = null;
            this.eventHandler = ParserEventHandler.IDLE;
        }
        if (this.depth == 0) assert (this.evaluator == null);
    }

    protected final boolean hasProblems() {
        return !this.currentProblems.isEmpty();
    }

    protected void dispatchProblems() {
        this.problemHandler.handleProblems(this.currentProblems);
        this.currentProblems.clear();
    }

    protected void setEventHandler(ParserEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    protected void resetEventHandler() {
        this.eventHandler = this.evaluator != null ? this : ParserEventHandler.IDLE;
    }
}

