/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.UnicodeCharset$;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag$;

public class BomEncoder
extends CharsetEncoder {
    private final Charset charset;
    private final byte[] bom;
    private boolean isBomWritten;

    public BomEncoder(Charset charset) {
        this.charset = charset;
        super(charset, 1.0f, 1.0f);
        this.bom = (byte[])((IterableOnceOps)UnicodeCharset$.MODULE$.bomTable().getOrElse((Object)charset, () -> BomEncoder.$init$$$anonfun$1(charset))).toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
        this.isBomWritten = false;
    }

    @Override
    public CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        block6: {
            if (!this.isBomWritten) {
                CoderResult coderResult;
                try {
                    try {
                        out.put(this.bom);
                        break block6;
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        coderResult = CoderResult.OVERFLOW;
                    }
                }
                finally {
                    this.isBomWritten = true;
                }
                return coderResult;
            }
        }
        return this.charset.newEncoder().encode(in, out, true);
    }

    @Override
    public void implReset() {
        this.isBomWritten = false;
    }

    private static final IndexedSeq $init$$$anonfun$1(Charset charset$1) {
        throw new IllegalArgumentException(new StringBuilder(22).append(charset$1).append(" does not support BOMs").toString());
    }
}

