/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.File;
import better.files.File$;
import better.files.FileMonitor$;
import better.files.package$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public abstract class FileMonitor
implements File.Monitor {
    private final File root;
    private final int maxDepth;
    private final WatchService service;

    public static boolean $lessinit$greater$default$2() {
        return FileMonitor$.MODULE$.$lessinit$greater$default$2();
    }

    public FileMonitor(File root, int maxDepth) {
        this.root = root;
        this.maxDepth = maxDepth;
        this.service = root.newWatchService();
    }

    @Override
    public File root() {
        return this.root;
    }

    public WatchService service() {
        return this.service;
    }

    public FileMonitor(File root, boolean recursive) {
        this(root, recursive ? Integer.MAX_VALUE : 0);
    }

    public boolean reactTo(File target) {
        return this.root().isDirectory(this.root().isDirectory$default$1()) || this.root().isSamePathAs(target);
    }

    public boolean process(WatchKey key) {
        Path path = (Path)key.watchable();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(key.pollEvents()).asScala()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            WatchEvent event;
            WatchEvent watchEvent = x$1;
            if (watchEvent != null && (event = watchEvent).context() != null) {
                File target = File$.MODULE$.apply(path.resolve((Path)event.context()));
                if (this.reactTo(target)) {
                    WatchEvent.Kind kind = event.kind();
                    WatchEvent.Kind<Path> kind2 = StandardWatchEventKinds.ENTRY_CREATE;
                    if (!(kind != null ? !kind.equals(kind2) : kind2 != null)) {
                        int depth = this.root().relativize(target).getNameCount();
                        this.watch(target, RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.maxDepth - depth), 0));
                    }
                    this.onEvent(event.kind(), target, event.count());
                    return;
                }
                return;
            }
            WatchEvent event2 = watchEvent;
            if (this.reactTo(File$.MODULE$.apply(path))) {
                this.onUnknownEvent(event2);
                return;
            }
        });
        return key.reset();
    }

    public void watch(File file, int depth) {
        try {
            FileMonitor.toWatch$1(file, depth).foreach((Function1)(JProcedure1 & Serializable)f -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.watch$$anonfun$1$$anonfun$1((File)f);
                return BoxedUnit.UNIT;
            }).recover((PartialFunction)new Serializable(this){
                private final /* synthetic */ FileMonitor $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    this.$outer.onException(e);
                    return BoxedUnit.UNIT;
                }
            }).get());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.onException(e);
            }
            throw throwable;
        }
    }

    @Override
    public void start(ExecutionContext executionContext) {
        this.watch(this.root(), this.maxDepth);
        executionContext.execute(new Runnable(this){
            private final /* synthetic */ FileMonitor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                scala.concurrent.package$.MODULE$.blocking((Function0 & Serializable)() -> {
                    this.run$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
            }

            private final WatchKey run$$anonfun$1$$anonfun$1() {
                return this.$outer.service().take();
            }

            private final void run$$anonfun$1() {
                scala.package$.MODULE$.Iterator().continually(this::run$$anonfun$1$$anonfun$1).foreach((Function1 & Serializable)key -> this.$outer.process((WatchKey)key));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$adapted$1(), run$$anonfun$1$$anonfun$1(), run$$anonfun$1$$anonfun$2(java.nio.file.WatchKey )}, serializedLambda);
            }
        });
    }

    @Override
    public void close() {
        this.service().close();
    }

    @Override
    public void onCreate(File file, int count) {
    }

    @Override
    public void onModify(File file, int count) {
    }

    @Override
    public void onDelete(File file, int count) {
    }

    @Override
    public void onUnknownEvent(WatchEvent<?> event) {
    }

    @Override
    public void onException(Throwable exception) {
    }

    private static final File toWatch$1$$anonfun$2(File file$2) {
        return file$2.parent();
    }

    private static final Iterator toWatch$1(File file$1, int depth$1) {
        if (file$1.isDirectory(file$1.isDirectory$default$1())) {
            return file$1.walk(depth$1, file$1.walk$default$2(depth$1)).filter((Function1 & Serializable)f -> f.isDirectory(f.isDirectory$default$1()) && f.exists(f.exists$default$1()));
        }
        return package$.MODULE$.when(file$1.exists(file$1.exists$default$1()), () -> FileMonitor.toWatch$1$$anonfun$2(file$1)).iterator();
    }

    private final void watch$$anonfun$1$$anonfun$1(File f$1) {
        f$1.register(this.service(), f$1.register$default$2());
    }
}

