/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.WriterOutputStream$;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;

public class WriterOutputStream
extends OutputStream {
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final boolean flushImmediately;
    private final CharBuffer decoderOut;
    private final ByteBuffer decoderIn;

    public static int $lessinit$greater$default$2() {
        return WriterOutputStream$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return WriterOutputStream$.MODULE$.$lessinit$greater$default$3();
    }

    public static Charset $lessinit$greater$default$4(Writer writer, int n, boolean bl) {
        return WriterOutputStream$.MODULE$.$lessinit$greater$default$4(writer, n, bl);
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder, int bufferSize, boolean flushImmediately) {
        this.writer = writer;
        this.decoder = decoder;
        this.flushImmediately = flushImmediately;
        this.decoderOut = CharBuffer.allocate(bufferSize);
        this.decoderIn = ByteBuffer.allocate(bufferSize >> 4);
    }

    public WriterOutputStream(Writer writer, int bufferSize, boolean flushImmediately, Charset charset) {
        this(writer, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), bufferSize, flushImmediately);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.loop$1(b, off, len);
        if (this.flushImmediately) {
            this.flushOutput();
            return;
        }
    }

    @Override
    public void write(int b) {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void flush() {
        this.flushOutput();
        this.writer.flush();
    }

    @Override
    public void close() {
        this.processInput(true);
        this.flushOutput();
        this.writer.close();
    }

    private ByteBuffer processInput(boolean endOfInput) {
        this.decoderIn.flip();
        this.loop$2(endOfInput);
        return this.decoderIn.compact();
    }

    private void flushOutput() {
        int p = this.decoderOut.position();
        if (p > 0) {
            this.writer.write(this.decoderOut.array(), 0, p);
            Buffer buffer = this.decoderOut.rewind();
            return;
        }
    }

    private final void loop$1(byte[] b$1, int off, int len) {
        while (len > 0) {
            int c = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.decoderIn.remaining()), len);
            this.decoderIn.put(b$1, off, c);
            this.processInput(false);
            int n = off + c;
            int n2 = len - c;
            off = n;
            len = n2;
        }
    }

    private final void loop$2(boolean endOfInput$1) {
        CoderResult coderResult;
        while ((coderResult = this.decoder.decode(this.decoderIn, this.decoderOut, endOfInput$1)).isOverflow()) {
            this.flushOutput();
        }
        if (!coderResult.isUnderflow()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"decoder is configured to replace malformed input and unmappable characters");
        }
    }
}

