/*
 * Decompiled with CFR 0.152.
 */
package laika.api;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import java.io.Serializable;
import laika.api.MarkupParser$;
import laika.api.builder.OperationConfig;
import laika.api.builder.ParserBuilder;
import laika.ast.Document;
import laika.ast.Element;
import laika.ast.EmbeddedConfigValue;
import laika.ast.Path;
import laika.ast.Path$Root$;
import laika.ast.RewritePhase;
import laika.ast.RewritePhase$Build$;
import laika.ast.RewritePhase$Resolve$;
import laika.ast.RewriteRules;
import laika.ast.RootElement;
import laika.ast.TreePosition;
import laika.ast.UnresolvedDocument;
import laika.config.Config;
import laika.config.ConfigError;
import laika.config.ConfigValue;
import laika.config.Origin$;
import laika.config.Origin$DocumentScope$;
import laika.factory.MarkupFormat;
import laika.parse.directive.ConfigHeaderParser$;
import laika.parse.markup.DocumentParser;
import laika.parse.markup.DocumentParser$;
import laika.parse.markup.DocumentParser$DocumentInput$;
import laika.parse.markup.DocumentParser$InvalidDocument$;
import laika.parse.markup.DocumentParser$ParserError$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.util.Either;

public class MarkupParser {
    private final MarkupFormat format;
    private final OperationConfig config;
    private final Set fileSuffixes;
    private final Path fallbackPath;
    private final Function1<DocumentParser.DocumentInput, Either<DocumentParser.ParserError, UnresolvedDocument>> docParser;

    public static ParserBuilder of(MarkupFormat markupFormat) {
        return MarkupParser$.MODULE$.of(markupFormat);
    }

    public MarkupParser(MarkupFormat format, OperationConfig config) {
        this.format = format;
        this.config = config;
        this.fileSuffixes = format.fileSuffixes();
        this.fallbackPath = (Path)Path$Root$.MODULE$.$div("doc");
        this.docParser = DocumentParser$.MODULE$.forMarkup(format, config.markupExtensions(), config.configProvider());
    }

    public MarkupFormat format() {
        return this.format;
    }

    public OperationConfig config() {
        return this.config;
    }

    public Set<String> fileSuffixes() {
        return this.fileSuffixes;
    }

    public Either<DocumentParser.ParserError, Document> parse(String input) {
        return this.parse(DocumentParser$DocumentInput$.MODULE$.apply(this.fallbackPath, input));
    }

    public Either<DocumentParser.ParserError, Document> parse(String input, Path path) {
        return this.parse(DocumentParser$DocumentInput$.MODULE$.apply(path, input));
    }

    public Either<DocumentParser.ParserError, Document> parse(DocumentParser.DocumentInput input) {
        return ((Either)this.docParser.apply((Object)input)).flatMap((Function1 & Serializable)unresolved -> unresolved.config().resolve(Origin$.MODULE$.apply(Origin$DocumentScope$.MODULE$, input.path(), Origin$.MODULE$.$lessinit$greater$default$3()), this.config().baseConfig(), unresolved.config().resolve$default$3()).left().map((Function1 & Serializable)_$4 -> DocumentParser$ParserError$.MODULE$.apply((ConfigError)_$4, input.path())).map((Function1 & Serializable)resolvedConfig -> {
            Document resolvedDoc = MarkupParser.resolveDocument$1(unresolved, resolvedConfig);
            return Tuple2$.MODULE$.apply(resolvedConfig, (Object)resolvedDoc);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Config resolvedConfig = (Config)tuple2._1();
                Document resolvedDoc = (Document)tuple2._2();
                return this.rewriteDocument$1(resolvedDoc).map((Function1 & Serializable)result -> result);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public Either<DocumentParser.ParserError, UnresolvedDocument> parseUnresolved(String input) {
        return this.parseUnresolved(DocumentParser$DocumentInput$.MODULE$.apply(this.fallbackPath, input));
    }

    public Either<DocumentParser.ParserError, UnresolvedDocument> parseUnresolved(String input, Path path) {
        return this.parseUnresolved(DocumentParser$DocumentInput$.MODULE$.apply(path, input));
    }

    public Either<DocumentParser.ParserError, UnresolvedDocument> parseUnresolved(DocumentParser.DocumentInput input) {
        return (Either)this.docParser.apply((Object)input);
    }

    private static final Document resolveDocument$1(UnresolvedDocument unresolved, Config docConfig) {
        List embeddedConfig = unresolved.document().content().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Element x) {
                Element element = x;
                if (element instanceof EmbeddedConfigValue) {
                    EmbeddedConfigValue c = (EmbeddedConfigValue)element;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Element x, Function1 function1) {
                Element element = x;
                if (element instanceof EmbeddedConfigValue) {
                    EmbeddedConfigValue c = (EmbeddedConfigValue)element;
                    return Tuple2$.MODULE$.apply((Object)c.key(), (Object)c.value());
                }
                return function1.apply((Object)x);
            }
        });
        Config config = ConfigHeaderParser$.MODULE$.merge(docConfig, (Seq<Tuple2<String, ConfigValue>>)embeddedConfig);
        Path path = unresolved.document().copy$default$1();
        RootElement rootElement = unresolved.document().copy$default$2();
        Map<String, Element> map = unresolved.document().copy$default$3();
        TreePosition treePosition = unresolved.document().copy$default$5();
        return unresolved.document().copy(path, rootElement, map, config, treePosition);
    }

    private final Either rewritePhase$1(Document doc, RewritePhase phase) {
        Either either = package.all$.MODULE$.catsSyntaxEither(this.config().rewriteRulesFor(doc, phase));
        return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$1 -> DocumentParser$ParserError$.MODULE$.apply((ConfigError)_$1, doc.path())).flatMap((Function1 & Serializable)rules -> {
            Either either = package.all$.MODULE$.catsSyntaxEither(doc.rewrite((RewriteRules)rules));
            return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$2 -> DocumentParser$ParserError$.MODULE$.apply((ConfigError)_$2, doc.path())).map((Function1 & Serializable)result -> result);
        });
    }

    private static final Document rewriteDocument$1$$anonfun$1$$anonfun$1$$anonfun$2(Document phase2$1) {
        return phase2$1;
    }

    private final Either rewriteDocument$1(Document resolvedDoc) {
        return this.rewritePhase$1(resolvedDoc, RewritePhase$Build$.MODULE$).flatMap((Function1 & Serializable)phase1 -> this.rewritePhase$1((Document)phase1, RewritePhase$Resolve$.MODULE$).flatMap((Function1 & Serializable)phase2 -> DocumentParser$InvalidDocument$.MODULE$.from((Document)phase2, this.config().failOnMessages()).map((Function1 & Serializable)_$3 -> DocumentParser$ParserError$.MODULE$.apply((DocumentParser.InvalidDocument)_$3)).toLeft(() -> MarkupParser.rewriteDocument$1$$anonfun$1$$anonfun$1$$anonfun$2(phase2)).map((Function1 & Serializable)result -> result)));
    }
}

