/*
 * Decompiled with CFR 0.152.
 */
package laika.api;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import java.io.Serializable;
import laika.api.Renderer$;
import laika.api.builder.OperationConfig;
import laika.api.builder.RendererBuilder;
import laika.api.builder.TwoPhaseRendererBuilder;
import laika.ast.Block;
import laika.ast.Document;
import laika.ast.Document$;
import laika.ast.Element;
import laika.ast.Paragraph$;
import laika.ast.Path;
import laika.ast.Path$Root$;
import laika.ast.RewritePhase;
import laika.ast.RewritePhase$Render$;
import laika.ast.RootElement;
import laika.ast.RootElement$;
import laika.ast.Span;
import laika.ast.StyleDeclarationSet;
import laika.ast.StyleDeclarationSet$;
import laika.ast.TemplateElement$;
import laika.config.ConfigError;
import laika.factory.MarkupFormat;
import laika.factory.RenderContext;
import laika.factory.RenderContext$;
import laika.factory.RenderFormat;
import laika.factory.TwoPhaseRenderFormat;
import laika.parse.markup.DocumentParser;
import laika.parse.markup.DocumentParser$RendererError$;
import laika.rewrite.OutputContext$;
import laika.rewrite.nav.NoOpPathTranslator$;
import laika.rewrite.nav.PathTranslator;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public abstract class Renderer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Renderer.class.getDeclaredField("renderFunction$lzy1"));
    private final OperationConfig config;
    private final boolean skipRewrite;
    private volatile Object renderFunction$lzy1;
    private final PathTranslator defaultPathTranslator;

    public static <FMT> RendererBuilder<FMT> of(RenderFormat<FMT> renderFormat) {
        return Renderer$.MODULE$.of(renderFormat);
    }

    public static <FMT, PP> TwoPhaseRendererBuilder<FMT, PP> of(TwoPhaseRenderFormat<FMT, PP> twoPhaseRenderFormat) {
        return Renderer$.MODULE$.of(twoPhaseRenderFormat);
    }

    public static boolean $lessinit$greater$default$2() {
        return Renderer$.MODULE$.$lessinit$greater$default$2();
    }

    public Renderer(OperationConfig config, boolean skipRewrite) {
        this.config = config;
        this.skipRewrite = skipRewrite;
        this.defaultPathTranslator = NoOpPathTranslator$.MODULE$;
    }

    public OperationConfig config() {
        return this.config;
    }

    public abstract RenderFormat<Object> format();

    public Renderer forInputFormat(MarkupFormat markupFormat) {
        return new RendererBuilder<Object>(this.format(), this.config().withBundlesFor(markupFormat), this.skipRewrite).build();
    }

    private Function2<Object, Element, String> renderFunction() {
        Object object = this.renderFunction$lzy1;
        if (object instanceof Function2) {
            return (Function2)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function2)this.renderFunction$lzyINIT1();
    }

    private Object renderFunction$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.renderFunction$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Function2 & Serializable intersect = null;
                    Function2 & Serializable intersect2 = null;
                    try {
                        intersect2 = (Function2 & Serializable)(fmt, element) -> (String)this.config().renderOverridesFor(this.format()).value().applyOrElse((Object)Tuple2$.MODULE$.apply(fmt, element), (Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Object f = tuple2._1();
                                Element e = (Element)tuple2._2();
                                return (String)this.format().defaultRenderer().apply(f, (Object)e);
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        intersect = intersect2 == null ? LazyVals.NullValue$.MODULE$ : intersect2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, (Object)intersect)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.renderFunction$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, (Object)intersect);
                            waiting.countDown();
                        }
                    }
                    return intersect2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Either<DocumentParser.RendererError, String> render(Document doc) {
        return this.render(doc, doc.content(), this.defaultPathTranslator, StyleDeclarationSet$.MODULE$.empty());
    }

    public Either<DocumentParser.RendererError, String> render(Document doc, PathTranslator pathTranslator, StyleDeclarationSet styles) {
        return this.render(doc, doc.content(), pathTranslator, styles);
    }

    public Either<DocumentParser.RendererError, String> render(Element element) {
        return this.render(element, (Path)Path$Root$.MODULE$.$div("doc").withSuffix(this.format().fileSuffix()));
    }

    public Either<DocumentParser.RendererError, String> render(Element element, Path path) {
        return this.render(element, path, this.defaultPathTranslator, StyleDeclarationSet$.MODULE$.empty());
    }

    public Either<DocumentParser.RendererError, String> render(Element element, Path path, PathTranslator pathTranslator, StyleDeclarationSet styles) {
        RootElement rootElement;
        Element element2 = element;
        if (element2 instanceof RootElement) {
            RootElement root;
            rootElement = root = (RootElement)element2;
        } else if (element2 instanceof Block) {
            Block block = (Block)((Object)element2);
            rootElement = (RootElement)RootElement$.MODULE$.apply(block, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Block[0]));
        } else if (element2 instanceof Span) {
            Span span = (Span)((Object)element2);
            rootElement = (RootElement)RootElement$.MODULE$.apply((Block)Paragraph$.MODULE$.apply(span, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Block[0]));
        } else {
            Element other = element2;
            rootElement = (RootElement)RootElement$.MODULE$.apply((Block)Paragraph$.MODULE$.apply((Span)TemplateElement$.MODULE$.apply(other, TemplateElement$.MODULE$.$lessinit$greater$default$2(), TemplateElement$.MODULE$.$lessinit$greater$default$3()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Block[0]));
        }
        RootElement rootElement2 = rootElement;
        return this.render(Document$.MODULE$.apply(path, rootElement2, Document$.MODULE$.$lessinit$greater$default$3(), Document$.MODULE$.$lessinit$greater$default$4(), Document$.MODULE$.$lessinit$greater$default$5()), element, pathTranslator, styles);
    }

    private Either<DocumentParser.RendererError, String> render(Document doc, Element targetElement, PathTranslator pathTranslator, StyleDeclarationSet styles) {
        return (this.skipRewrite ? package$.MODULE$.Right().apply((Object)targetElement) : this.rewrite$1(doc, targetElement)).map((Function1 & Serializable)elementToRender -> {
            RenderContext<Object> renderContext = RenderContext$.MODULE$.apply(this.renderFunction(), (Element)elementToRender, styles, doc.path(), pathTranslator, this.config());
            Object formatter = this.format().formatterFactory().apply(renderContext);
            return (String)this.renderFunction().apply(formatter, elementToRender);
        });
    }

    public Renderer skipRewritePhase() {
        return new Renderer(this){
            private final /* synthetic */ Renderer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.config(), true);
            }

            public RenderFormat format() {
                return this.$outer.format();
            }
        };
    }

    private final Either rewrite$1(Document doc$1, Element targetElement$1) {
        Either either = package.all$.MODULE$.catsSyntaxEither(this.config().rewriteRulesFor(doc$1, (RewritePhase)RewritePhase$Render$.MODULE$.apply(OutputContext$.MODULE$.apply(this.format()))).map((Function1 & Serializable)_$1 -> _$1.rewriteElement(targetElement$1)));
        return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$2 -> DocumentParser$RendererError$.MODULE$.apply((ConfigError)_$2, doc$1.path()));
    }
}

