/*
 * Decompiled with CFR 0.152.
 */
package laika.api.builder;

import laika.api.MarkupParser;
import laika.api.Renderer;
import laika.api.Transformer;
import laika.api.builder.OperationConfig;
import laika.api.builder.RendererBuilder;
import laika.api.builder.RendererBuilder$;
import laika.api.builder.TransformerBuilderOps;
import laika.ast.DocumentType$Markup$;
import laika.ast.TextDocumentType;
import laika.factory.MarkupFormat;
import laika.factory.RenderFormat;

public class TransformerBuilder<FMT>
implements TransformerBuilderOps<FMT> {
    private final MarkupFormat markupFormat;
    private final RenderFormat renderFormat;
    private final OperationConfig config;
    private final TextDocumentType docType;

    public TransformerBuilder(MarkupFormat markupFormat, RenderFormat<FMT> renderFormat, OperationConfig config) {
        this.markupFormat = markupFormat;
        this.renderFormat = renderFormat;
        this.config = config;
        this.docType = DocumentType$Markup$.MODULE$;
    }

    @Override
    public RenderFormat<FMT> renderFormat() {
        return this.renderFormat;
    }

    @Override
    public OperationConfig config() {
        return this.config;
    }

    public TextDocumentType docType() {
        return this.docType;
    }

    @Override
    public TransformerBuilder<FMT> withConfig(OperationConfig newConfig) {
        return new TransformerBuilder<FMT>(this.markupFormat, this.renderFormat(), newConfig);
    }

    public Transformer build() {
        MarkupParser parser = new MarkupParser(this.markupFormat, this.config());
        Renderer renderer = new RendererBuilder<FMT>(this.renderFormat(), this.config(), RendererBuilder$.MODULE$.$lessinit$greater$default$3()).build();
        return new Transformer(parser, renderer);
    }
}

