/*
 * Decompiled with CFR 0.152.
 */
package laika.api.builder;

import laika.api.builder.OperationConfig;
import laika.api.builder.RendererBuilderOps;
import laika.factory.RenderFormat;
import laika.factory.TwoPhaseRenderFormat;

public class TwoPhaseRendererBuilder<FMT, PP>
implements RendererBuilderOps<FMT> {
    private final TwoPhaseRenderFormat twoPhaseFormat;
    private final OperationConfig config;
    private final RenderFormat renderFormat;

    public TwoPhaseRendererBuilder(TwoPhaseRenderFormat<FMT, PP> twoPhaseFormat, OperationConfig config) {
        this.twoPhaseFormat = twoPhaseFormat;
        this.config = config;
        this.renderFormat = twoPhaseFormat.interimFormat();
    }

    public TwoPhaseRenderFormat<FMT, PP> twoPhaseFormat() {
        return this.twoPhaseFormat;
    }

    @Override
    public OperationConfig config() {
        return this.config;
    }

    @Override
    public RenderFormat<FMT> renderFormat() {
        return this.renderFormat;
    }

    @Override
    public TwoPhaseRendererBuilder<FMT, PP> withConfig(OperationConfig newConfig) {
        return new TwoPhaseRendererBuilder<FMT, PP>(this.twoPhaseFormat(), newConfig);
    }
}

