/*
 * Decompiled with CFR 0.152.
 */
package laika.api.builder;

import laika.api.builder.OperationConfig;
import laika.api.builder.TransformerBuilderOps;
import laika.factory.MarkupFormat;
import laika.factory.RenderFormat;
import laika.factory.TwoPhaseRenderFormat;

public class TwoPhaseTransformerBuilder<FMT, PP>
implements TransformerBuilderOps<FMT> {
    private final MarkupFormat markupFormat;
    private final TwoPhaseRenderFormat twoPhaseRenderFormat;
    private final OperationConfig config;
    private final RenderFormat renderFormat;

    public TwoPhaseTransformerBuilder(MarkupFormat markupFormat, TwoPhaseRenderFormat<FMT, PP> twoPhaseRenderFormat, OperationConfig config) {
        this.markupFormat = markupFormat;
        this.twoPhaseRenderFormat = twoPhaseRenderFormat;
        this.config = config;
        this.renderFormat = twoPhaseRenderFormat.interimFormat();
    }

    public MarkupFormat markupFormat() {
        return this.markupFormat;
    }

    public TwoPhaseRenderFormat<FMT, PP> twoPhaseRenderFormat() {
        return this.twoPhaseRenderFormat;
    }

    @Override
    public OperationConfig config() {
        return this.config;
    }

    @Override
    public RenderFormat<FMT> renderFormat() {
        return this.renderFormat;
    }

    @Override
    public TwoPhaseTransformerBuilder<FMT, PP> withConfig(OperationConfig newConfig) {
        return new TwoPhaseTransformerBuilder<FMT, PP>(this.markupFormat(), this.twoPhaseRenderFormat(), newConfig);
    }
}

