/*
 * Decompiled with CFR 0.152.
 */
package laika.ast;

import cats.Applicative;
import cats.Invariant$;
import cats.NonEmptyParallel;
import cats.NonEmptyParallel$;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyChainImpl$;
import cats.syntax.EitherOps$;
import cats.syntax.ParallelSequenceOps1$;
import cats.syntax.package;
import java.io.Serializable;
import laika.ast.Cursor;
import laika.ast.Document;
import laika.ast.DocumentCursor;
import laika.ast.DocumentCursor$;
import laika.ast.DocumentTree;
import laika.ast.Path;
import laika.ast.RewriteRules;
import laika.ast.RootCursor;
import laika.ast.TreeContent;
import laika.ast.TreeCursor$;
import laika.ast.TreePosition;
import laika.config.Config;
import laika.config.ConfigError;
import laika.config.DocumentConfigErrors$;
import laika.config.TreeConfigErrors;
import laika.config.TreeConfigErrors$;
import laika.rewrite.OutputContext;
import laika.rewrite.ReferenceResolver;
import laika.rewrite.nav.AutonumberConfig$;
import laika.rewrite.nav.NavigationOrder$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public class TreeCursor
implements Cursor,
Product,
Serializable {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(TreeCursor.class.getDeclaredField("allDocuments$lzy2"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(TreeCursor.class.getDeclaredField("children$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TreeCursor.class.getDeclaredField("titleDocument$lzy1"));
    private final DocumentTree target;
    private final Option parent;
    private final RootCursor root;
    private final Config config;
    private final TreePosition position;
    private final Path path;
    private volatile Object titleDocument$lzy1;
    private volatile Object children$lzy1;
    private volatile Object allDocuments$lzy2;

    public static Either<TreeConfigErrors, TreeCursor> apply(DocumentTree documentTree, Option<OutputContext> option) {
        return TreeCursor$.MODULE$.apply(documentTree, option);
    }

    public static TreeCursor apply(DocumentTree documentTree, Option<TreeCursor> option, RootCursor rootCursor, Config config, TreePosition treePosition) {
        return TreeCursor$.MODULE$.apply(documentTree, option, rootCursor, config, treePosition);
    }

    public static TreeCursor apply(RootCursor rootCursor) {
        return TreeCursor$.MODULE$.apply(rootCursor);
    }

    public static TreeCursor fromProduct(Product product) {
        return TreeCursor$.MODULE$.fromProduct(product);
    }

    public static TreeCursor unapply(TreeCursor treeCursor) {
        return TreeCursor$.MODULE$.unapply(treeCursor);
    }

    public static Option<OutputContext> apply$default$2() {
        return TreeCursor$.MODULE$.apply$default$2();
    }

    public TreeCursor(DocumentTree target, Option<TreeCursor> parent, RootCursor root, Config config, TreePosition position) {
        this.target = target;
        this.parent = parent;
        this.root = root;
        this.config = config;
        this.position = position;
        this.path = target.path();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TreeCursor)) return false;
        TreeCursor treeCursor = (TreeCursor)object;
        DocumentTree documentTree = this.target();
        DocumentTree documentTree2 = treeCursor.target();
        if (documentTree == null) {
            if (documentTree2 != null) {
                return false;
            }
        } else if (!((Object)documentTree).equals(documentTree2)) return false;
        Option<TreeCursor> option = this.parent();
        Option<TreeCursor> option2 = treeCursor.parent();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        RootCursor rootCursor = this.root();
        RootCursor rootCursor2 = treeCursor.root();
        if (rootCursor == null) {
            if (rootCursor2 != null) {
                return false;
            }
        } else if (!rootCursor.equals(rootCursor2)) return false;
        Config config = this.config();
        Config config2 = treeCursor.config();
        if (config == null) {
            if (config2 != null) {
                return false;
            }
        } else if (!config.equals(config2)) return false;
        TreePosition treePosition = this.position();
        TreePosition treePosition2 = treeCursor.position();
        if (treePosition == null) {
            if (treePosition2 != null) {
                return false;
            }
        } else if (!((Object)treePosition).equals(treePosition2)) return false;
        if (!treeCursor.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TreeCursor;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "TreeCursor";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "target";
            }
            case 1: {
                return "parent";
            }
            case 2: {
                return "root";
            }
            case 3: {
                return "config";
            }
            case 4: {
                return "position";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public DocumentTree target() {
        return this.target;
    }

    public Option<TreeCursor> parent() {
        return this.parent;
    }

    @Override
    public RootCursor root() {
        return this.root;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public TreePosition position() {
        return this.position;
    }

    @Override
    public Path path() {
        return this.path;
    }

    public Option<DocumentCursor> titleDocument() {
        Object object = this.titleDocument$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.titleDocument$lzyINIT1();
    }

    private Object titleDocument$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.titleDocument$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.target().titleDocument().map((Function1 & Serializable)title -> DocumentCursor$.MODULE$.apply((Document)title, this, title.config(), this.position()));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.titleDocument$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<Cursor> children() {
        Object object = this.children$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.children$lzyINIT1();
    }

    private Object children$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.children$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Seq seq = null;
                    try {
                        seq = (Seq)((IterableOps)this.target().content().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                            Product product;
                            Tuple2 tuple2 = x$1;
                            if (tuple2 == null) throw new MatchError((Object)tuple2);
                            TreeContent treeContent = (TreeContent)tuple2._1();
                            int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            if (treeContent instanceof Document) {
                                Document doc = (Document)treeContent;
                                int index = n;
                                product = DocumentCursor$.MODULE$.apply(doc, this, doc.config(), this.position().forChild(index + 1));
                                return product;
                            } else {
                                if (!(treeContent instanceof DocumentTree)) throw new MatchError((Object)tuple2);
                                DocumentTree tree = (DocumentTree)treeContent;
                                int index = n;
                                product = TreeCursor$.MODULE$.apply(tree, (Option<TreeCursor>)Some$.MODULE$.apply((Object)this), this.root(), tree.config(), this.position().forChild(index + 1));
                            }
                            return product;
                        });
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.children$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<DocumentCursor> allDocuments() {
        Object object = this.allDocuments$lzy2;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.allDocuments$lzyINIT2();
    }

    private Object allDocuments$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.allDocuments$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Seq seq = null;
                    try {
                        seq = TreeCursor.collect$1(this);
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.allDocuments$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Either<TreeConfigErrors, DocumentTree> rewriteTarget(Function1<DocumentCursor, Either<ConfigError, RewriteRules>> rules) {
        Either either = package.all$.MODULE$.catsSyntaxEither(NavigationOrder$.MODULE$.applyTo(this.children(), this.config(), this.position()));
        Either sortedContent = EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)err -> cats.data.package$.MODULE$.NonEmptyChain().one((Object)DocumentConfigErrors$.MODULE$.apply(this.path(), (ConfigError)err)));
        Either rewrittenTitle = (Either)package.all$.MODULE$.toTraverseOps(this.titleDocument(), UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse((Function1 & Serializable)doc -> {
            Config config = AutonumberConfig$.MODULE$.withoutSectionNumbering(doc.config());
            Document document = doc.copy$default$1();
            TreeCursor treeCursor = doc.copy$default$2();
            ReferenceResolver referenceResolver = doc.copy$default$3();
            Option<Path> option = doc.copy$default$5();
            TreePosition treePosition = doc.copy$default$6();
            Either either = package.all$.MODULE$.catsSyntaxEither(doc.copy(document, treeCursor, referenceResolver, config, option, treePosition).rewriteTarget(rules));
            return EitherOps$.MODULE$.toEitherNec$extension(either);
        }, (Applicative)Invariant$.MODULE$.catsMonadErrorForEither());
        Either rewrittenContent = sortedContent.flatMap((Function1 & Serializable)_$6 -> {
            List list = (List)package.all$.MODULE$.catsSyntaxParallelSequence1((Object)_$6.toList().map((Function1 & Serializable)x$1 -> {
                Cursor cursor = x$1;
                if (cursor instanceof DocumentCursor) {
                    DocumentCursor doc = (DocumentCursor)cursor;
                    Either either = package.all$.MODULE$.catsSyntaxEither(doc.rewriteTarget(rules));
                    return EitherOps$.MODULE$.toEitherNec$extension(either);
                }
                if (cursor instanceof TreeCursor) {
                    TreeCursor tree = (TreeCursor)cursor;
                    Either either = package.all$.MODULE$.catsSyntaxEither(tree.rewriteTarget(rules));
                    return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$7 -> _$7.failures());
                }
                throw new MatchError((Object)cursor);
            }), UnorderedFoldable$.MODULE$.catsTraverseForList());
            return (Either)ParallelSequenceOps1$.MODULE$.parSequence$extension((Object)list, UnorderedFoldable$.MODULE$.catsTraverseForList(), NonEmptyParallel$.MODULE$.catsParallelForEitherValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()));
        });
        Either either2 = package.all$.MODULE$.catsSyntaxEither((Either)package.all$.MODULE$.catsSyntaxTuple2Parallel(Tuple2$.MODULE$.apply((Object)rewrittenTitle, (Object)rewrittenContent)).parMapN((Function2 & Serializable)(title, content) -> this.target().copy(this.target().copy$default$1(), (Seq<TreeContent>)content, (Option<Document>)title, this.target().copy$default$4(), this.target().copy$default$5(), this.position()), (NonEmptyParallel)NonEmptyParallel$.MODULE$.catsParallelForEitherValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain())));
        return EitherOps$.MODULE$.leftMap$extension(either2, (Function1 & Serializable)failures -> TreeConfigErrors$.MODULE$.apply(failures));
    }

    public TreeCursor copy(DocumentTree target, Option<TreeCursor> parent, RootCursor root, Config config, TreePosition position) {
        return new TreeCursor(target, parent, root, config, position);
    }

    public DocumentTree copy$default$1() {
        return this.target();
    }

    public Option<TreeCursor> copy$default$2() {
        return this.parent();
    }

    public RootCursor copy$default$3() {
        return this.root();
    }

    public Config copy$default$4() {
        return this.config();
    }

    public TreePosition copy$default$5() {
        return this.position();
    }

    public DocumentTree _1() {
        return this.target();
    }

    public Option<TreeCursor> _2() {
        return this.parent();
    }

    public RootCursor _3() {
        return this.root();
    }

    public Config _4() {
        return this.config();
    }

    public TreePosition _5() {
        return this.position();
    }

    private static final Seq collect$1(TreeCursor tree) {
        return (Seq)Option$.MODULE$.option2Iterable(tree.titleDocument()).toSeq().$plus$plus((IterableOnce)tree.children().flatMap((Function1 & Serializable)x$1 -> {
            Cursor cursor = x$1;
            if (cursor instanceof DocumentCursor) {
                DocumentCursor doc = (DocumentCursor)cursor;
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DocumentCursor[]{doc}));
            }
            if (cursor instanceof TreeCursor) {
                TreeCursor sub = (TreeCursor)cursor;
                return TreeCursor.collect$1(sub);
            }
            throw new MatchError((Object)cursor);
        }));
    }
}

