/*
 * Decompiled with CFR 0.152.
 */
package laika.parse.text;

import laika.parse.Parsed;
import laika.parse.Parser;
import laika.parse.SourceCursor;
import laika.parse.text.Characters$;
import laika.parse.text.Delimiter;
import laika.parse.text.DelimiterResult;
import laika.parse.text.DelimiterResult$Complete$;
import laika.parse.text.DelimiterResult$Continue$;
import scala.Char$;
import scala.MatchError;
import scala.collection.Iterable;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class DelimitedParser<T>
extends Parser<T> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DelimitedParser.class.getDeclaredField("optimizedDelimiters$lzy1"));
    private final Delimiter delimiter;
    private final char maxChar;
    private volatile Object optimizedDelimiters$lzy1;

    public DelimitedParser(Delimiter<T> delimiter) {
        this.delimiter = delimiter;
        this.maxChar = delimiter.startChars().nonEmpty() ? BoxesRunTime.unboxToChar((Object)delimiter.startChars().max((Ordering)Ordering.Char$.MODULE$)) : (char)'\u0000';
    }

    public Delimiter<T> delimiter() {
        return this.delimiter;
    }

    private byte[] optimizedDelimiters() {
        Object object = this.optimizedDelimiters$lzy1;
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (byte[])this.optimizedDelimiters$lzyINIT1();
    }

    private Object optimizedDelimiters$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.optimizedDelimiters$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    byte[] byArray = null;
                    try {
                        byArray = Characters$.MODULE$.optimizedLookup((Iterable<Object>)this.delimiter().startChars());
                        object2 = byArray == null ? LazyVals.NullValue$.MODULE$ : (Object)byArray;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.optimizedDelimiters$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return byArray;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Parsed<T> parse(SourceCursor source) {
        String sourceString = source.input();
        int end = sourceString.length();
        byte[] lookup = this.optimizedDelimiters();
        return this.parse$1(source, sourceString, end, lookup, source.offset());
    }

    private static final int charsConsumed$4(SourceCursor source$1, int offset$tailLocal1$1) {
        return offset$tailLocal1$1 - source$1.offset();
    }

    private final Parsed parse$1(SourceCursor source$2, String sourceString$1, int end$1, byte[] lookup$1, int offset) {
        while (offset != end$1) {
            char c = sourceString$1.charAt(offset);
            if (c <= this.maxChar && lookup$1[Char$.MODULE$.char2int(c)] == 1) {
                DelimiterResult<T> delimiterResult = this.delimiter().atStartChar(c, DelimitedParser.charsConsumed$4(source$2, offset), source$2);
                if (delimiterResult instanceof DelimiterResult.Complete) {
                    Parsed parsed;
                    DelimiterResult.Complete complete = DelimiterResult$Complete$.MODULE$.unapply((DelimiterResult.Complete)delimiterResult);
                    Parsed result = parsed = complete._1();
                    return result;
                }
                if (DelimiterResult$Continue$.MODULE$.equals(delimiterResult)) {
                    ++offset;
                    continue;
                }
                throw new MatchError(delimiterResult);
            }
            ++offset;
        }
        return this.delimiter().atEOF(DelimitedParser.charsConsumed$4(source$2, offset), source$2);
    }
}

