/*
 * Decompiled with CFR 0.152.
 */
package laika.parse.uri;

import cats.data.NonEmptySetImpl$;
import java.io.Serializable;
import laika.ast.package$;
import laika.parse.Parser;
import laika.parse.builders$;
import laika.parse.combinator.Repeat;
import laika.parse.implicits$;
import laika.parse.implicits$LiteralStringOps$;
import laika.parse.text.CharGroup$;
import laika.parse.text.Characters;
import laika.parse.text.PrefixCharacters;
import laika.parse.text.PrefixedParser;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class URIParsers$
implements Serializable {
    private static final Characters alpha;
    private static final Characters digit;
    private static final Characters hexdig;
    private static final Parser subDelims;
    private static final Parser unreserved;
    private static final Parser pctEncoded;
    private static final Parser ipvFuture;
    private static final Parser ipv4address;
    private static final Parser ipv6address;
    private static final Parser ipLiteral;
    private static final Parser regName;
    private static final Parser host;
    private static final Parser port;
    private static final Parser userInfo;
    private static final Parser authority;
    private static final Parser pChar;
    private static final Parser path;
    private static final Parser query;
    private static final Parser fragment;
    private static final Parser hierPart;
    private static final Parser httpUriNoScheme;
    private static final Parser httpUri;
    private static final Parser httpsUri;
    private static final Parser dotAtomText;
    private static final Parser localPart;
    private static final Parser domain;
    private static final Parser addrSpec;
    private static final Parser to;
    private static final Parser hfields;
    private static final Parser emailAddress;
    private static final Parser emailURI;
    public static final URIParsers$ MODULE$;

    private URIParsers$() {
    }

    static {
        MODULE$ = new URIParsers$();
        alpha = builders$.MODULE$.anyOf(CharGroup$.MODULE$.alpha());
        digit = builders$.MODULE$.anyOf(CharGroup$.MODULE$.digit());
        hexdig = builders$.MODULE$.anyOf(NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(builders$.MODULE$.range('0', '9')).$plus$plus(builders$.MODULE$.range('A', 'F')));
        subDelims = (Parser)((Object)builders$.MODULE$.oneOf('!', (Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'$', '&', '\'', '(', ')', '*', '+', ',', ';', '='})));
        unreserved = MODULE$.alpha().take(1).$bar(MODULE$::$init$$$anonfun$1).$bar(MODULE$::$init$$$anonfun$2);
        pctEncoded = (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("%"), MODULE$.hexdig().take(2)).source());
        ipvFuture = (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("v"), MODULE$.hexdig().min(1)).$tilde(".").$tilde(MODULE$.unreserved().$bar(MODULE$::$init$$$anonfun$3).$bar(":", $less$colon$less$.MODULE$.refl()).rep().min(1)).source());
        Parser decOctet = MODULE$.digit().min(1).max(3).evalMap((Function1 & Serializable)res -> {
            int num = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(res));
            if (num >= 0 && num < 256) {
                return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)num));
            }
            return package$.MODULE$.Left().apply((Object)"Number must be between 1 and 255");
        });
        ipv4address = decOctet.rep(".").take(4).source();
        Characters<String> h16 = MODULE$.hexdig().min(1).max(4);
        Parser h16Col = h16.$tilde(":");
        Parser ls32 = h16.$tilde(":").$tilde(h16).$bar(MODULE$::$anonfun$2);
        ipv6address = h16Col.rep().take(6).$tilde(ls32).$bar(() -> MODULE$.$init$$$anonfun$4(h16Col, ls32)).$bar(() -> MODULE$.$init$$$anonfun$5(h16, h16Col, ls32)).$bar(() -> MODULE$.$init$$$anonfun$6(h16, h16Col, ls32)).$bar(() -> MODULE$.$init$$$anonfun$7(h16, h16Col, ls32)).$bar(() -> MODULE$.$init$$$anonfun$8(h16, h16Col, ls32)).$bar(() -> MODULE$.$init$$$anonfun$9(h16, h16Col, ls32)).$bar(() -> MODULE$.$init$$$anonfun$10(h16, h16Col)).$bar(() -> MODULE$.$init$$$anonfun$11(h16, h16Col)).source();
        ipLiteral = (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("["), MODULE$.ipv6address().$bar(MODULE$::$init$$$anonfun$12)).$tilde("]").source());
        regName = MODULE$.unreserved().$bar(MODULE$::$init$$$anonfun$13).$bar(MODULE$::$init$$$anonfun$14).rep().source();
        host = MODULE$.ipLiteral().$bar(MODULE$::$init$$$anonfun$15).$bar(MODULE$::$init$$$anonfun$16);
        port = MODULE$.digit().min(1);
        userInfo = MODULE$.unreserved().$bar(MODULE$::$init$$$anonfun$17).$bar(MODULE$::$init$$$anonfun$18).$bar(":", $less$colon$less$.MODULE$.refl()).rep().source();
        authority = builders$.MODULE$.opt((Parser)MODULE$.userInfo().$tilde("@")).$tilde(MODULE$.host()).$tilde(builders$.MODULE$.opt((Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps(":"), MODULE$.port())))).source();
        pChar = MODULE$.unreserved().$bar(MODULE$::$init$$$anonfun$19).$bar(MODULE$::$init$$$anonfun$20).$bar(MODULE$::$init$$$anonfun$21);
        PrefixedParser<package$.tilde<String, String>> segment = implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("/"), MODULE$.pChar().rep());
        path = ((Parser)((Object)segment)).rep().source();
        query = MODULE$.pChar().$bar(MODULE$::$init$$$anonfun$22).rep().source();
        fragment = MODULE$.query();
        hierPart = (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("//"), MODULE$.authority()).$tilde(MODULE$.path()).source());
        httpUriNoScheme = MODULE$.hierPart().$tilde(builders$.MODULE$.opt((Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("?"), MODULE$.query())))).$tilde(builders$.MODULE$.opt((Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("#"), MODULE$.fragment())))).source();
        httpUri = (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("http:"), MODULE$.httpUriNoScheme()).source());
        httpsUri = (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("https:"), MODULE$.httpUriNoScheme()).source());
        Parser atext = MODULE$.alpha().min(1).$bar(MODULE$::$anonfun$3).$bar(MODULE$::$anonfun$4);
        dotAtomText = atext.rep().rep(".").min(1).source();
        localPart = MODULE$.dotAtomText();
        Characters dtextNoObs = builders$.MODULE$.anyOf(NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(builders$.MODULE$.range('!', 'Z')).$plus$plus(builders$.MODULE$.range('^', '~')));
        domain = MODULE$.dotAtomText().$bar(() -> MODULE$.$init$$$anonfun$23(dtextNoObs)).source();
        addrSpec = MODULE$.localPart().$tilde("@").$tilde(MODULE$.domain()).source();
        to = MODULE$.addrSpec().rep(",").min(1).source();
        PrefixCharacters someDelims = builders$.MODULE$.someOf('!', (Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'$', '\'', '(', ')', '*', '+', ',', ';', ':', '@'}));
        Parser qChar = MODULE$.unreserved().$bar(MODULE$::$anonfun$5).$bar(() -> MODULE$.$anonfun$6(someDelims));
        Repeat hfname = qChar.rep();
        Repeat hfvalue = qChar.rep();
        Parser hfield = hfname.$tilde("=").$tilde(hfvalue);
        hfields = (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("?"), hfield.rep("&").min(1)).source());
        emailAddress = MODULE$.to().$tilde(builders$.MODULE$.opt((Parser)MODULE$.hfields())).source();
        emailURI = (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("mailto:"), builders$.MODULE$.opt((Parser)MODULE$.emailAddress())).source());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(URIParsers$.class);
    }

    public Characters<String> alpha() {
        return alpha;
    }

    public Characters<String> digit() {
        return digit;
    }

    public Characters<String> hexdig() {
        return hexdig;
    }

    public Parser<String> subDelims() {
        return subDelims;
    }

    public Parser<String> unreserved() {
        return unreserved;
    }

    public Parser<String> pctEncoded() {
        return pctEncoded;
    }

    public Parser<String> ipvFuture() {
        return ipvFuture;
    }

    public Parser<String> ipv4address() {
        return ipv4address;
    }

    public Parser<String> ipv6address() {
        return ipv6address;
    }

    public Parser<String> ipLiteral() {
        return ipLiteral;
    }

    public Parser<String> regName() {
        return regName;
    }

    public Parser<String> host() {
        return host;
    }

    public Parser<String> port() {
        return port;
    }

    public Parser<String> userInfo() {
        return userInfo;
    }

    public Parser<String> authority() {
        return authority;
    }

    public Parser<String> pChar() {
        return pChar;
    }

    public Parser<String> path() {
        return path;
    }

    public Parser<String> query() {
        return query;
    }

    public Parser<String> fragment() {
        return fragment;
    }

    public Parser<String> hierPart() {
        return hierPart;
    }

    public Parser<String> httpUriNoScheme() {
        return httpUriNoScheme;
    }

    public Parser<String> httpUri() {
        return httpUri;
    }

    public Parser<String> httpsUri() {
        return httpsUri;
    }

    public Parser<String> dotAtomText() {
        return dotAtomText;
    }

    public Parser<String> localPart() {
        return localPart;
    }

    public Parser<String> domain() {
        return domain;
    }

    public Parser<String> addrSpec() {
        return addrSpec;
    }

    public Parser<String> to() {
        return to;
    }

    public Parser<String> hfields() {
        return hfields;
    }

    public Parser<String> emailAddress() {
        return emailAddress;
    }

    public Parser<String> emailURI() {
        return emailURI;
    }

    private final Parser $init$$$anonfun$1() {
        return this.digit().take(1);
    }

    private final Parser $init$$$anonfun$2() {
        return (Parser)((Object)builders$.MODULE$.oneOf('-', (Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'.', '_', '~'})));
    }

    private final Parser $init$$$anonfun$3() {
        return this.subDelims();
    }

    private final Parser $anonfun$2() {
        return this.ipv4address();
    }

    private final Parser $init$$$anonfun$4(Parser h16Col$1, Parser ls32$1) {
        return (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("::"), h16Col$1.rep().take(5)).$tilde(ls32$1));
    }

    private final Parser $init$$$anonfun$5(Characters h16$1, Parser h16Col$2, Parser ls32$2) {
        return builders$.MODULE$.opt((Parser)h16$1).$tilde("::").$tilde(h16Col$2.rep().take(4)).$tilde(ls32$2);
    }

    private final Parser $init$$$anonfun$6(Characters h16$2, Parser h16Col$3, Parser ls32$3) {
        return builders$.MODULE$.opt(h16Col$3.rep().max(1).$tilde(h16$2)).$tilde("::").$tilde(h16Col$3.rep().max(3)).$tilde(ls32$3);
    }

    private final Parser $init$$$anonfun$7(Characters h16$3, Parser h16Col$4, Parser ls32$4) {
        return builders$.MODULE$.opt(h16Col$4.rep().max(2).$tilde(h16$3)).$tilde("::").$tilde(h16Col$4.rep().max(2)).$tilde(ls32$4);
    }

    private final Parser $init$$$anonfun$8(Characters h16$4, Parser h16Col$5, Parser ls32$5) {
        return builders$.MODULE$.opt(h16Col$5.rep().max(3).$tilde(h16$4)).$tilde("::").$tilde(h16Col$5).$tilde(ls32$5);
    }

    private final Parser $init$$$anonfun$9(Characters h16$5, Parser h16Col$6, Parser ls32$6) {
        return builders$.MODULE$.opt(h16Col$6.rep().max(4).$tilde(h16$5)).$tilde("::").$tilde(ls32$6);
    }

    private final Parser $init$$$anonfun$10(Characters h16$6, Parser h16Col$7) {
        return builders$.MODULE$.opt(h16Col$7.rep().max(5).$tilde(h16$6)).$tilde("::").$tilde(h16$6);
    }

    private final Parser $init$$$anonfun$11(Characters h16$7, Parser h16Col$8) {
        return builders$.MODULE$.opt(h16Col$8.rep().max(6).$tilde(h16$7)).$tilde("::");
    }

    private final Parser $init$$$anonfun$12() {
        return this.ipvFuture();
    }

    private final Parser $init$$$anonfun$13() {
        return this.pctEncoded();
    }

    private final Parser $init$$$anonfun$14() {
        return this.subDelims();
    }

    private final Parser $init$$$anonfun$15() {
        return this.ipv4address();
    }

    private final Parser $init$$$anonfun$16() {
        return this.regName();
    }

    private final Parser $init$$$anonfun$17() {
        return this.pctEncoded().source();
    }

    private final Parser $init$$$anonfun$18() {
        return this.subDelims();
    }

    private final Parser $init$$$anonfun$19() {
        return this.pctEncoded();
    }

    private final Parser $init$$$anonfun$20() {
        return this.subDelims();
    }

    private final Parser $init$$$anonfun$21() {
        return (Parser)((Object)builders$.MODULE$.oneOf(':', (Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'@'})));
    }

    private final Parser $init$$$anonfun$22() {
        return (Parser)((Object)builders$.MODULE$.oneOf('/', (Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'?'})));
    }

    private final Parser $anonfun$3() {
        return this.digit().min(1);
    }

    private final Parser $anonfun$4() {
        return builders$.MODULE$.someOf('!', (Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'#', '$', '%', '&', '\'', '*', '+', '-', '/', '=', '?', '^', '_', '`', '{', '|', '}', '~'}));
    }

    private final Parser $init$$$anonfun$23(Characters dtextNoObs$1) {
        return (Parser)((Object)implicits$LiteralStringOps$.MODULE$.$tilde$extension(implicits$.MODULE$.LiteralStringOps("["), dtextNoObs$1).$tilde("]"));
    }

    private final Parser $anonfun$5() {
        return this.pctEncoded();
    }

    private final Parser $anonfun$6(PrefixCharacters someDelims$1) {
        return someDelims$1;
    }
}

