/*
 * Decompiled with CFR 0.152.
 */
package laika.render;

import java.io.Serializable;
import laika.ast.Block;
import laika.ast.BlockContainer;
import laika.ast.CodeSpan;
import laika.ast.CodeSpan$;
import laika.ast.DefinitionListItem;
import laika.ast.DefinitionListItem$;
import laika.ast.Element;
import laika.ast.ElementContainer;
import laika.ast.NoOpt$;
import laika.ast.Options;
import laika.ast.QuotedBlock;
import laika.ast.QuotedBlock$;
import laika.ast.ResolvedInternalTarget;
import laika.ast.SectionNumber;
import laika.ast.SectionNumber$;
import laika.ast.Span;
import laika.ast.SpanContainer;
import laika.ast.TemplateSpanContainer;
import laika.ast.TextContainer;
import laika.parse.code.CodeCategory;
import laika.render.ASTRenderer;
import laika.render.ASTRenderer$Content$;
import laika.render.ASTRenderer$NoRef$2$;
import laika.render.TextFormatter;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ASTRenderer$
implements Function2<TextFormatter, Element, String> {
    private static final int maxTextWidth;
    private static final ASTRenderer$Content$ Content;
    public static final ASTRenderer$ MODULE$;

    private ASTRenderer$() {
    }

    static {
        MODULE$ = new ASTRenderer$();
        maxTextWidth = 50;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ASTRenderer$.class);
    }

    public int maxTextWidth() {
        return maxTextWidth;
    }

    public String apply(TextFormatter fmt, Element element) {
        LazyRef lazyRef = new LazyRef();
        Element element2 = element;
        if (element2 instanceof QuotedBlock) {
            QuotedBlock quotedBlock = QuotedBlock$.MODULE$.unapply((QuotedBlock)element2);
            Seq<Block> seq = quotedBlock._1();
            Seq<Span> seq2 = quotedBlock._2();
            Options options = quotedBlock._3();
            Seq<Block> content = seq;
            Seq<Span> attr = seq2;
            return this.lists$1(fmt, "QuotedBlock", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(content, (Object)"Content - Blocks: "), Tuple2$.MODULE$.apply(attr, (Object)"Attribution - Spans: ")}));
        }
        if (element2 instanceof DefinitionListItem) {
            DefinitionListItem definitionListItem = DefinitionListItem$.MODULE$.unapply((DefinitionListItem)element2);
            Seq<Span> seq = definitionListItem._1();
            Seq<Block> seq3 = definitionListItem._2();
            Options options = definitionListItem._3();
            Seq<Span> term = seq;
            Seq<Block> defn = seq3;
            return this.lists$1(fmt, "Item", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(term, (Object)"Term - Spans: "), Tuple2$.MODULE$.apply(defn, (Object)"Definition - Blocks: ")}));
        }
        if (element2 instanceof SectionNumber) {
            SectionNumber sectionNumber = SectionNumber$.MODULE$.unapply((SectionNumber)element2);
            Seq<Object> seq = sectionNumber._1();
            Options options = sectionNumber._2();
            Seq<Object> pos = seq;
            Options opt = options;
            return new StringBuilder(13).append("SectionNumber").append(this.attributes$1(package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{pos.mkString("."), opt})).iterator(), this.attributes$default$2$1(lazyRef))).toString();
        }
        if (element2 instanceof BlockContainer) {
            BlockContainer bc = (BlockContainer)((Object)element2);
            return this.elementContainerDesc$1(fmt, bc, "Blocks");
        }
        if (element2 instanceof SpanContainer) {
            SpanContainer sc = (SpanContainer)((Object)element2);
            return this.elementContainerDesc$1(fmt, sc, "Spans");
        }
        if (element2 instanceof TemplateSpanContainer) {
            TemplateSpanContainer tsc = (TemplateSpanContainer)((Object)element2);
            return this.elementContainerDesc$1(fmt, tsc, "TemplateSpans");
        }
        if (element2 instanceof TextContainer) {
            TextContainer tc = (TextContainer)((Object)element2);
            return this.textContainerDesc$1(tc);
        }
        if (element2 instanceof ASTRenderer.Content) {
            ASTRenderer.Content content = ASTRenderer$Content$.MODULE$.unapply((ASTRenderer.Content)element2);
            Seq<Element> seq = content._1();
            String string = content._2();
            Options options = content._3();
            Seq<Element> content2 = seq;
            String desc = string;
            return new StringBuilder(0).append(desc).append(fmt.indentedChildren(content2)).toString();
        }
        if (element2 instanceof ElementContainer) {
            ElementContainer ec = (ElementContainer)((Object)element2);
            return this.elementContainerDesc$1(fmt, ec, "Elements");
        }
        Element e = element2;
        return this.renderElement$1(fmt, lazyRef, e);
    }

    private final ASTRenderer$NoRef$2$ NoRef$lzyINIT1$1(LazyRef NoRef$lzy1$1) {
        ASTRenderer$NoRef$2$ aSTRenderer$NoRef$2$;
        LazyRef lazyRef = NoRef$lzy1$1;
        synchronized (lazyRef) {
            aSTRenderer$NoRef$2$ = (ASTRenderer$NoRef$2$)(NoRef$lzy1$1.initialized() ? NoRef$lzy1$1.value() : NoRef$lzy1$1.initialize((Object)new ASTRenderer$NoRef$2$()));
        }
        return aSTRenderer$NoRef$2$;
    }

    private final ASTRenderer$NoRef$2$ NoRef$1(LazyRef NoRef$lzy1$2) {
        return (ASTRenderer$NoRef$2$)(NoRef$lzy1$2.initialized() ? NoRef$lzy1$2.value() : this.NoRef$lzyINIT1$1(NoRef$lzy1$2));
    }

    private final String options$1(Options opt) {
        return ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{opt.id().map((Function1 & Serializable)_$1 -> new StringBuilder(4).append("Id(").append((String)_$1).append(")").toString()), opt.styles().isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)opt.styles().mkString("Styles(", ",", ")"))}))).filter((Function1 & Serializable)_$2 -> _$2.isDefined()).map((Function1 & Serializable)_$3 -> (String)_$3.get()).mkString(" + ");
    }

    private final Object prep$1(Object value) {
        Object object = value;
        if (object instanceof Options) {
            Options opt = (Options)object;
            return this.options$1(opt);
        }
        if (object instanceof ResolvedInternalTarget) {
            ResolvedInternalTarget t = (ResolvedInternalTarget)object;
            return new StringBuilder(17).append("InternalTarget(").append(t.relativePath()).append(",").append(t.internalFormats()).append(")").toString();
        }
        Object other = object;
        return other;
    }

    private final String attributes$1(Iterator attr, Object exclude) {
        String res;
        Iterator it = attr;
        String string = res = it.filter((Function1 & Serializable)_$4 -> _$4 != exclude).filter((Function1 & Serializable)_$5 -> {
            Object object = _$5;
            NoOpt$ noOpt$ = NoOpt$.MODULE$;
            return object == null ? noOpt$ != null : !object.equals(noOpt$);
        }).map((Function1 & Serializable)value -> this.prep$1(value)).mkString("(", ",", ")");
        String string2 = "()";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return "";
        }
        return res;
    }

    private final Object attributes$default$2$1(LazyRef NoRef$lzy1$4) {
        return this.NoRef$1(NoRef$lzy1$4);
    }

    private final String elementContainerDesc$1(TextFormatter fmt$1, ElementContainer con, String elementType) {
        Tuple2 tuple2 = ((Product)con).productIterator().partition((Function1 & Serializable)_$6 -> _$6 instanceof Element);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator elements = (Iterator)tuple2._1();
        Iterator rest = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)elements, (Object)rest);
        Iterator elements2 = (Iterator)tuple22._1();
        Iterator rest2 = (Iterator)tuple22._2();
        String prefix = new StringBuilder(0).append(((Product)con).productPrefix()).append(this.attributes$1(rest2, con.content())).toString();
        String contentDesc = new StringBuilder(5).append(" - ").append(elementType).append(": ").append(BoxesRunTime.boxToInteger((int)((SeqOps)con.content()).length()).toString()).toString();
        if (elements2.nonEmpty()) {
            return new StringBuilder(0).append(prefix).append(fmt$1.indentedChildren((Seq<Element>)((Seq)((Seq)elements2.toList()).$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ASTRenderer.Content[]{ASTRenderer$Content$.MODULE$.apply((Seq<Element>)((Seq)con.content()), new StringBuilder(7).append("Content").append(contentDesc).toString(), ASTRenderer$Content$.MODULE$.$lessinit$greater$default$3())})))))).toString();
        }
        return new StringBuilder(0).append(prefix).append(contentDesc).append(fmt$1.indentedChildren((Seq<Element>)((Seq)con.content()))).toString();
    }

    private final String textContainerDesc$1(TextContainer con) {
        String string;
        TextContainer textContainer = con;
        if (textContainer instanceof CodeSpan) {
            CodeSpan codeSpan = CodeSpan$.MODULE$.unapply((CodeSpan)textContainer);
            String string2 = codeSpan._1();
            Set<CodeCategory> set = codeSpan._2();
            Options options = codeSpan._3();
            Set<CodeCategory> categories = set;
            String props = categories.isEmpty() ? "" : ((IterableOnceOps)((SeqOps)categories.toSeq().map((Function1 & Serializable)_$7 -> _$7.name())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("(", ", ", ")");
            string = new StringBuilder(12).append("CodeSpan").append(props).append(" - '").toString();
        } else {
            string = new StringBuilder(4).append(((Product)con).productPrefix()).append(this.attributes$1(((Product)con).productIterator(), con.content())).append(" - '").toString();
        }
        String start = string;
        String text = ((String)con.content()).replace("\n", "|");
        int len = text.length();
        if (len <= this.maxTextWidth()) {
            return new StringBuilder(1).append(start).append(text).append("'").toString();
        }
        return new StringBuilder(8).append(start).append(text.substring(0, this.maxTextWidth() / 2)).append(" [...] ").append(text.substring(len - this.maxTextWidth() / 2)).append("'").toString();
    }

    private final String renderElement$1(TextFormatter fmt$2, LazyRef NoRef$lzy1$3, Element e) {
        Tuple2 tuple2 = e.productIterator().partition((Function1 & Serializable)_$8 -> _$8 instanceof Element);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator elements = (Iterator)tuple2._1();
        Iterator rest = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)elements, (Object)rest);
        Iterator elements2 = (Iterator)tuple22._1();
        Iterator rest2 = (Iterator)tuple22._2();
        return new StringBuilder(0).append(e.productPrefix()).append(this.attributes$1(rest2, this.attributes$default$2$1(NoRef$lzy1$3))).append(fmt$2.indentedChildren((Seq<Element>)((Seq)elements2.toList()))).toString();
    }

    private final String lists$1(TextFormatter fmt$3, String desc, Seq lists) {
        return new StringBuilder(0).append(desc).append(fmt$3.indentedChildren((Seq<Element>)((Seq)lists.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Seq elems = (Seq)tuple2._1();
                String d = (String)tuple2._2();
                return ASTRenderer$Content$.MODULE$.apply((Seq<Element>)elems, new StringBuilder(0).append(d).append(elems.length()).toString(), ASTRenderer$Content$.MODULE$.$lessinit$greater$default$3());
            }
            throw new MatchError((Object)tuple2);
        })))).toString();
    }
}

