/*
 * Decompiled with CFR 0.152.
 */
package laika.render;

import cats.data.NonEmptySetImpl$;
import java.io.Serializable;
import laika.ast.Block;
import laika.ast.BlockContainer;
import laika.ast.BlockSequence;
import laika.ast.BlockSequence$;
import laika.ast.BodyCell$;
import laika.ast.BulletFormat;
import laika.ast.BulletList;
import laika.ast.BulletList$;
import laika.ast.BulletListItem;
import laika.ast.BulletListItem$;
import laika.ast.Caption;
import laika.ast.Caption$;
import laika.ast.Cell;
import laika.ast.Cell$;
import laika.ast.CellType;
import laika.ast.Choice;
import laika.ast.Citation;
import laika.ast.Citation$;
import laika.ast.CitationLink;
import laika.ast.CitationLink$;
import laika.ast.CodeBlock;
import laika.ast.CodeBlock$;
import laika.ast.CodeSpan;
import laika.ast.CodeSpan$;
import laika.ast.CodeSpanSequence;
import laika.ast.CodeSpanSequence$;
import laika.ast.Column;
import laika.ast.Column$;
import laika.ast.Columns;
import laika.ast.Columns$;
import laika.ast.Comment;
import laika.ast.Comment$;
import laika.ast.DefinitionList;
import laika.ast.DefinitionList$;
import laika.ast.DefinitionListItem;
import laika.ast.DefinitionListItem$;
import laika.ast.Deleted;
import laika.ast.Deleted$;
import laika.ast.Element;
import laika.ast.ElementContainer;
import laika.ast.EmbeddedRoot;
import laika.ast.EmbeddedRoot$;
import laika.ast.Emphasized;
import laika.ast.Emphasized$;
import laika.ast.EnumFormat;
import laika.ast.EnumList;
import laika.ast.EnumList$;
import laika.ast.EnumListItem;
import laika.ast.EnumListItem$;
import laika.ast.ExternalTarget;
import laika.ast.Figure;
import laika.ast.Figure$;
import laika.ast.Footnote;
import laika.ast.Footnote$;
import laika.ast.FootnoteLink;
import laika.ast.FootnoteLink$;
import laika.ast.HeadCell$;
import laika.ast.Header;
import laika.ast.Header$;
import laika.ast.Icon;
import laika.ast.IconGlyph;
import laika.ast.IconStyle;
import laika.ast.Image;
import laika.ast.Image$;
import laika.ast.InlineCode;
import laika.ast.InlineCode$;
import laika.ast.InlineSVGIcon;
import laika.ast.Inserted;
import laika.ast.Inserted$;
import laika.ast.InternalLinkTarget;
import laika.ast.InternalLinkTarget$;
import laika.ast.InternalTarget;
import laika.ast.Invalid;
import laika.ast.InvalidBlock;
import laika.ast.InvalidBlock$;
import laika.ast.InvalidSpan$;
import laika.ast.Length;
import laika.ast.Length$;
import laika.ast.LengthUnit;
import laika.ast.LengthUnit$px$;
import laika.ast.LineBreak;
import laika.ast.LineBreak$;
import laika.ast.ListContainer;
import laika.ast.Literal;
import laika.ast.Literal$;
import laika.ast.LiteralBlock;
import laika.ast.LiteralBlock$;
import laika.ast.NavigationItem;
import laika.ast.NavigationList;
import laika.ast.NoOpt$;
import laika.ast.Options;
import laika.ast.Paragraph;
import laika.ast.Paragraph$;
import laika.ast.ParsedLiteralBlock;
import laika.ast.ParsedLiteralBlock$;
import laika.ast.QuotedBlock;
import laika.ast.QuotedBlock$;
import laika.ast.RawContent;
import laika.ast.RawContent$;
import laika.ast.RawLink;
import laika.ast.RawLink$;
import laika.ast.Reference;
import laika.ast.RelativePath;
import laika.ast.RootElement;
import laika.ast.RootElement$;
import laika.ast.Row;
import laika.ast.Row$;
import laika.ast.Rule;
import laika.ast.Rule$;
import laika.ast.RuntimeMessage;
import laika.ast.SVGSymbolIcon;
import laika.ast.Section;
import laika.ast.Section$;
import laika.ast.SectionNumber;
import laika.ast.SectionNumber$;
import laika.ast.Selection;
import laika.ast.Selection$;
import laika.ast.Span;
import laika.ast.SpanContainer;
import laika.ast.SpanLink;
import laika.ast.SpanLink$;
import laika.ast.SpanSequence;
import laika.ast.SpanSequence$;
import laika.ast.StringBullet;
import laika.ast.StringBullet$;
import laika.ast.Strong;
import laika.ast.Strong$;
import laika.ast.Style$;
import laika.ast.Styles$;
import laika.ast.Table;
import laika.ast.Table$;
import laika.ast.TableBody;
import laika.ast.TableBody$;
import laika.ast.TableElement;
import laika.ast.TableHead;
import laika.ast.TableHead$;
import laika.ast.Target;
import laika.ast.TargetFormat;
import laika.ast.TargetFormat$;
import laika.ast.TemplateElement;
import laika.ast.TemplateElement$;
import laika.ast.TemplateRoot;
import laika.ast.TemplateRoot$;
import laika.ast.TemplateSpan;
import laika.ast.TemplateSpanContainer;
import laika.ast.TemplateSpanSequence;
import laika.ast.TemplateSpanSequence$;
import laika.ast.TemplateString;
import laika.ast.TemplateString$;
import laika.ast.Text;
import laika.ast.Text$;
import laika.ast.TextContainer;
import laika.ast.Title;
import laika.ast.Title$;
import laika.ast.TitledBlock;
import laika.ast.TitledBlock$;
import laika.parse.SourceFragment;
import laika.parse.code.CodeCategory;
import laika.render.HTMLFormatter;
import laika.render.HTMLRenderer$WithFallback$2$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public class HTMLRenderer
implements Function2<HTMLFormatter, Element, String> {
    private final String format;

    public HTMLRenderer(String fileSuffix, String format) {
        this.format = format;
    }

    public String apply(HTMLFormatter fmt, Element element) {
        LazyRef lazyRef = new LazyRef();
        Element element2 = element;
        if (element2 instanceof RuntimeMessage) {
            RuntimeMessage e = (RuntimeMessage)element2;
            return HTMLRenderer.renderRuntimeMessage$1(fmt, e);
        }
        if (element2 instanceof Table) {
            Table e = (Table)element2;
            return HTMLRenderer.renderTable$1(fmt, e);
        }
        if (element2 instanceof TableElement) {
            TableElement e = (TableElement)((Object)element2);
            return HTMLRenderer.renderTableElement$1(fmt, e);
        }
        if (element2 instanceof Reference) {
            Reference e = (Reference)((Object)element2);
            return HTMLRenderer.renderUnresolvedReference$1(fmt, e);
        }
        if (element2 instanceof Invalid) {
            Invalid e = (Invalid)((Object)element2);
            return HTMLRenderer.renderInvalidElement$1(fmt, e);
        }
        if (element2 instanceof BlockContainer) {
            BlockContainer e = (BlockContainer)((Object)element2);
            return HTMLRenderer.renderBlockContainer$1(fmt, lazyRef, e);
        }
        if (element2 instanceof SpanContainer) {
            SpanContainer e = (SpanContainer)((Object)element2);
            return HTMLRenderer.renderSpanContainer$1(fmt, lazyRef, e);
        }
        if (element2 instanceof ListContainer) {
            ListContainer e = (ListContainer)((Object)element2);
            return HTMLRenderer.renderListContainer$1(fmt, lazyRef, e);
        }
        if (element2 instanceof TextContainer) {
            TextContainer e = (TextContainer)((Object)element2);
            return this.renderTextContainer$1(fmt, lazyRef, e);
        }
        if (element2 instanceof TemplateSpanContainer) {
            TemplateSpanContainer e = (TemplateSpanContainer)((Object)element2);
            return HTMLRenderer.renderTemplateSpanContainer$1(fmt, e);
        }
        if (element2 instanceof Block) {
            Block e = (Block)((Object)element2);
            return this.renderSimpleBlock$1(fmt, lazyRef, e);
        }
        if (element2 instanceof Span) {
            Span e = (Span)((Object)element2);
            return HTMLRenderer.renderSimpleSpan$1(fmt, lazyRef, e);
        }
        return "";
    }

    private static final Option noneIfDefault$1(Object actual, Object object) {
        if (BoxesRunTime.equals((Object)actual, (Object)object)) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)actual.toString());
    }

    private static final String renderBlocks$1(HTMLFormatter fmt$1, String tagName, Options options, Seq content, Seq attrs) {
        SeqOps seqOps;
        Seq seq = content;
        if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq), 1) == 0) {
            Block block = (Block)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            if (block instanceof SpanSequence) {
                SpanSequence ss = (SpanSequence)block;
                return fmt$1.element(tagName, options, (Seq<Element>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SpanSequence[]{ss}))), (Seq<Tuple2<String, String>>)attrs);
            }
            if (block instanceof Paragraph) {
                Paragraph paragraph = Paragraph$.MODULE$.unapply((Paragraph)block);
                Seq<Span> seq2 = paragraph._1();
                Options options2 = paragraph._2();
                Seq<Span> spans = seq2;
                Options opt = options2;
                return fmt$1.element(tagName, options, (Seq<Element>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SpanSequence[]{SpanSequence$.MODULE$.apply(spans, opt)}))), (Seq<Tuple2<String, String>>)attrs);
            }
        }
        Seq other = seq;
        return fmt$1.indentedElement(tagName, options, (Seq<Element>)other, (Seq<Tuple2<String, String>>)attrs);
    }

    private static final String renderTable$1(HTMLFormatter fmt$2, Table table) {
        List children = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ElementContainer[]{table.caption(), table.columns(), table.head(), table.body()}))).filterNot((Function1 & Serializable)_$1 -> ((SeqOps)_$1.content()).isEmpty());
        return fmt$2.indentedElement("table", table.options(), (Seq<Element>)children, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final SpanSequence $anonfun$3(NavigationItem item$1) {
        return item$1.title();
    }

    private static final Seq transformItems$1(StringBullet bullet$1, Seq items) {
        return (Seq)items.flatMap((Function1 & Serializable)item -> {
            Options linkStyles;
            Options options = linkStyles = item.link().exists((Function1 & Serializable)_$2 -> _$2.selfLink()) ? Style$.MODULE$.active() : NoOpt$.MODULE$;
            Options typeStyles = item.link().isEmpty() ? Style$.MODULE$.navHeader() : (item.content().nonEmpty() ? Style$.MODULE$.navNode() : Style$.MODULE$.navLeaf());
            SpanSequence content = (SpanSequence)item.link().fold(() -> HTMLRenderer.$anonfun$3(item), (Function1 & Serializable)link -> (SpanSequence)SpanSequence$.MODULE$.apply((Span)SpanLink$.MODULE$.apply(item.title().content(), link.target(), SpanLink$.MODULE$.$lessinit$greater$default$3(), SpanLink$.MODULE$.$lessinit$greater$default$4()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[0])));
            BulletListItem target = BulletListItem$.MODULE$.apply((Seq<Block>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SpanSequence[]{content}))), bullet$1, item.options().$plus(linkStyles).$plus(typeStyles));
            Nil$ children = item.content().isEmpty() ? package$.MODULE$.Nil() : HTMLRenderer.transformItems$1(bullet$1, item.content());
            return (IterableOnce)children.$plus$colon((Object)target);
        });
    }

    private static final BulletList navigationToBulletList$1(NavigationList navList) {
        StringBullet bullet = StringBullet$.MODULE$.apply("*");
        return BulletList$.MODULE$.apply((Seq<BulletListItem>)HTMLRenderer.transformItems$1(bullet, navList.content()), bullet, navList.options().$plus(Style$.MODULE$.navList()));
    }

    private static final HTMLRenderer$WithFallback$2$ WithFallback$lzyINIT1$1(LazyRef WithFallback$lzy1$1) {
        HTMLRenderer$WithFallback$2$ hTMLRenderer$WithFallback$2$;
        LazyRef lazyRef = WithFallback$lzy1$1;
        synchronized (lazyRef) {
            hTMLRenderer$WithFallback$2$ = (HTMLRenderer$WithFallback$2$)(WithFallback$lzy1$1.initialized() ? WithFallback$lzy1$1.value() : WithFallback$lzy1$1.initialize((Object)new HTMLRenderer$WithFallback$2$()));
        }
        return hTMLRenderer$WithFallback$2$;
    }

    private static final HTMLRenderer$WithFallback$2$ WithFallback$1(LazyRef WithFallback$lzy1$2) {
        return (HTMLRenderer$WithFallback$2$)(WithFallback$lzy1$2.initialized() ? WithFallback$lzy1$2.value() : HTMLRenderer.WithFallback$lzyINIT1$1(WithFallback$lzy1$2));
    }

    private static final Table toTable$1(String label, Seq content, Options options) {
        Cell left = (Cell)BodyCell$.MODULE$.apply((Block)SpanSequence$.MODULE$.apply(new StringBuilder(2).append("[").append(label).append("]").toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Block[0]));
        Cell right = BodyCell$.MODULE$.apply((Seq<Block>)content);
        Row row = Row$.MODULE$.apply((Seq<Cell>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cell[]{left, right}))), Row$.MODULE$.$lessinit$greater$default$2());
        return Table$.MODULE$.apply(TableHead$.MODULE$.apply((Seq<Row>)package$.MODULE$.Nil(), TableHead$.MODULE$.$lessinit$greater$default$2()), TableBody$.MODULE$.apply((Seq<Row>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{row}))), TableBody$.MODULE$.$lessinit$greater$default$2()), Caption$.MODULE$.apply(Caption$.MODULE$.$lessinit$greater$default$1(), Caption$.MODULE$.$lessinit$greater$default$2()), Columns$.MODULE$.options((Seq<Options>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Options[]{Style$.MODULE$.label(), NoOpt$.MODULE$})), options);
    }

    private static final Seq quotedBlockContent$1(Seq content, Seq attr) {
        if (attr.isEmpty()) {
            return content;
        }
        return (Seq)content.$colon$plus((Object)Paragraph$.MODULE$.apply((Seq<Span>)attr, Style$.MODULE$.attribution()));
    }

    private static final List figureContent$1(Span img, Seq caption, Seq legend) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Block[]{(Block)SpanSequence$.MODULE$.apply(img, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[0])), Paragraph$.MODULE$.apply((Seq<Span>)caption, Style$.MODULE$.caption()), BlockSequence$.MODULE$.apply((Seq<Block>)legend, Style$.MODULE$.legend())}));
    }

    private static final String renderBlockContainer$1(HTMLFormatter fmt$3, LazyRef WithFallback$lzy1$3, BlockContainer con) {
        Option option;
        BlockContainer blockContainer = con;
        if (blockContainer instanceof RootElement) {
            RootElement rootElement = RootElement$.MODULE$.unapply((RootElement)blockContainer);
            Seq<Block> seq = rootElement._1();
            Options options = rootElement._2();
            Seq<Block> content = seq;
            return fmt$3.childPerLine(content);
        }
        if (blockContainer instanceof EmbeddedRoot) {
            EmbeddedRoot embeddedRoot = EmbeddedRoot$.MODULE$.unapply((EmbeddedRoot)blockContainer);
            Seq<Block> seq = embeddedRoot._1();
            int n = embeddedRoot._2();
            Options options = embeddedRoot._3();
            Seq<Block> content = seq;
            int indent = n;
            return fmt$3.withMinIndentation(indent, (Function1 & Serializable)_$3 -> _$3.childPerLine((Seq<Element>)content));
        }
        if (blockContainer instanceof Section) {
            Section section = Section$.MODULE$.unapply((Section)blockContainer);
            Header header = section._1();
            Seq<Block> seq = section._2();
            Options options = section._3();
            Header header2 = header;
            Seq<Block> content = seq;
            return fmt$3.childPerLine((Seq<Element>)((Seq)content.$plus$colon((Object)header2)));
        }
        if (blockContainer instanceof TitledBlock) {
            TitledBlock titledBlock = TitledBlock$.MODULE$.unapply((TitledBlock)blockContainer);
            Seq<Span> seq = titledBlock._1();
            Seq<Block> seq2 = titledBlock._2();
            Options options = titledBlock._3();
            Seq<Span> title = seq;
            Seq<Block> content = seq2;
            Options opt = options;
            Paragraph paragraph = Paragraph$.MODULE$.apply(title, Style$.MODULE$.title());
            return fmt$3.indentedElement("div", opt, (Seq<Element>)((Seq)content.$plus$colon((Object)paragraph)), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof QuotedBlock) {
            QuotedBlock quotedBlock = QuotedBlock$.MODULE$.unapply((QuotedBlock)blockContainer);
            Seq<Block> seq = quotedBlock._1();
            Seq<Span> seq3 = quotedBlock._2();
            Options options = quotedBlock._3();
            Seq<Block> content = seq;
            Seq<Span> attr = seq3;
            Options opt = options;
            return HTMLRenderer.renderBlocks$1(fmt$3, "blockquote", opt, HTMLRenderer.quotedBlockContent$1(content, attr), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof BulletListItem) {
            BulletListItem bulletListItem = BulletListItem$.MODULE$.unapply((BulletListItem)blockContainer);
            Seq<Block> seq = bulletListItem._1();
            BulletFormat bulletFormat = bulletListItem._2();
            Options options = bulletListItem._3();
            Seq<Block> content = seq;
            Options opt = options;
            return HTMLRenderer.renderBlocks$1(fmt$3, "li", opt, content, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof EnumListItem) {
            EnumListItem enumListItem = EnumListItem$.MODULE$.unapply((EnumListItem)blockContainer);
            Seq<Block> seq = enumListItem._1();
            EnumFormat enumFormat = enumListItem._2();
            int n = enumListItem._3();
            Options options = enumListItem._4();
            Seq<Block> content = seq;
            Options opt = options;
            return HTMLRenderer.renderBlocks$1(fmt$3, "li", opt, content, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof DefinitionListItem) {
            DefinitionListItem definitionListItem = DefinitionListItem$.MODULE$.unapply((DefinitionListItem)blockContainer);
            Seq<Span> seq = definitionListItem._1();
            Seq<Block> seq4 = definitionListItem._2();
            Options options = definitionListItem._3();
            Seq<Span> term = seq;
            Seq<Block> defn = seq4;
            return new StringBuilder(0).append(fmt$3.element("dt", NoOpt$.MODULE$, term, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).append(fmt$3.newLine()).append(HTMLRenderer.renderBlocks$1(fmt$3, "dd", NoOpt$.MODULE$, defn, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).toString();
        }
        if (blockContainer instanceof Figure) {
            Figure figure = Figure$.MODULE$.unapply((Figure)blockContainer);
            Span span = figure._1();
            Seq<Span> seq = figure._2();
            Seq<Block> seq5 = figure._3();
            Options options = figure._4();
            Span img = span;
            Seq<Span> caption = seq;
            Seq<Block> legend = seq5;
            Options opt = options;
            return fmt$3.indentedElement("div", opt.$plus(Style$.MODULE$.figure()), (Seq<Element>)HTMLRenderer.figureContent$1(img, caption, legend), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof Footnote) {
            Footnote footnote = Footnote$.MODULE$.unapply((Footnote)blockContainer);
            String string = footnote._1();
            Seq<Block> seq = footnote._2();
            Options options = footnote._3();
            String label = string;
            Seq<Block> content = seq;
            Options opt = options;
            return HTMLRenderer.renderTable$1(fmt$3, HTMLRenderer.toTable$1(label, content, opt.$plus(Style$.MODULE$.footnote())));
        }
        if (blockContainer instanceof Citation) {
            Citation citation = Citation$.MODULE$.unapply((Citation)blockContainer);
            String string = citation._1();
            Seq<Block> seq = citation._2();
            Options options = citation._3();
            String label = string;
            Seq<Block> content = seq;
            Options opt = options;
            return HTMLRenderer.renderTable$1(fmt$3, HTMLRenderer.toTable$1(label, content, opt.$plus(Style$.MODULE$.citation())));
        }
        if (blockContainer != null && !(option = HTMLRenderer.WithFallback$1(WithFallback$lzy1$3).unapply((Element)((Object)blockContainer))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$3.child(fallback);
        }
        if (blockContainer instanceof BlockSequence) {
            BlockSequence blockSequence = BlockSequence$.MODULE$.unapply((BlockSequence)blockContainer);
            Seq<Block> seq = blockSequence._1();
            Options options = blockSequence._2();
            Seq<Block> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$3.childPerLine(content);
            }
        }
        BlockContainer unknown = blockContainer;
        return fmt$3.indentedElement("div", ((Element)((Object)unknown)).options(), (Seq<Element>)((Seq)unknown.content()), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final String renderTarget$1(HTMLFormatter fmt$4, Target target) {
        Target target2 = fmt$4.pathTranslator().translate(target);
        if (target2 instanceof ExternalTarget) {
            ExternalTarget ext = (ExternalTarget)target2;
            return ext.url();
        }
        if (target2 instanceof InternalTarget) {
            InternalTarget internalTarget = (InternalTarget)target2;
            RelativePath relPath = internalTarget.relativeTo(fmt$4.path()).relativePath();
            if (relPath.withoutFragment().toString().endsWith("/index.html")) {
                return relPath.withBasename("").withoutSuffix().toString();
            }
            return relPath.toString();
        }
        throw new MatchError((Object)target2);
    }

    private static final Options codeStyles$1(String language, boolean hasHighlighting) {
        if (hasHighlighting) {
            return Style$.MODULE$.noHighlight();
        }
        return Styles$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{language}));
    }

    private static final Seq linkAttributes$1(HTMLFormatter fmt$6, Target target, Option title) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"href");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Some$.MODULE$.apply((Object)HTMLRenderer.renderTarget$1(fmt$6, target)));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"title");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)title.map((Function1 & Serializable)str -> fmt$6.text((String)str)));
        return fmt$6.optAttributes((Seq<Tuple2<String, Option<String>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final String renderSpanContainer$1(HTMLFormatter fmt$5, LazyRef WithFallback$lzy1$4, SpanContainer con) {
        Option option;
        SpanContainer spanContainer = con;
        if (spanContainer instanceof Paragraph) {
            Paragraph paragraph = Paragraph$.MODULE$.unapply((Paragraph)spanContainer);
            Seq<Span> seq = paragraph._1();
            Options options = paragraph._2();
            Seq<Span> content = seq;
            Options opt = options;
            return fmt$5.element("p", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Emphasized) {
            Emphasized emphasized = Emphasized$.MODULE$.unapply((Emphasized)spanContainer);
            Seq<Span> seq = emphasized._1();
            Options options = emphasized._2();
            Seq<Span> content = seq;
            Options opt = options;
            return fmt$5.element("em", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Strong) {
            Strong strong = Strong$.MODULE$.unapply((Strong)spanContainer);
            Seq<Span> seq = strong._1();
            Options options = strong._2();
            Seq<Span> content = seq;
            Options opt = options;
            return fmt$5.element("strong", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Deleted) {
            Deleted deleted = Deleted$.MODULE$.unapply((Deleted)spanContainer);
            Seq<Span> seq = deleted._1();
            Options options = deleted._2();
            Seq<Span> content = seq;
            Options opt = options;
            return fmt$5.element("del", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Inserted) {
            Inserted inserted = Inserted$.MODULE$.unapply((Inserted)spanContainer);
            Seq<Span> seq = inserted._1();
            Options options = inserted._2();
            Seq<Span> content = seq;
            Options opt = options;
            return fmt$5.element("ins", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof ParsedLiteralBlock) {
            ParsedLiteralBlock parsedLiteralBlock = ParsedLiteralBlock$.MODULE$.unapply((ParsedLiteralBlock)spanContainer);
            Seq<Span> seq = parsedLiteralBlock._1();
            Options options = parsedLiteralBlock._2();
            Seq<Span> content = seq;
            Options opt = options;
            return fmt$5.rawElement("pre", opt, fmt$5.withoutIndentation((Function1 & Serializable)_$4 -> _$4.element("code", NoOpt$.MODULE$, (Seq<Element>)content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof CodeBlock) {
            CodeBlock codeBlock = (CodeBlock)spanContainer;
            CodeBlock codeBlock2 = CodeBlock$.MODULE$.unapply(codeBlock);
            String string = codeBlock2._1();
            Seq<Span> seq = codeBlock2._2();
            Seq<String> seq2 = codeBlock2._3();
            Options options = codeBlock2._4();
            String lang = string;
            Seq<Span> content = seq;
            Options opt = options;
            CodeBlock cb = codeBlock;
            return fmt$5.rawElement("pre", opt, fmt$5.withoutIndentation((Function1 & Serializable)_$5 -> _$5.element("code", HTMLRenderer.codeStyles$1(lang, cb.hasSyntaxHighlighting()), (Seq<Element>)content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof InlineCode) {
            InlineCode inlineCode = InlineCode$.MODULE$.unapply((InlineCode)spanContainer);
            String string = inlineCode._1();
            Seq<Span> seq = inlineCode._2();
            Options options = inlineCode._3();
            String lang = string;
            Seq<Span> content = seq;
            Options opt = options;
            return fmt$5.withoutIndentation((Function1 & Serializable)_$6 -> _$6.element("code", opt.$plus(HTMLRenderer.codeStyles$1(lang, false)), (Seq<Element>)content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
        }
        if (spanContainer instanceof Title) {
            Title title = Title$.MODULE$.unapply((Title)spanContainer);
            Seq<Span> seq = title._1();
            Options options = title._2();
            Seq<Span> content = seq;
            Options opt = options;
            return fmt$5.element("h1", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Header) {
            Header header = Header$.MODULE$.unapply((Header)spanContainer);
            int n = header._1();
            Seq<Span> seq = header._2();
            Options options = header._3();
            int level = n;
            Seq<Span> content = seq;
            Options opt = options;
            return new StringBuilder(0).append(fmt$5.newLine()).append(fmt$5.element(new StringBuilder(1).append("h").append(BoxesRunTime.boxToInteger((int)level).toString()).toString(), opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).toString();
        }
        if (spanContainer instanceof SpanLink) {
            SpanLink spanLink = SpanLink$.MODULE$.unapply((SpanLink)spanContainer);
            Seq<Span> seq = spanLink._1();
            Target target = spanLink._2();
            Option<String> option2 = spanLink._3();
            Options options = spanLink._4();
            Seq<Span> content = seq;
            Target target2 = target;
            Option<String> title = option2;
            Options opt = options;
            return fmt$5.element("a", opt, content, (Seq<Tuple2<String, String>>)HTMLRenderer.linkAttributes$1(fmt$5, target2, title));
        }
        if (spanContainer != null && !(option = HTMLRenderer.WithFallback$1(WithFallback$lzy1$4).unapply((Element)((Object)spanContainer))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$5.child(fallback);
        }
        if (spanContainer instanceof SpanSequence) {
            SpanSequence spanSequence = SpanSequence$.MODULE$.unapply((SpanSequence)spanContainer);
            Seq<Span> seq = spanSequence._1();
            Options options = spanSequence._2();
            Seq<Span> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$5.children(content);
            }
        }
        if (spanContainer instanceof CodeSpanSequence) {
            CodeSpanSequence codeSpanSequence = CodeSpanSequence$.MODULE$.unapply((CodeSpanSequence)spanContainer);
            Seq<Span> seq = codeSpanSequence._1();
            Options options = codeSpanSequence._2();
            Seq<Span> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$5.children(content);
            }
        }
        SpanContainer unknown = spanContainer;
        return fmt$5.element("span", ((Element)((Object)unknown)).options(), (Seq<Element>)((Seq)unknown.content()), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final String renderTemplateSpanContainer$1(HTMLFormatter fmt$8, TemplateSpanContainer con) {
        TemplateSpanContainer templateSpanContainer = con;
        if (templateSpanContainer instanceof TemplateRoot) {
            TemplateRoot templateRoot = TemplateRoot$.MODULE$.unapply((TemplateRoot)templateSpanContainer);
            Seq<TemplateSpan> seq = templateRoot._1();
            Options options = templateRoot._2();
            Seq<TemplateSpan> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$8.children(content);
            }
        }
        if (templateSpanContainer instanceof TemplateSpanSequence) {
            TemplateSpanSequence templateSpanSequence = TemplateSpanSequence$.MODULE$.unapply((TemplateSpanSequence)templateSpanContainer);
            Seq<TemplateSpan> seq = templateSpanSequence._1();
            Options options = templateSpanSequence._2();
            Seq<TemplateSpan> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$8.children(content);
            }
        }
        TemplateSpanContainer unknown = templateSpanContainer;
        return fmt$8.element("span", ((Element)((Object)unknown)).options(), (Seq<Element>)((Seq)unknown.content()), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final String renderListContainer$1(HTMLFormatter fmt$9, LazyRef WithFallback$lzy1$5, ListContainer con) {
        Option option;
        ListContainer listContainer = con;
        if (listContainer instanceof EnumList) {
            EnumList enumList = EnumList$.MODULE$.unapply((EnumList)listContainer);
            Seq<EnumListItem> seq = enumList._1();
            EnumFormat enumFormat = enumList._2();
            int n = enumList._3();
            Options options = enumList._4();
            Seq<EnumListItem> content = seq;
            EnumFormat enumFormat2 = enumFormat;
            int start = n;
            Options opt = options;
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"class");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Some$.MODULE$.apply((Object)enumFormat2.enumType().toString().toLowerCase()));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"start");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)HTMLRenderer.noneIfDefault$1(BoxesRunTime.boxToInteger((int)start), BoxesRunTime.boxToInteger((int)1)));
            return fmt$9.indentedElement("ol", opt, content, fmt$9.optAttributes((Seq<Tuple2<String, Option<String>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }
        if (listContainer instanceof BulletList) {
            BulletList bulletList = BulletList$.MODULE$.unapply((BulletList)listContainer);
            Seq<BulletListItem> seq = bulletList._1();
            BulletFormat bulletFormat = bulletList._2();
            Options options = bulletList._3();
            Seq<BulletListItem> content = seq;
            Options opt = options;
            return fmt$9.indentedElement("ul", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (listContainer instanceof DefinitionList) {
            DefinitionList definitionList = DefinitionList$.MODULE$.unapply((DefinitionList)listContainer);
            Seq<DefinitionListItem> seq = definitionList._1();
            Options options = definitionList._2();
            Seq<DefinitionListItem> content = seq;
            Options opt = options;
            return fmt$9.indentedElement("dl", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (listContainer instanceof NavigationList) {
            NavigationList nl = (NavigationList)listContainer;
            return fmt$9.child(HTMLRenderer.navigationToBulletList$1(nl));
        }
        if (listContainer != null && !(option = HTMLRenderer.WithFallback$1(WithFallback$lzy1$5).unapply((Element)((Object)listContainer))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$9.child(fallback);
        }
        ListContainer unknown = listContainer;
        return fmt$9.indentedElement("div", ((Element)((Object)unknown)).options(), (Seq<Element>)((Seq)unknown.content()), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final String renderTextContainer$1(HTMLFormatter fmt$10, LazyRef WithFallback$lzy1$6, TextContainer con) {
        Option option;
        TextContainer textContainer = con;
        if (textContainer instanceof Text) {
            Text text = Text$.MODULE$.unapply((Text)textContainer);
            String string = text._1();
            Options options = text._2();
            String content = string;
            Options opt = options;
            Options options2 = opt;
            if (NoOpt$.MODULE$.equals(options2)) {
                return fmt$10.text(content);
            }
            return fmt$10.textElement("span", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (textContainer instanceof TemplateString) {
            TemplateString templateString = TemplateString$.MODULE$.unapply((TemplateString)textContainer);
            String string = templateString._1();
            Options options = templateString._2();
            String content = string;
            Options opt = options;
            Options options3 = opt;
            if (NoOpt$.MODULE$.equals(options3)) {
                return content;
            }
            return fmt$10.rawElement("span", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (textContainer instanceof RawContent) {
            RawContent rawContent = RawContent$.MODULE$.unapply((RawContent)textContainer);
            Object object = rawContent._1();
            String string = rawContent._2();
            Options options = rawContent._3();
            Object f = object;
            String content = string;
            Options opt = options;
            if (NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(f).contains((Object)this.format)) {
                Options options4 = opt;
                if (NoOpt$.MODULE$.equals(options4)) {
                    return content;
                }
                return fmt$10.rawElement("span", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            return "";
        }
        if (textContainer instanceof CodeSpan) {
            CodeSpan codeSpan = CodeSpan$.MODULE$.unapply((CodeSpan)textContainer);
            String string = codeSpan._1();
            Set<CodeCategory> set = codeSpan._2();
            Options options = codeSpan._3();
            String content = string;
            Set<CodeCategory> categories = set;
            Options opt = options;
            return fmt$10.textElement("span", opt.$plus(Styles$.MODULE$.apply((Seq<String>)((IterableOnceOps)categories.map((Function1 & Serializable)_$7 -> _$7.name())).toSeq())), content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (textContainer instanceof Literal) {
            Literal literal = Literal$.MODULE$.unapply((Literal)textContainer);
            String string = literal._1();
            Options options = literal._2();
            String content = string;
            Options opt = options;
            return fmt$10.withoutIndentation((Function1 & Serializable)_$8 -> _$8.textElement("code", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
        }
        if (textContainer instanceof LiteralBlock) {
            LiteralBlock literalBlock = LiteralBlock$.MODULE$.unapply((LiteralBlock)textContainer);
            String string = literalBlock._1();
            Options options = literalBlock._2();
            String content = string;
            Options opt = options;
            return fmt$10.element("pre", opt, (Seq<Element>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply(content, Literal$.MODULE$.$lessinit$greater$default$2())}))), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (textContainer instanceof Comment) {
            Comment comment = Comment$.MODULE$.unapply((Comment)textContainer);
            String string = comment._1();
            Options options = comment._2();
            String content = string;
            return fmt$10.comment(content);
        }
        if (textContainer instanceof SectionNumber) {
            Options options;
            SectionNumber sectionNumber = (SectionNumber)textContainer;
            SectionNumber sectionNumber2 = SectionNumber$.MODULE$.unapply(sectionNumber);
            Seq<Object> seq = sectionNumber2._1();
            Options opt = options = sectionNumber2._2();
            SectionNumber sn = sectionNumber;
            return fmt$10.child(Text$.MODULE$.apply(sn.content(), opt.$plus(Style$.MODULE$.sectionNumber())));
        }
        if (textContainer != null && !(option = HTMLRenderer.WithFallback$1(WithFallback$lzy1$6).unapply((Element)((Object)textContainer))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$10.child(fallback);
        }
        TextContainer unknown = textContainer;
        return fmt$10.textElement("span", ((Element)((Object)unknown)).options(), (String)unknown.content(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final String renderChoices$1(HTMLFormatter fmt$11, String name, Seq choices, Options options) {
        Seq content = (Seq)choices.flatMap((Function1 & Serializable)choice -> {
            Paragraph paragraph = (Paragraph)Paragraph$.MODULE$.apply((Span)Strong$.MODULE$.apply((Span)Text$.MODULE$.apply(choice.label(), Text$.MODULE$.$lessinit$greater$default$2()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[0]));
            return (IterableOnce)choice.content().$plus$colon((Object)paragraph);
        });
        return fmt$11.child(BlockSequence$.MODULE$.apply((Seq<Block>)content, options));
    }

    private final String renderSimpleBlock$1(HTMLFormatter fmt$12, LazyRef WithFallback$lzy1$7, Block block) {
        Option option;
        Block block2 = block;
        if (block2 instanceof Rule) {
            Options options;
            Rule rule = Rule$.MODULE$.unapply((Rule)block2);
            Options opt = options = rule._1();
            return fmt$12.emptyElement("hr", opt, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (block2 instanceof InternalLinkTarget) {
            Options options;
            InternalLinkTarget internalLinkTarget = InternalLinkTarget$.MODULE$.unapply((InternalLinkTarget)block2);
            Options opt = options = internalLinkTarget._1();
            return fmt$12.textElement("a", opt, "", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (block2 instanceof Selection) {
            Selection selection = Selection$.MODULE$.unapply((Selection)block2);
            String string = selection._1();
            Seq<Choice> seq = selection._2();
            Options options = selection._3();
            String name = string;
            Seq<Choice> choices = seq;
            Options opt = options;
            return HTMLRenderer.renderChoices$1(fmt$12, name, choices, opt);
        }
        if (block2 instanceof TargetFormat) {
            TargetFormat targetFormat = TargetFormat$.MODULE$.unapply((TargetFormat)block2);
            Object object = targetFormat._1();
            Element element = targetFormat._2();
            Options options = targetFormat._3();
            Object f = object;
            Element e = element;
            if (NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(f).contains((Object)this.format)) {
                return fmt$12.child(e);
            }
        }
        if (block2 != null && !(option = HTMLRenderer.WithFallback$1(WithFallback$lzy1$7).unapply((Element)((Object)block2))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$12.child(fallback);
        }
        return "";
    }

    private static final String renderIcon$1(HTMLFormatter fmt$13, Icon icon) {
        Tuple3 tuple3;
        Icon icon2 = icon;
        if (icon2 instanceof IconGlyph) {
            IconGlyph icon3 = (IconGlyph)icon2;
            tuple3 = Tuple3$.MODULE$.apply((Object)"i", (Object)icon3.options(), (Object)icon3.codePointAsEntity());
        } else if (icon2 instanceof IconStyle) {
            IconStyle icon4 = (IconStyle)icon2;
            tuple3 = Tuple3$.MODULE$.apply((Object)"i", (Object)Styles$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{icon4.styleName()})).$plus(icon4.options()), (Object)"");
        } else if (icon2 instanceof InlineSVGIcon) {
            InlineSVGIcon icon5 = (InlineSVGIcon)icon2;
            tuple3 = Tuple3$.MODULE$.apply((Object)"span", (Object)icon5.options(), (Object)icon5.content());
        } else if (icon2 instanceof SVGSymbolIcon) {
            SVGSymbolIcon icon6 = (SVGSymbolIcon)icon2;
            tuple3 = Tuple3$.MODULE$.apply((Object)"span", (Object)icon6.options(), (Object)new StringBuilder(60).append("<svg class=\"svg-icon\"><use class=\"svg-shape\" href=\"").append(HTMLRenderer.renderTarget$1(fmt$13, icon6.target())).append("\"/></svg>").toString());
        } else {
            throw new MatchError((Object)icon2);
        }
        Tuple3 tuple32 = tuple3;
        String tagName = (String)tuple32._1();
        Options options = (Options)tuple32._2();
        String content = (String)tuple32._3();
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"title");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, icon.title());
        return fmt$13.rawElement(tagName, options, content, fmt$13.optAttributes((Seq<Tuple2<String, Option<String>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    private static final Tuple2 sizeAttr$1$$anonfun$2() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Tuple2 sizeAttr$1(Option size, String styleName) {
        return (Tuple2)size.map((Function1 & Serializable)x$1 -> {
            Length length = x$1;
            if (length != null) {
                Length length2 = Length$.MODULE$.unapply(length);
                double d = length2._1();
                LengthUnit lengthUnit = length2._2();
                double amount = d;
                if (LengthUnit$px$.MODULE$.equals(lengthUnit)) {
                    return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)amount)).toString()), (Object)None$.MODULE$);
                }
            }
            if (length != null) {
                Length s = length;
                return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)Some$.MODULE$.apply((Object)new StringBuilder(1).append(styleName).append(":").append(s.displayValue()).toString()));
            }
            throw new MatchError((Object)length);
        }).getOrElse(HTMLRenderer::sizeAttr$1$$anonfun$2);
    }

    private static final String renderSimpleSpan$1(HTMLFormatter fmt$14, LazyRef WithFallback$lzy1$8, Span span) {
        Option option;
        Span span2 = span;
        if (span2 instanceof CitationLink) {
            CitationLink citationLink = CitationLink$.MODULE$.unapply((CitationLink)span2);
            String string = citationLink._1();
            String string2 = citationLink._2();
            Options options = citationLink._3();
            String ref = string;
            String label = string2;
            Options opt = options;
            Object[] objectArray = new Tuple2[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"href");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)new StringBuilder(1).append("#").append(ref).toString());
            return fmt$14.textElement("a", opt.$plus(Style$.MODULE$.citation()), new StringBuilder(2).append("[").append(label).append("]").toString(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (span2 instanceof FootnoteLink) {
            FootnoteLink footnoteLink = FootnoteLink$.MODULE$.unapply((FootnoteLink)span2);
            String string = footnoteLink._1();
            String string4 = footnoteLink._2();
            Options options = footnoteLink._3();
            String ref = string;
            String label = string4;
            Options opt = options;
            Object[] objectArray = new Tuple2[1];
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"href");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)new StringBuilder(1).append("#").append(ref).toString());
            return fmt$14.textElement("a", opt.$plus(Style$.MODULE$.footnote()), new StringBuilder(2).append("[").append(label).append("]").toString(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (span2 instanceof RawLink) {
            RawLink rawLink = RawLink$.MODULE$.unapply((RawLink)span2);
            Target target = rawLink._1();
            Options options = rawLink._2();
            Target target2 = target;
            return HTMLRenderer.renderTarget$1(fmt$14, target2);
        }
        if (span2 instanceof Image) {
            Image image = Image$.MODULE$.unapply((Image)span2);
            Target target = image._1();
            Option<Length> option2 = image._2();
            Option<Length> option3 = image._3();
            Option<String> option4 = image._4();
            Option<String> option5 = image._5();
            Options options = image._6();
            Target target3 = target;
            Option<Length> width = option2;
            Option<Length> height = option3;
            Option<String> alt = option4;
            Option<String> title = option5;
            Options opt = options;
            Tuple2 tuple2 = HTMLRenderer.sizeAttr$1(width, "width");
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option widthAttr = (Option)tuple2._1();
            Option wStyle = (Option)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)widthAttr, (Object)wStyle);
            Option widthAttr2 = (Option)tuple22._1();
            Option wStyle2 = (Option)tuple22._2();
            Tuple2 tuple23 = HTMLRenderer.sizeAttr$1(height, "height");
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Option heightAttr = (Option)tuple23._1();
            Option hStyle = (Option)tuple23._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)heightAttr, (Object)hStyle);
            Option heightAttr2 = (Option)tuple24._1();
            Option hStyle2 = (Option)tuple24._2();
            Option styleAttr = ((IterableOnceOps)Option$.MODULE$.option2Iterable(wStyle2).$plus$plus((IterableOnce)hStyle2)).reduceLeftOption((Function2 & Serializable)(a, b) -> new StringBuilder(1).append((String)a).append(";").append((String)b).toString());
            Object[] objectArray = new Tuple2[6];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"src");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Some$.MODULE$.apply((Object)HTMLRenderer.renderTarget$1(fmt$14, target3)));
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"alt");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, alt);
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"title");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, title);
            String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"width");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)widthAttr2);
            String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"height");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)heightAttr2);
            String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"style");
            objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)styleAttr);
            Seq<Tuple2<String, String>> allAttr = fmt$14.optAttributes((Seq<Tuple2<String, Option<String>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return fmt$14.emptyElement("img", opt, allAttr);
        }
        if (span2 instanceof Icon) {
            Icon icon = (Icon)span2;
            return HTMLRenderer.renderIcon$1(fmt$14, icon);
        }
        if (span2 instanceof LineBreak) {
            LineBreak lineBreak = LineBreak$.MODULE$.unapply((LineBreak)span2);
            Options options = lineBreak._1();
            return fmt$14.emptyElement("br");
        }
        if (span2 instanceof TemplateElement) {
            TemplateElement templateElement = TemplateElement$.MODULE$.unapply((TemplateElement)span2);
            Element element = templateElement._1();
            int n = templateElement._2();
            Options options = templateElement._3();
            Element elem = element;
            int indent = n;
            return fmt$14.withMinIndentation(indent, (Function1 & Serializable)_$9 -> _$9.child(elem));
        }
        if (span2 != null && !(option = HTMLRenderer.WithFallback$1(WithFallback$lzy1$8).unapply((Element)((Object)span2))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$14.child(fallback);
        }
        return "";
    }

    private static final String renderTableElement$1(HTMLFormatter fmt$15, TableElement elem) {
        TableElement tableElement = elem;
        if (tableElement instanceof TableHead) {
            TableHead tableHead = TableHead$.MODULE$.unapply((TableHead)tableElement);
            Seq<Row> seq = tableHead._1();
            Options options = tableHead._2();
            Seq<Row> rows = seq;
            Options opt = options;
            return fmt$15.indentedElement("thead", opt, rows, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof TableBody) {
            TableBody tableBody = TableBody$.MODULE$.unapply((TableBody)tableElement);
            Seq<Row> seq = tableBody._1();
            Options options = tableBody._2();
            Seq<Row> rows = seq;
            Options opt = options;
            return fmt$15.indentedElement("tbody", opt, rows, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof Columns) {
            Columns columns = Columns$.MODULE$.unapply((Columns)tableElement);
            Seq<Column> seq = columns._1();
            Options options = columns._2();
            Seq<Column> columns2 = seq;
            Options opt = options;
            return fmt$15.indentedElement("colgroup", opt, columns2, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof Row) {
            Row row = Row$.MODULE$.unapply((Row)tableElement);
            Seq<Cell> seq = row._1();
            Options options = row._2();
            Seq<Cell> cells = seq;
            Options opt = options;
            return fmt$15.indentedElement("tr", opt, cells, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof Caption) {
            Caption caption = Caption$.MODULE$.unapply((Caption)tableElement);
            Seq<Span> seq = caption._1();
            Options options = caption._2();
            Seq<Span> content = seq;
            Options opt = options;
            return fmt$15.element("caption", opt, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof Column) {
            Options options;
            Column column = Column$.MODULE$.unapply((Column)tableElement);
            Options opt = options = column._1();
            return fmt$15.textElement("col", opt, "", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof Cell) {
            Cell cell = Cell$.MODULE$.unapply((Cell)tableElement);
            CellType cellType = cell._1();
            Seq<Block> seq = cell._2();
            int n = cell._3();
            int n2 = cell._4();
            Options options = cell._5();
            if (HeadCell$.MODULE$.equals(cellType)) {
                Seq<Block> content = seq;
                int colspan = n;
                int rowspan = n2;
                Options opt = options;
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"colspan");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)HTMLRenderer.noneIfDefault$1(BoxesRunTime.boxToInteger((int)colspan), BoxesRunTime.boxToInteger((int)1)));
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rowspan");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)HTMLRenderer.noneIfDefault$1(BoxesRunTime.boxToInteger((int)rowspan), BoxesRunTime.boxToInteger((int)1)));
                return HTMLRenderer.renderBlocks$1(fmt$15, "th", opt, content, fmt$15.optAttributes((Seq<Tuple2<String, Option<String>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
            if (BodyCell$.MODULE$.equals(cellType)) {
                Seq<Block> content = seq;
                int colspan = n;
                int rowspan = n2;
                Options opt = options;
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"colspan");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)HTMLRenderer.noneIfDefault$1(BoxesRunTime.boxToInteger((int)colspan), BoxesRunTime.boxToInteger((int)1)));
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rowspan");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)HTMLRenderer.noneIfDefault$1(BoxesRunTime.boxToInteger((int)rowspan), BoxesRunTime.boxToInteger((int)1)));
                return HTMLRenderer.renderBlocks$1(fmt$15, "td", opt, content, fmt$15.optAttributes((Seq<Tuple2<String, Option<String>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
        }
        throw new MatchError((Object)tableElement);
    }

    private static final String renderUnresolvedReference$1(HTMLFormatter fmt$16, Reference ref) {
        return fmt$16.child(InvalidSpan$.MODULE$.apply(new StringBuilder(22).append("unresolved reference: ").append(ref).toString(), ref.source()));
    }

    private static final String renderInvalidElement$1(HTMLFormatter fmt$17, Invalid elem) {
        Invalid invalid = elem;
        if (invalid instanceof InvalidBlock) {
            InvalidBlock invalidBlock = InvalidBlock$.MODULE$.unapply((InvalidBlock)invalid);
            RuntimeMessage runtimeMessage = invalidBlock._1();
            SourceFragment sourceFragment = invalidBlock._2();
            Block block = invalidBlock._3();
            Options options = invalidBlock._4();
            RuntimeMessage msg = runtimeMessage;
            Block fallback = block;
            Options opt = options;
            return new StringBuilder(0).append(fmt$17.forMessage(msg, fmt$17.child(Paragraph$.MODULE$.apply((Seq<Span>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RuntimeMessage[]{msg}))), opt)))).append(fmt$17.child((Element)((Object)fallback))).toString();
        }
        Invalid e = invalid;
        return new StringBuilder(0).append(fmt$17.forMessage(e.message(), new StringBuilder(1).append(fmt$17.child(e.message())).append(" ").toString())).append(fmt$17.child(e.fallback())).toString();
    }

    private static final String renderRuntimeMessage$1(HTMLFormatter fmt$18, RuntimeMessage message) {
        return fmt$18.forMessage(message, fmt$18.textElement("span", message.options().$plus(Style$.MODULE$.runtimeMessage()).$plus(Styles$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{message.level().toString().toLowerCase()}))), message.content(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
    }
}

