/*
 * Decompiled with CFR 0.152.
 */
package laika.rewrite;

import java.io.Serializable;
import laika.ast.Document;
import laika.ast.Path;
import laika.ast.TreeCursor;
import laika.ast.TreePosition;
import laika.config.Config;
import laika.config.ConfigDecoder$;
import laika.config.ConfigError;
import laika.config.ConfigValue;
import laika.config.Key;
import laika.rewrite.ReferenceResolver$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public class ReferenceResolver
implements Product,
Serializable {
    private final Config config;

    public static ReferenceResolver apply(Config config) {
        return ReferenceResolver$.MODULE$.apply(config);
    }

    public static ReferenceResolver forDocument(Document document, TreeCursor treeCursor, Config config, TreePosition treePosition) {
        return ReferenceResolver$.MODULE$.forDocument(document, treeCursor, config, treePosition);
    }

    public static ReferenceResolver fromProduct(Product product) {
        return ReferenceResolver$.MODULE$.fromProduct(product);
    }

    public static ReferenceResolver unapply(ReferenceResolver referenceResolver) {
        return ReferenceResolver$.MODULE$.unapply(referenceResolver);
    }

    public ReferenceResolver(Config config) {
        this.config = config;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ReferenceResolver)) return false;
        ReferenceResolver referenceResolver = (ReferenceResolver)object;
        Config config = this.config();
        Config config2 = referenceResolver.config();
        if (config == null) {
            if (config2 != null) {
                return false;
            }
        } else if (!config.equals(config2)) return false;
        if (!referenceResolver.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ReferenceResolver;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "ReferenceResolver";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "config";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Config config() {
        return this.config;
    }

    public Either<ConfigError, Option<ConfigValue>> resolve(Key key) {
        return this.config().getOpt(key, ConfigDecoder$.MODULE$.configValue());
    }

    public ReferenceResolver copy(Config config) {
        return new ReferenceResolver(config);
    }

    public Config copy$default$1() {
        return this.config();
    }

    public Config _1() {
        return this.config();
    }

    public static class Siblings {
        private final Vector<Document> documents;
        private final Path refPath;
        private final int currentIndex;

        public Siblings(Vector<Document> documents, Path refPath) {
            this.documents = documents;
            this.refPath = refPath;
            this.currentIndex = documents.indexWhere((Function1 & Serializable)_$1 -> {
                Path path = _$1.path();
                Path path2 = refPath;
                return !(path != null ? !path.equals(path2) : path2 != null);
            });
        }

        public int currentIndex() {
            return this.currentIndex;
        }

        public Option<Document> previousDocument() {
            if (this.currentIndex() <= 0) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply(this.documents.apply(this.currentIndex() - 1));
        }

        public Option<Document> nextDocument() {
            if (this.documents.isEmpty() || this.currentIndex() + 1 == this.documents.size()) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply(this.documents.apply(this.currentIndex() + 1));
        }
    }
}

