/*
 * Decompiled with CFR 0.152.
 */
package laika.rewrite.link;

import cats.data.NonEmptySetImpl$;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import java.io.Serializable;
import laika.ast.DocumentCursor;
import laika.ast.DocumentTree;
import laika.ast.GlobalLink;
import laika.ast.InternalTarget;
import laika.ast.InternalTarget$;
import laika.ast.InvalidSpan$;
import laika.ast.Link;
import laika.ast.LocalLink;
import laika.ast.Path;
import laika.ast.Path$Root$;
import laika.ast.RelativePath;
import laika.ast.RelativePath$CurrentDocument$;
import laika.ast.RelativePath$CurrentTree$;
import laika.ast.ResolvedInternalTarget;
import laika.ast.Span;
import laika.ast.Target;
import laika.config.ConfigDecoder$;
import laika.config.LaikaKeys$;
import laika.parse.SourceFragment;
import laika.rewrite.Versions$;
import laika.rewrite.link.InvalidTarget;
import laika.rewrite.link.InvalidTarget$;
import laika.rewrite.link.LinkValidation;
import laika.rewrite.link.LinkValidation$;
import laika.rewrite.link.LinkValidation$Global$;
import laika.rewrite.link.LinkValidation$Local$;
import laika.rewrite.link.LinkValidation$Off$;
import laika.rewrite.link.RecoveredTarget;
import laika.rewrite.link.RecoveredTarget$;
import laika.rewrite.link.TargetValidation;
import laika.rewrite.link.ValidTarget$;
import laika.rewrite.nav.TargetFormats;
import laika.rewrite.nav.TargetFormats$;
import laika.rewrite.nav.TargetFormats$All$;
import laika.rewrite.nav.TargetFormats$None$;
import laika.rewrite.nav.TargetFormats$Selected$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public class LinkValidator {
    private final DocumentCursor cursor;
    private final Function1<Path, Option<TargetFormats>> findTargetFormats;
    private final Option<String> siteBaseURL;
    private final Seq<Path> excludedPaths;
    private final LinkValidation validationConfig;

    public LinkValidator(DocumentCursor cursor, Function1<Path, Option<TargetFormats>> findTargetFormats) {
        this.cursor = cursor;
        this.findTargetFormats = findTargetFormats;
        this.siteBaseURL = cursor.config().getOpt(LaikaKeys$.MODULE$.siteBaseURL(), ConfigDecoder$.MODULE$.string()).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Set versionRoots = ((IterableOnceOps)cursor.config().getOpt(Versions$.MODULE$.decoder(), Versions$.MODULE$.key()).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)vs -> (Seq)vs.allVersions().map((Function1 & Serializable)v -> ((Path)Path$Root$.MODULE$.$div(v.pathSegment()).$div("doc")).parent())).getOrElse(LinkValidator::$init$$$anonfun$2)).toSet();
        String newKey = "laika.links.validation.excluded";
        String oldKey = "laika.links.excludeFromValidation";
        Seq newValue = (Seq)cursor.config().get(newKey, ConfigDecoder$.MODULE$.seq(ConfigDecoder$.MODULE$.path())).getOrElse(LinkValidator::$anonfun$1);
        Seq oldValue = (Seq)cursor.config().get(oldKey, ConfigDecoder$.MODULE$.seq(ConfigDecoder$.MODULE$.path())).getOrElse(LinkValidator::$anonfun$2);
        Seq excludedExplicitly = (Seq)newValue.$plus$plus((IterableOnce)oldValue);
        this.excludedPaths = (Seq)excludedExplicitly.$plus$plus((IterableOnce)versionRoots);
        this.validationConfig = (LinkValidation)cursor.config().get(LinkValidation$.MODULE$.decoder(), LinkValidation$.MODULE$.key()).map((Function1 & Serializable)x$1 -> {
            LinkValidation linkValidation = x$1;
            if (linkValidation instanceof LinkValidation.Global) {
                LinkValidation.Global global = LinkValidation$Global$.MODULE$.unapply((LinkValidation.Global)linkValidation);
                Seq<Path> seq = global._1();
                return LinkValidation$Global$.MODULE$.apply(this.excludedPaths);
            }
            LinkValidation other = linkValidation;
            return other;
        }).getOrElse(LinkValidator::$init$$$anonfun$4);
    }

    private boolean isExcluded(Path path) {
        return this.excludedPaths.exists((Function1 & Serializable)other -> path.isSubPath((Path)other)) || this.hasExcludedFlag$1(path.relative());
    }

    public TargetValidation validate(InternalTarget target) {
        ResolvedInternalTarget resolvedTarget = target.relativeTo(this.cursor.path());
        LinkValidation linkValidation = this.validationConfig;
        if (LinkValidation$Off$.MODULE$.equals(linkValidation)) {
            return ValidTarget$.MODULE$;
        }
        if (LinkValidation$Local$.MODULE$.equals(linkValidation)) {
            if (!LinkValidator.isLocalTarget$1(resolvedTarget)) {
                return ValidTarget$.MODULE$;
            }
            return this.validateTarget$1(resolvedTarget);
        }
        if (linkValidation instanceof LinkValidation.Global) {
            LinkValidation.Global global = LinkValidation$Global$.MODULE$.unapply((LinkValidation.Global)linkValidation);
            Seq<Path> seq = global._1();
            return this.validateTarget$1(resolvedTarget);
        }
        throw new MatchError((Object)linkValidation);
    }

    public <L extends Link> Either<String, L> validate(L link) {
        L l = link;
        if (l instanceof GlobalLink) {
            GlobalLink gl = (GlobalLink)l;
            return this.validateTarget$2(link, gl.target());
        }
        if (l instanceof LocalLink) {
            LocalLink ll = (LocalLink)l;
            return this.validateTarget$2(link, InternalTarget$.MODULE$.apply(RelativePath$CurrentDocument$.MODULE$.apply(ll.refId())));
        }
        throw new MatchError(l);
    }

    public Span validateAndRecover(Link link, SourceFragment source) {
        Either either = package.all$.MODULE$.catsSyntaxEither(this.validate(link));
        return (Span)EitherOps$.MODULE$.valueOr$extension(either, (Function1 & Serializable)_$1 -> InvalidSpan$.MODULE$.apply((String)_$1, source));
    }

    private static final Seq $init$$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final Seq $anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final Seq $anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final LinkValidation $init$$$anonfun$4() {
        return LinkValidation$Local$.MODULE$;
    }

    private final Option getConfig$1(RelativePath path) {
        Option option;
        while (true) {
            if ((option = this.cursor.root().tree().target().selectSubtree(path)) instanceof Some) {
                DocumentTree tree = (DocumentTree)((Some)option).value();
                return Some$.MODULE$.apply((Object)tree.config());
            }
            if (!None$.MODULE$.equals(option)) break;
            RelativePath relativePath = path;
            RelativePath$CurrentTree$ relativePath$CurrentTree$ = RelativePath$CurrentTree$.MODULE$;
            if (!(relativePath != null ? !relativePath.equals(relativePath$CurrentTree$) : relativePath$CurrentTree$ != null)) {
                return None$.MODULE$;
            }
            path = path.parent();
        }
        throw new MatchError((Object)option);
    }

    private static final boolean hasExcludedFlag$1$$anonfun$1() {
        return false;
    }

    private static final boolean hasExcludedFlag$1$$anonfun$2$$anonfun$1() {
        return true;
    }

    private final boolean hasExcludedFlag$1(RelativePath path) {
        return BoxesRunTime.unboxToBoolean((Object)this.getConfig$1(path).fold(LinkValidator::hasExcludedFlag$1$$anonfun$1, (Function1 & Serializable)config -> !BoxesRunTime.unboxToBoolean((Object)config.get("laika.validateLinks", ConfigDecoder$.MODULE$.boolean()).getOrElse(LinkValidator::hasExcludedFlag$1$$anonfun$2$$anonfun$1))));
    }

    private static final boolean isLocalTarget$1(ResolvedInternalTarget resolvedTarget$1) {
        return resolvedTarget$1.relativePath() instanceof RelativePath.CurrentDocument;
    }

    private final TargetValidation attemptRecovery$1(ResolvedInternalTarget resolvedTarget$2, String message, TargetFormats targetFormats) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)targetFormats.contains("html")), this.siteBaseURL);
        return (TargetValidation)(tuple2 != null && BoxesRunTime.unboxToBoolean((Object)tuple2._1()) && tuple2._2() instanceof Some ? RecoveredTarget$.MODULE$.apply(message, resolvedTarget$2.copy(resolvedTarget$2.copy$default$1(), resolvedTarget$2.copy$default$2(), targetFormats)) : InvalidTarget$.MODULE$.apply(new StringBuilder(0).append(message).append(LinkValidator.validCondition$1()).toString()));
    }

    private static final String validCondition$1() {
        return " unless html is one of the formats and siteBaseUrl is defined";
    }

    private static final String invalidRefMsg$1(ResolvedInternalTarget resolvedTarget$3) {
        return new StringBuilder(28).append("cannot reference document '").append(resolvedTarget$3.relativePath().toString()).append("'").toString();
    }

    private final TargetValidation validateFormats$1(ResolvedInternalTarget resolvedTarget$5, TargetFormats targetFormats) {
        TargetFormats targetFormats2 = targetFormats;
        if (TargetFormats$All$.MODULE$.equals(targetFormats2)) {
            return ValidTarget$.MODULE$;
        }
        if (TargetFormats$None$.MODULE$.equals(targetFormats2)) {
            return InvalidTarget$.MODULE$.apply(new StringBuilder(33).append(LinkValidator.invalidRefMsg$1(resolvedTarget$5)).append(" as it is excluded from rendering").toString());
        }
        if (targetFormats2 instanceof TargetFormats.Selected) {
            TargetFormats.Selected selected = TargetFormats$Selected$.MODULE$.unapply((TargetFormats.Selected)targetFormats2);
            Object object = selected._1();
            TargetFormats targetFormats3 = this.cursor.target().targetFormats();
            if (TargetFormats$None$.MODULE$.equals(targetFormats3)) {
                return ValidTarget$.MODULE$;
            }
            if (TargetFormats$All$.MODULE$.equals(targetFormats3)) {
                return this.attemptRecovery$1(resolvedTarget$5, new StringBuilder(63).append("document for all output formats ").append(LinkValidator.invalidRefMsg$1(resolvedTarget$5)).append(" with restricted output formats").toString(), targetFormats);
            }
            if (targetFormats3 instanceof TargetFormats.Selected) {
                TargetFormats.Selected selected2 = TargetFormats$Selected$.MODULE$.unapply((TargetFormats.Selected)targetFormats3);
                Object object2 = selected2._1();
                Object formats = object2;
                SortedSet missingFormats = NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(formats).filterNot((Function1 & Serializable)format -> targetFormats.contains((String)format));
                if (missingFormats.isEmpty()) {
                    return ValidTarget$.MODULE$;
                }
                return this.attemptRecovery$1(resolvedTarget$5, new StringBuilder(62).append(LinkValidator.invalidRefMsg$1(resolvedTarget$5)).append(" that does not support some of the formats of this document (").append(missingFormats.mkString(", ")).append(")").toString(), targetFormats);
            }
            throw new MatchError((Object)targetFormats3);
        }
        throw new MatchError((Object)targetFormats2);
    }

    private static final TargetFormats $anonfun$4() {
        return TargetFormats$All$.MODULE$;
    }

    private final TargetValidation validateTarget$1(ResolvedInternalTarget resolvedTarget$4) {
        Option option = (Option)this.findTargetFormats.apply((Object)resolvedTarget$4.absolutePath());
        if (None$.MODULE$.equals(option)) {
            if (this.isExcluded(resolvedTarget$4.absolutePath())) {
                TargetFormats formats = (TargetFormats)this.cursor.root().treeConfig(resolvedTarget$4.absolutePath().parent()).get(TargetFormats$.MODULE$.decoder(), TargetFormats$.MODULE$.defaultKey()).getOrElse(LinkValidator::$anonfun$4);
                return this.validateFormats$1(resolvedTarget$4, formats);
            }
            return InvalidTarget$.MODULE$.apply(new StringBuilder(31).append("unresolved internal reference: ").append(resolvedTarget$4.relativePath().toString()).toString());
        }
        if (option instanceof Some) {
            TargetFormats targetFormats = (TargetFormats)((Some)option).value();
            return this.validateFormats$1(resolvedTarget$4, targetFormats);
        }
        throw new MatchError((Object)option);
    }

    private final Either validateTarget$2(Link link$1, Target target) {
        Target target2 = target;
        if (target2 instanceof InternalTarget) {
            InternalTarget it = (InternalTarget)target2;
            TargetValidation targetValidation = this.validate(it);
            if (ValidTarget$.MODULE$.equals(targetValidation)) {
                return package$.MODULE$.Right().apply((Object)link$1);
            }
            if (targetValidation instanceof InvalidTarget) {
                String string;
                InvalidTarget invalidTarget = InvalidTarget$.MODULE$.unapply((InvalidTarget)targetValidation);
                String error = string = invalidTarget._1();
                return package$.MODULE$.Left().apply((Object)error);
            }
            if (targetValidation instanceof RecoveredTarget) {
                GlobalLink gl;
                RecoveredTarget recoveredTarget = RecoveredTarget$.MODULE$.unapply((RecoveredTarget)targetValidation);
                String string = recoveredTarget._1();
                ResolvedInternalTarget resolvedInternalTarget = recoveredTarget._2();
                String error = string;
                ResolvedInternalTarget newTarget = resolvedInternalTarget;
                Link link = link$1;
                if (link instanceof GlobalLink && (gl = (GlobalLink)link).supportsExternalTargets()) {
                    return package$.MODULE$.Right().apply((Object)gl.withTarget(newTarget));
                }
                return package$.MODULE$.Left().apply((Object)error);
            }
            throw new MatchError((Object)targetValidation);
        }
        return package$.MODULE$.Right().apply((Object)link$1);
    }
}

