/*
 * Decompiled with CFR 0.152.
 */
package laika.rewrite.nav;

import java.io.Serializable;
import laika.ast.ExternalTarget$;
import laika.ast.Path;
import laika.ast.Path$Root$;
import laika.ast.RelativeInternalTarget$;
import laika.ast.RelativePath;
import laika.ast.ResolvedInternalTarget;
import laika.ast.ResolvedInternalTarget$;
import laika.ast.Target;
import laika.rewrite.OutputContext;
import laika.rewrite.nav.ConfigurablePathTranslator$;
import laika.rewrite.nav.PathAttributes;
import laika.rewrite.nav.PathTranslator;
import laika.rewrite.nav.TargetFormats;
import laika.rewrite.nav.TranslatorConfig;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ConfigurablePathTranslator
implements PathTranslator,
Product,
Serializable {
    private final TranslatorConfig config;
    private final OutputContext outputContext;
    private final Path refPath;
    private final Function1 targetLookup;
    private final Option<String> currentVersion;
    private final Path translatedRefPath;

    public static ConfigurablePathTranslator apply(TranslatorConfig translatorConfig, OutputContext outputContext, Path path, Function1<Path, Option<PathAttributes>> function1) {
        return ConfigurablePathTranslator$.MODULE$.apply(translatorConfig, outputContext, path, function1);
    }

    public static ConfigurablePathTranslator fromProduct(Product product) {
        return ConfigurablePathTranslator$.MODULE$.fromProduct(product);
    }

    public static ConfigurablePathTranslator unapply(ConfigurablePathTranslator configurablePathTranslator) {
        return ConfigurablePathTranslator$.MODULE$.unapply(configurablePathTranslator);
    }

    public ConfigurablePathTranslator(TranslatorConfig config, OutputContext outputContext, Path refPath, Function1<Path, Option<PathAttributes>> targetLookup) {
        this.config = config;
        this.outputContext = outputContext;
        this.refPath = refPath;
        this.targetLookup = targetLookup;
        this.currentVersion = config.versions().map((Function1 & Serializable)_$3 -> _$3.currentVersion().pathSegment());
        this.translatedRefPath = this.translate(refPath);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ConfigurablePathTranslator)) return false;
        ConfigurablePathTranslator configurablePathTranslator = (ConfigurablePathTranslator)object;
        TranslatorConfig translatorConfig = this.config();
        TranslatorConfig translatorConfig2 = configurablePathTranslator.config();
        if (translatorConfig == null) {
            if (translatorConfig2 != null) {
                return false;
            }
        } else if (!((Object)translatorConfig).equals(translatorConfig2)) return false;
        OutputContext outputContext = this.outputContext();
        OutputContext outputContext2 = configurablePathTranslator.outputContext();
        if (outputContext == null) {
            if (outputContext2 != null) {
                return false;
            }
        } else if (!((Object)outputContext).equals(outputContext2)) return false;
        Path path = this.refPath();
        Path path2 = configurablePathTranslator.refPath();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        Function1<Path, Option<PathAttributes>> function1 = this.targetLookup();
        Function1<Path, Option<PathAttributes>> function12 = configurablePathTranslator.targetLookup();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        if (!configurablePathTranslator.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ConfigurablePathTranslator;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "ConfigurablePathTranslator";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "config";
            }
            case 1: {
                return "outputContext";
            }
            case 2: {
                return "refPath";
            }
            case 3: {
                return "targetLookup";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public TranslatorConfig config() {
        return this.config;
    }

    public OutputContext outputContext() {
        return this.outputContext;
    }

    public Path refPath() {
        return this.refPath;
    }

    public Function1<Path, Option<PathAttributes>> targetLookup() {
        return this.targetLookup;
    }

    @Override
    public Option<PathAttributes> getAttributes(Path path) {
        return (Option)this.targetLookup().apply((Object)path);
    }

    @Override
    public Path translate(Path input) {
        String string = this.outputContext().formatSelector();
        String string2 = "html";
        return this.translate(input, !(string != null ? !string.equals(string2) : string2 != null));
    }

    private Path translate(Path input, boolean isHTMLTarget) {
        return (Path)this.getAttributes(input).fold(() -> ConfigurablePathTranslator.translate$$anonfun$1(input), (Function1 & Serializable)spec -> {
            Path shifted;
            Path path = shifted = spec.isVersioned() && isHTMLTarget ? (Path)this.currentVersion.fold(() -> ConfigurablePathTranslator.$anonfun$2(input), (Function1 & Serializable)version -> (Path)Path$Root$.MODULE$.$div((String)version).$div(input.relative())) : input;
            if (!spec.isStatic()) {
                String string = input.basename();
                String string2 = this.config().titleDocInputName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return (Path)shifted.withBasename(this.config().titleDocOutputName()).withSuffix(this.outputContext().fileSuffix());
                }
                return (Path)shifted.withSuffix(this.outputContext().fileSuffix());
            }
            return shifted;
        });
    }

    @Override
    public RelativePath translate(RelativePath input) {
        Path absolute = RelativeInternalTarget$.MODULE$.apply(input).relativeTo(this.refPath()).absolutePath();
        Path translated = this.translate(absolute);
        return translated.relativeTo(this.translatedRefPath);
    }

    @Override
    public Target translate(Target target) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)target, this.config().siteBaseURL());
        if (tuple2 != null) {
            Target target2 = (Target)tuple2._1();
            Option option = (Option)tuple2._2();
            if (target2 instanceof ResolvedInternalTarget) {
                ResolvedInternalTarget resolvedInternalTarget = ResolvedInternalTarget$.MODULE$.unapply((ResolvedInternalTarget)target2);
                Path path = resolvedInternalTarget._1();
                RelativePath relativePath = resolvedInternalTarget._2();
                TargetFormats targetFormats = resolvedInternalTarget._3();
                Path absolutePath = path;
                TargetFormats formats = targetFormats;
                if (option instanceof Some) {
                    String baseURL = (String)((Some)option).value();
                    if (!formats.contains(this.outputContext().formatSelector())) {
                        return ExternalTarget$.MODULE$.apply(new StringBuilder(0).append(baseURL).append(this.translate((Path)absolutePath.withSuffix("html"), true).relative().toString()).toString());
                    }
                }
            }
        }
        return PathTranslator.translate$(this, target);
    }

    @Override
    public PathTranslator forReferencePath(Path path) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), path, this.copy$default$4());
    }

    public ConfigurablePathTranslator copy(TranslatorConfig config, OutputContext outputContext, Path refPath, Function1<Path, Option<PathAttributes>> targetLookup) {
        return new ConfigurablePathTranslator(config, outputContext, refPath, targetLookup);
    }

    public TranslatorConfig copy$default$1() {
        return this.config();
    }

    public OutputContext copy$default$2() {
        return this.outputContext();
    }

    public Path copy$default$3() {
        return this.refPath();
    }

    public Function1<Path, Option<PathAttributes>> copy$default$4() {
        return this.targetLookup();
    }

    public TranslatorConfig _1() {
        return this.config();
    }

    public OutputContext _2() {
        return this.outputContext();
    }

    public Path _3() {
        return this.refPath();
    }

    public Function1<Path, Option<PathAttributes>> _4() {
        return this.targetLookup();
    }

    private static final Path translate$$anonfun$1(Path input$1) {
        return input$1;
    }

    private static final Path $anonfun$2(Path input$3) {
        return input$3;
    }
}

