/*
 * Decompiled with CFR 0.152.
 */
package laika.rst;

import cats.data.NonEmptyChainImpl$;
import cats.data.NonEmptyChainOps$;
import java.io.Serializable;
import laika.ast.Block;
import laika.ast.Cell;
import laika.ast.Cell$;
import laika.ast.CellType;
import laika.ast.Row;
import laika.ast.Row$;
import laika.bundle.BlockParserBuilder;
import laika.collection.Stack;
import laika.collection.TransitionalCollectionOps$Zip3Iterator$;
import laika.parse.BlockSource;
import laika.parse.BlockSource$;
import laika.parse.LineSource;
import laika.parse.LineSource$;
import laika.parse.SourceFragment;
import laika.parse.markup.RecursiveParsers;
import laika.rst.TableParsers$;
import laika.rst.TableParsers$CellBuilderRef$;
import laika.rst.TableParsers$CellElement$;
import laika.rst.TableParsers$CellSeparator$;
import laika.rst.TableParsers$TableBuilder$ColumnFactory$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class TableParsers {
    public static BlockParserBuilder gridTable() {
        return TableParsers$.MODULE$.gridTable();
    }

    public static BlockParserBuilder simpleTable() {
        return TableParsers$.MODULE$.simpleTable();
    }

    public static class CellBuilder {
        private final RecursiveParsers recParser;
        private final ListBuffer seps;
        private final ListBuffer<LineSource> previousLines;
        private Option<LineSource> currentLine;
        private int rowSpan;
        private int colSpan;
        private boolean removed;

        public CellBuilder(RecursiveParsers recParser) {
            this.recParser = recParser;
            this.seps = new ListBuffer();
            this.previousLines = new ListBuffer();
            this.currentLine = None$.MODULE$;
            this.rowSpan = 1;
            this.colSpan = 1;
            this.removed = false;
        }

        private ListBuffer<TableElement> seps() {
            return this.seps;
        }

        private Buffer<LineSource> allLines() {
            return (Buffer)this.previousLines.$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.currentLine).toBuffer());
        }

        public int rowSpan() {
            return this.rowSpan;
        }

        public void rowSpan_$eq(int x$1) {
            this.rowSpan = x$1;
        }

        public int colSpan() {
            return this.colSpan;
        }

        public void colSpan_$eq(int x$1) {
            this.colSpan = x$1;
        }

        public boolean removed() {
            return this.removed;
        }

        public void removed_$eq(boolean x$1) {
            this.removed = x$1;
        }

        public void nextLine(TableElement sep, LineSource line, boolean nextRow) {
            this.seps().$plus$eq((Object)sep);
            this.currentLine.foreach((Function1 & Serializable)_$1 -> (ListBuffer)this.previousLines.$plus$eq(_$1));
            this.currentLine = Some$.MODULE$.apply((Object)line);
            if (nextRow) {
                this.rowSpan_$eq(this.rowSpan() + 1);
                return;
            }
        }

        public void currentLine(TableElement sep, LineSource line) {
            this.currentLine.foreach((Function1)(JProcedure1 & Serializable)current -> {
                this.currentLine = Some$.MODULE$.apply((Object)LineSource$.MODULE$.apply(new StringBuilder(0).append(current.input()).append(sep.toString()).append(line.input()).toString(), current.parent()));
            });
        }

        public void merge(CellBuilder rightBuilder) {
            if (this.currentLine.isDefined()) {
                Seq newLines = TransitionalCollectionOps$Zip3Iterator$.MODULE$.apply(this.allLines(), rightBuilder.seps(), rightBuilder.allLines()).map((Function1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 != null) {
                        LineSource left = (LineSource)tuple3._1();
                        TableElement sep = (TableElement)tuple3._2();
                        LineSource right = (LineSource)tuple3._3();
                        return LineSource$.MODULE$.apply(new StringBuilder(0).append(left.input()).append(sep.toString()).append(right.input()).toString(), left.parent());
                    }
                    throw new MatchError((Object)tuple3);
                }).toSeq();
                this.previousLines.clear();
                this.previousLines.$plus$plus$eq((IterableOnce)newLines.tail());
                this.currentLine = newLines.headOption();
                this.colSpan_$eq(this.colSpan() + 1);
                return;
            }
        }

        public Option<BlockSource> trimmedCellContent() {
            return cats.data.package$.MODULE$.NonEmptyChain().fromSeq(this.allLines().toSeq()).map((Function1 & Serializable)nonEmptyLines -> {
                Object object = NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(nonEmptyLines);
                Object object2 = NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(NonEmptyChainOps$.MODULE$.map$extension(object, (Function1 & Serializable)line -> {
                    if (line.input().trim().isEmpty()) {
                        return Integer.MAX_VALUE;
                    }
                    return Predef$.MODULE$.wrapString(line.input()).prefixLength((Function1 & Serializable)_$2 -> this.$anonfun$2$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$2)));
                }));
                int minIndent = BoxesRunTime.unboxToInt((Object)NonEmptyChainOps$.MODULE$.iterator$extension(object2).min((Ordering)Ordering.Int$.MODULE$));
                Object object3 = NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(nonEmptyLines);
                Object trimmedLines = NonEmptyChainOps$.MODULE$.map$extension(object3, (Function1 & Serializable)line -> {
                    if (line.input().trim().isEmpty()) {
                        return LineSource$.MODULE$.apply("", line.parent());
                    }
                    String padding = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), Predef$.MODULE$.wrapString(line.input()).prefixLength((Function1 & Serializable)_$3 -> this.$anonfun$4(BoxesRunTime.unboxToChar((Object)_$3))) - minIndent);
                    return LineSource$.MODULE$.apply(new StringBuilder(0).append(padding).append(line.input().trim()).toString(), line.parent().consume(minIndent));
                });
                return BlockSource$.MODULE$.apply(trimmedLines);
            });
        }

        public Seq<Block> parsedCellContent() {
            return (Seq)this.trimmedCellContent().fold(this::parsedCellContent$$anonfun$1, (Function1 & Serializable)src -> (Seq)this.recParser.recursiveBlocks().parse((SourceFragment)src).getOrElse(this::parsedCellContent$$anonfun$2$$anonfun$1));
        }

        public Cell toCell(CellType ct) {
            return Cell$.MODULE$.apply(ct, this.parsedCellContent(), this.colSpan(), this.rowSpan(), Cell$.MODULE$.$lessinit$greater$default$5());
        }

        private final /* synthetic */ boolean $anonfun$2$$anonfun$1(char _$2) {
            return _$2 == ' ';
        }

        private final /* synthetic */ boolean $anonfun$4(char _$3) {
            return _$3 == ' ';
        }

        private final Seq parsedCellContent$$anonfun$1() {
            return package$.MODULE$.Nil();
        }

        private final Seq parsedCellContent$$anonfun$2$$anonfun$1() {
            return package$.MODULE$.Nil();
        }
    }

    public static class CellBuilderRef {
        private final CellBuilder cell;
        private final boolean mergedLeft;

        public static boolean $lessinit$greater$default$2() {
            return TableParsers$CellBuilderRef$.MODULE$.$lessinit$greater$default$2();
        }

        public CellBuilderRef(CellBuilder cell, boolean mergedLeft) {
            this.cell = cell;
            this.mergedLeft = mergedLeft;
        }

        public CellBuilder cell() {
            return this.cell;
        }

        public boolean mergedLeft() {
            return this.mergedLeft;
        }
    }

    public static class CellElement
    extends TableElement
    implements Product,
    Serializable {
        private final LineSource text;

        public static CellElement apply(LineSource lineSource) {
            return TableParsers$CellElement$.MODULE$.apply(lineSource);
        }

        public static CellElement fromProduct(Product product) {
            return TableParsers$CellElement$.MODULE$.fromProduct(product);
        }

        public static CellElement unapply(CellElement cellElement) {
            return TableParsers$CellElement$.MODULE$.unapply(cellElement);
        }

        public CellElement(LineSource text) {
            this.text = text;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CellElement)) return false;
            CellElement cellElement = (CellElement)object;
            LineSource lineSource = this.text();
            LineSource lineSource2 = cellElement.text();
            if (lineSource == null) {
                if (lineSource2 != null) {
                    return false;
                }
            } else if (!((Object)lineSource).equals(lineSource2)) return false;
            if (!cellElement.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof CellElement;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CellElement";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "text";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LineSource text() {
            return this.text;
        }

        public String toString() {
            return this.text().input();
        }

        public CellElement copy(LineSource text) {
            return new CellElement(text);
        }

        public LineSource copy$default$1() {
            return this.text();
        }

        public LineSource _1() {
            return this.text();
        }
    }

    public static class CellSeparator
    extends TableDecoration
    implements Product,
    Serializable {
        private final String decoration;

        public static CellSeparator apply(String string) {
            return TableParsers$CellSeparator$.MODULE$.apply(string);
        }

        public static CellSeparator fromProduct(Product product) {
            return TableParsers$CellSeparator$.MODULE$.fromProduct(product);
        }

        public static CellSeparator unapply(CellSeparator cellSeparator) {
            return TableParsers$CellSeparator$.MODULE$.unapply(cellSeparator);
        }

        public CellSeparator(String decoration) {
            this.decoration = decoration;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CellSeparator)) return false;
            CellSeparator cellSeparator = (CellSeparator)object;
            String string = this.decoration();
            String string2 = cellSeparator.decoration();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!cellSeparator.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof CellSeparator;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CellSeparator";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "decoration";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String decoration() {
            return this.decoration;
        }

        public String toString() {
            return this.decoration();
        }

        public CellSeparator copy(String decoration) {
            return new CellSeparator(decoration);
        }

        public String copy$default$1() {
            return this.decoration();
        }

        public String _1() {
            return this.decoration();
        }
    }

    public static class ColumnBuilder {
        private final Option<ColumnBuilder> left;
        private final RecursiveParsers recParser;
        private int rowSpan;
        private final Stack<CellBuilderRef> cells;

        public ColumnBuilder(Option<ColumnBuilder> left, RecursiveParsers recParser) {
            this.left = left;
            this.recParser = recParser;
            this.rowSpan = 1;
            this.cells = new Stack();
        }

        private int rowSpan() {
            return this.rowSpan;
        }

        private void rowSpan_$eq(int x$0) {
            this.rowSpan = x$0;
        }

        public CellBuilder currentCell() {
            return this.cells.top().cell();
        }

        public CellBuilder previousCell() {
            return ((CellBuilderRef)this.cells.elements().apply(1)).cell();
        }

        public CellBuilder nextCell() {
            if (this.cells.nonEmpty() && this.cells.top().mergedLeft() && this.rowspanDif() != 0) {
                throw new MalformedTableException("Illegal merging of rows with different cellspans");
            }
            CellBuilder cell = new CellBuilder(this.recParser);
            this.cells.push(new CellBuilderRef(cell, TableParsers$CellBuilderRef$.MODULE$.$lessinit$greater$default$2()));
            return cell;
        }

        private CellBuilder removeCell() {
            CellBuilder cell = this.cells.pop().cell();
            cell.removed_$eq(true);
            return cell;
        }

        public void mergeLeft(boolean previous) {
            if (this.rowspanDif() != 0) {
                throw new MalformedTableException("Illegal merging of cells with different rowspans");
            }
            CellBuilder leftCell = previous ? ((ColumnBuilder)this.left.get()).previousCell() : ((ColumnBuilder)this.left.get()).currentCell();
            leftCell.merge(this.removeCell());
            this.cells.push(new CellBuilderRef(leftCell, true));
        }

        public boolean mergeLeft$default$1() {
            return false;
        }

        public int rowspanDif() {
            return ((ColumnBuilder)this.left.get()).rowSpan() - this.rowSpan();
        }

        public void addLine(TableElement sep, LineSource line, boolean nextRow) {
            CellBuilderRef ref = this.cells.top();
            if (ref.mergedLeft()) {
                if (nextRow && this.rowspanDif() != 1) {
                    throw new MalformedTableException("Illegal merging of rows with different cellspans");
                }
                ref.cell().currentLine(sep, line);
            } else {
                ref.cell().nextLine(sep, line, nextRow);
                TableElement tableElement = sep;
                if (tableElement instanceof CellElement) {
                    CellElement cellElement = TableParsers$CellElement$.MODULE$.unapply((CellElement)tableElement);
                    LineSource lineSource = cellElement._1();
                    this.mergeLeft(this.mergeLeft$default$1());
                }
            }
            if (nextRow) {
                this.rowSpan_$eq(this.rowSpan() + 1);
                return;
            }
        }
    }

    public static class MalformedTableException
    extends RuntimeException {
        public MalformedTableException(String msg) {
            super(msg);
        }
    }

    public static class RowBuilder {
        private final ListBuffer<CellBuilder> cells = new ListBuffer();

        public void addCell(CellBuilder cell) {
            this.cells.$plus$eq((Object)cell);
        }

        public Row toRow(CellType ct) {
            return Row$.MODULE$.apply((Seq<Cell>)((ListBuffer)((StrictOptimizedIterableOps)this.cells.filterNot((Function1 & Serializable)_$4 -> _$4.removed())).map((Function1 & Serializable)_$5 -> _$5.toCell(ct))).toList(), Row$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static class TableBuilder {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TableBuilder.class.getDeclaredField("ColumnFactory$lzy1"));
        public final List<Object> laika$rst$TableParsers$TableBuilder$$columnWidths;
        public final RecursiveParsers laika$rst$TableParsers$TableBuilder$$recParser;
        private volatile Object ColumnFactory$lzy1;
        private final List columns;
        private final ListBuffer<RowBuilder> rows;

        public TableBuilder(List<Object> columnWidths, RecursiveParsers recParser) {
            this.laika$rst$TableParsers$TableBuilder$$columnWidths = columnWidths;
            this.laika$rst$TableParsers$TableBuilder$$recParser = recParser;
            this.columns = (List)package$.MODULE$.List().fill(columnWidths.length(), this::$init$$$anonfun$1);
            this.rows = new ListBuffer();
            this.init();
        }

        private final TableParsers$TableBuilder$ColumnFactory$ ColumnFactory() {
            Object object = this.ColumnFactory$lzy1;
            if (object instanceof TableParsers$TableBuilder$ColumnFactory$) {
                return (TableParsers$TableBuilder$ColumnFactory$)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (TableParsers$TableBuilder$ColumnFactory$)this.ColumnFactory$lzyINIT1();
        }

        private Object ColumnFactory$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.ColumnFactory$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        TableParsers$TableBuilder$ColumnFactory$ tableParsers$TableBuilder$ColumnFactory$ = null;
                        try {
                            tableParsers$TableBuilder$ColumnFactory$ = new TableParsers$TableBuilder$ColumnFactory$(this);
                            object2 = tableParsers$TableBuilder$ColumnFactory$ == null ? LazyVals.NullValue$.MODULE$ : tableParsers$TableBuilder$ColumnFactory$;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.ColumnFactory$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return tableParsers$TableBuilder$ColumnFactory$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public List<ColumnBuilder> columns() {
            return this.columns;
        }

        private void init() {
            RowBuilder row = this.nextRow();
            this.columns().foreach((Function1)(JProcedure1 & Serializable)col -> row.addCell(col.nextCell()));
        }

        public RowBuilder nextRow() {
            RowBuilder row = new RowBuilder();
            this.rows.$plus$eq((Object)row);
            return row;
        }

        public List<Row> toRowList(CellType ct) {
            return ((ListBuffer)this.rows.map((Function1 & Serializable)_$6 -> _$6.toRow(ct))).toList();
        }

        private final ColumnBuilder $init$$$anonfun$1() {
            return this.ColumnFactory().next();
        }
    }

    public static abstract class TableDecoration
    extends TableElement {
    }

    public static abstract class TableElement {
    }
}

