/*
 * Decompiled with CFR 0.152.
 */
package ambience.redirect;

import ambience.api.LinkRedirector;
import ambience.module.CustomOAuth2Client;
import ambience.module.ProjectConfig;
import ambience.module.UserDB;
import ambience.redirect.ETLRunner;
import ambience.redirect.ETLRunner$;
import ambience.redirect.ETLRunner$Result$;
import ambience.redirect.Shared$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.owasp.encoder.Encode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class FullLinkRedirector
implements LinkRedirector,
LoggingHelper2 {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(FullLinkRedirector.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(FullLinkRedirector.class.getDeclaredField("projectConfig$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FullLinkRedirector.class.getDeclaredField("cltnT$lzy1"));
    private volatile Object log$lzy1;
    private final CustomOAuth2Client oAuth2Client;
    private CodexDB db;
    private volatile Object cltnT$lzy1;
    private volatile Object projectConfig$lzy1;
    private final Scheduler scheduler;

    public FullLinkRedirector(CustomOAuth2Client oAuth2Client, CodexDB db) {
        this.oAuth2Client = oAuth2Client;
        this.db = db;
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<CodexCollection> cltnT() {
        Object object = this.cltnT$lzy1;
        if (object instanceof Task) {
            return (Task)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Task)this.cltnT$lzyINIT1();
    }

    private Object cltnT$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cltnT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Task task = null;
                    try {
                        task = this.db.getCodexCollection("Redirects");
                        object2 = task == null ? LazyVals.NullValue$.MODULE$ : task;
                        this.db = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltnT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return task;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ProjectConfig projectConfig() {
        Object object = this.projectConfig$lzy1;
        if (object instanceof ProjectConfig) {
            return (ProjectConfig)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ProjectConfig)this.projectConfig$lzyINIT1();
    }

    private Object projectConfig$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.projectConfig$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ProjectConfig projectConfig = null;
                    try {
                        projectConfig = (ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class));
                        object2 = projectConfig == null ? LazyVals.NullValue$.MODULE$ : projectConfig;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.projectConfig$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return projectConfig;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Function1<GravityRequest, Task<GravityResponse>> route() {
        return (Function1 & Serializable)request -> {
            Vector segs = request.unmatchedPath().segments();
            List parameters = request.parameters().items().map((Function1 & Serializable)kv -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)kv.name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)kv.value());
            });
            String remainsText = ((IterableOnceOps)segs.map((Function1 & Serializable)_$1 -> _$1.value())).mkString("/", "/", "");
            return (Task)this.oAuth2Client.optAuthenticated((Function1 & Serializable)optUser -> this.redirecting((Option<UserDB.User>)optUser, remainsText, (Seq<Tuple2<String, String>>)parameters)).apply(request);
        };
    }

    public Function1<GravityRequest, Task<GravityResponse>> redirecting(Option<UserDB.User> optUser, String remainsText, Seq<Tuple2<String, String>> parameters) {
        return (Function1 & Serializable)_$2 -> {
            this.log().info(() -> FullLinkRedirector.redirecting$$anonfun$1$$anonfun$1(remainsText), Line$.MODULE$.apply(29), FullName$.MODULE$.apply("ambience.redirect.FullLinkRedirector.redirecting"));
            CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("url", (BsonValue)BsonString$.MODULE$.apply(remainsText)), CodexFilter.Eq$.MODULE$.apply("enabled", (BsonValue)BsonBoolean$.MODULE$.apply(true))}));
            Task toptdoc = this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.findO((CodexFilter)filter).firstOptionL().map((Function1 & Serializable)optdoc -> optdoc));
            return toptdoc.flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Document doc = (Document)((Some)option).value();
                    int code = this.extractStatusCode(doc);
                    String defaultLocation = (String)doc.get("location", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).getOrElse(FullLinkRedirector::$anonfun$5);
                    return this.etl(optUser, doc, remainsText, parameters, ETLRunner$Result$.MODULE$.apply(defaultLocation, code)).map((Function1 & Serializable)res -> {
                        this.log().info(() -> FullLinkRedirector.redirecting$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(res), Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.redirect.FullLinkRedirector.redirecting"));
                        if (this.isBadLocation(res.to())) {
                            return Gravity$.MODULE$.NotFoundResponse("No location found");
                        }
                        return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.apply(res.code()), Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{Gravity.Header$.MODULE$.Location(this.buildLocation(res.to()))})), GravityResponse$.MODULE$.$lessinit$greater$default$3());
                    });
                }
                if (None$.MODULE$.equals(option)) {
                    return Gravity$.MODULE$.NotFoundResponseT("redirect " + remainsText + " not found");
                }
                throw new MatchError((Object)option);
            });
        };
    }

    public String buildLocation(String to) {
        if (to.startsWith("http:") || to.startsWith("https:")) {
            return to;
        }
        return this.projectConfig().WebURL() + "/" + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(to), "/");
    }

    public int extractStatusCode(Document doc) {
        Option option = doc.get("statusCode", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                return this.extractStatusCode(bs);
            }
            if (bsonValue instanceof BsonInt32) {
                BsonInt32 bi = (BsonInt32)bsonValue;
                return bi.getValue();
            }
        }
        return 307;
    }

    public int extractStatusCode(BsonString bs) {
        String string = bs.getValue();
        String string2 = Shared$.MODULE$.Http308();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return 308;
        }
        String string4 = Shared$.MODULE$.Http303();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return 303;
        }
        return 307;
    }

    public boolean isBadLocation(String s) {
        return s.trim().isEmpty() || s.trim().startsWith("?") || s.trim().startsWith("#");
    }

    public Task<ETLRunner.Result> etl(Option<UserDB.User> optUser, Document doc, String remainsText, Seq<Tuple2<String, String>> parameters, ETLRunner.Result defRes) {
        String parametersString = this.combineQuery(parameters);
        String chainset = (String)doc.get("chainset", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$4 -> _$4.getValue()).getOrElse(FullLinkRedirector::$anonfun$7);
        this.log().info(() -> FullLinkRedirector.etl$$anonfun$1(chainset), Line$.MODULE$.apply(82), FullName$.MODULE$.apply("ambience.redirect.FullLinkRedirector.etl"));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(chainset)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ETLRunner$.MODULE$.etlUser()))) {
            String chain = (String)doc.get("chain", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue()).getOrElse(FullLinkRedirector::$anonfun$9);
            this.log().info(() -> FullLinkRedirector.etl$$anonfun$2(chainset, chain), Line$.MODULE$.apply(85), FullName$.MODULE$.apply("ambience.redirect.FullLinkRedirector.etl"));
            return ETLRunner$.MODULE$.runETL(chainset, chain, optUser, remainsText, parametersString, parameters, defRes);
        }
        if (parametersString.isEmpty()) {
            return Task$.MODULE$.now((Object)ETLRunner$Result$.MODULE$.apply(String.valueOf(defRes.to()), defRes.code()));
        }
        if (defRes.to().contains("?")) {
            return Task$.MODULE$.now((Object)ETLRunner$Result$.MODULE$.apply(defRes.to() + "&" + parametersString, defRes.code()));
        }
        return Task$.MODULE$.now((Object)ETLRunner$Result$.MODULE$.apply(defRes.to() + "?" + parametersString, defRes.code()));
    }

    public String combineQuery(Seq<Tuple2<String, String>> parameters) {
        return ((IterableOnceOps)parameters.map((Function1 & Serializable)pair -> pair._1() + "=" + Encode.forUriComponent((String)((String)pair._2())))).mkString("&");
    }

    private static final Object redirecting$$anonfun$1$$anonfun$1(String remainsText$3) {
        return "remainsText = " + remainsText$3;
    }

    private static final String $anonfun$5() {
        return "";
    }

    private static final Object redirecting$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(ETLRunner.Result res$1) {
        return "got location: " + res$1.to();
    }

    private static final String $anonfun$7() {
        return "";
    }

    private static final Object etl$$anonfun$1(String chainset$1) {
        return "chainset " + chainset$1;
    }

    private static final String $anonfun$9() {
        return "";
    }

    private static final Object etl$$anonfun$2(String chainset$2, String chain$1) {
        return "got chainset: " + chainset$2 + " and chain " + chain$1;
    }
}

