/*
 * Decompiled with CFR 0.152.
 */
package ambience.users;

import ambience.arch.EitherTELM;
import ambience.arch.EitherTELM$;
import ambience.framework.AdminCollections$;
import ambience.module.UserDB;
import ambience.session.SessionManager;
import ambience.users.LookupMap$;
import ambience.users.UserManager;
import ambience.users.UserManager$CloseSessions$;
import ambience.users.UserManager$Result$;
import ambience.users.UserManager$SetEnabled$;
import ambience.users.UserManager$SetName$;
import ambience.users.UserManager$SetPrivileges$;
import ambience.users.UserManager$SetRoles$;
import ambience.users.UserManager$Updates$;
import ambience.users.UserManager$UserInfo$;
import ambience.users.UsersModule$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$None$;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexUpdate;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class UserUpdate$
implements Serializable {
    public static final UserUpdate$ MODULE$ = new UserUpdate$();

    private UserUpdate$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UserUpdate$.class);
    }

    public Task<LogMessage> apply(UserDB.User user, BsonObjectId id, BsonValue key, Document doc) {
        EitherTELM outcome = EitherTELM$.MODULE$.apply(this.getById(user, id)).flatMap((Function1 & Serializable)prevDoc -> EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> UserUpdate$.$anonfun$1$$anonfun$1(prevDoc))).flatMap((Function1 & Serializable)prev -> EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> UserUpdate$.$anonfun$1$$anonfun$2$$anonfun$1(doc))).flatMap((Function1 & Serializable)current -> EitherTELM$.MODULE$.apply(LookupMap$.MODULE$.build()).flatMap((Function1 & Serializable)lookup -> EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> UserUpdate$.$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(prev, current))).flatMap((Function1 & Serializable)updates -> EitherTELM$.MODULE$.apply(MODULE$.applyUpdates(user, id, (UserManager.Updates)updates)).flatMap((Function1 & Serializable)result -> EitherTELM$.MODULE$.apply(MODULE$.closeSessionsIfNecessary(user, id, (UserManager.Updates)updates)).flatMap((Function1 & Serializable)updates2 -> EitherTELM$.MODULE$.apply(MODULE$.auditUpdates(user, id, prev.name().getValue(), (Map<BsonObjectId, String>)lookup, (UserManager.Updates)updates2, (UserManager.Result)result)).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return result;
        }))))))));
        return outcome.value().map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return msg;
            }
            if (either instanceof Right) {
                UserManager.Result result = (UserManager.Result)((Right)either).value();
                UserManager.Result result2 = UserManager$Result$.Updated;
                UserManager.Result result3 = result;
                if (!(result2 != null ? !result2.equals(result3) : result3 != null)) {
                    return LogMessage$None$.MODULE$;
                }
                UserManager.Result result4 = UserManager$Result$.NoChange;
                UserManager.Result result5 = result;
                if (!(result4 != null ? !result4.equals(result5) : result5 != null)) {
                    return LogMessage$None$.MODULE$;
                }
                UserManager.Result result6 = UserManager$Result$.Failed;
                UserManager.Result result7 = result;
                if (!(result6 != null ? !result6.equals(result7) : result7 != null)) {
                    return LogMessage.Error$.MODULE$.apply("Update Failed");
                }
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, Document>> getById(UserDB.User user, BsonObjectId id) {
        return AdminCollections$.MODULE$.usersT().flatMap((Function1 & Serializable)cltn -> cltn.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)id)).firstOptionL().map((Function1 & Serializable)_$1 -> _$1.toRight(() -> UserUpdate$.getById$$anonfun$1$$anonfun$1$$anonfun$1(id))).map((Function1 & Serializable)user -> user));
    }

    public Either<LogMessage, UserManager.UserInfo> asUserInfo(Document doc) {
        return doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)name -> doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).flatMap((Function1 & Serializable)enabled -> doc.get("roles", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)arr -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(arr.getValues()).asScala().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(BsonValue x) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonObjectId) {
                    BsonObjectId id = (BsonObjectId)bsonValue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(BsonValue x, Function1 function1) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonObjectId) {
                    BsonObjectId id = (BsonObjectId)bsonValue;
                    return id;
                }
                return function1.apply((Object)x);
            }
        })).toSet()).flatMap((Function1 & Serializable)roles -> doc.get("privileges", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)arr -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(arr.getValues()).asScala().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(BsonValue x) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonObjectId) {
                    BsonObjectId id = (BsonObjectId)bsonValue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(BsonValue x, Function1 function1) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonObjectId) {
                    BsonObjectId id = (BsonObjectId)bsonValue;
                    return id;
                }
                return function1.apply((Object)x);
            }
        })).toSet()).map((Function1 & Serializable)privileges -> UserManager$UserInfo$.MODULE$.apply((BsonString)name, (BsonBoolean)enabled, (Set<BsonObjectId>)roles, (Set<BsonObjectId>)privileges))))).toRight(() -> UserUpdate$.asUserInfo$$anonfun$2(doc));
    }

    public Either<LogMessage, UserManager.Updates> computeUpdates(UserManager.UserInfo prev, UserManager.UserInfo current) {
        Nil$ nil$;
        Nil$ nil$2;
        BsonString bsonString = prev.name();
        BsonString bsonString2 = current.name();
        Nil$ nameChange = (bsonString == null ? bsonString2 != null : !bsonString.equals(bsonString2)) ? (List)new .colon.colon((Object)UserManager$SetName$.MODULE$.apply(current.name()), (List)Nil$.MODULE$) : package$.MODULE$.Nil();
        BsonBoolean bsonBoolean = prev.enabled();
        BsonBoolean bsonBoolean2 = current.enabled();
        Nil$ enabledChange = (bsonBoolean == null ? bsonBoolean2 != null : !bsonBoolean.equals(bsonBoolean2)) ? (List)new .colon.colon((Object)UserManager$SetEnabled$.MODULE$.apply(current.enabled()), (List)Nil$.MODULE$) : package$.MODULE$.Nil();
        Set<BsonObjectId> set = prev.roles();
        Set<BsonObjectId> set2 = current.roles();
        if (set == null ? set2 != null : !set.equals(set2)) {
            Set add = (Set)current.roles().$minus$minus(prev.roles());
            Set remove = (Set)prev.roles().$minus$minus(current.roles());
            nil$2 = (List)new .colon.colon((Object)UserManager$SetRoles$.MODULE$.apply(current.roles(), (Set<BsonObjectId>)add, (Set<BsonObjectId>)remove), (List)Nil$.MODULE$);
        } else {
            nil$2 = package$.MODULE$.Nil();
        }
        Nil$ rolesChange = nil$2;
        Set<BsonObjectId> set3 = prev.privileges();
        Set<BsonObjectId> set4 = current.privileges();
        if (set3 == null ? set4 != null : !set3.equals(set4)) {
            Set add = (Set)current.privileges().$minus$minus(prev.privileges());
            Set remove = (Set)prev.privileges().$minus$minus(current.privileges());
            nil$ = (List)new .colon.colon((Object)UserManager$SetPrivileges$.MODULE$.apply(current.privileges(), (Set<BsonObjectId>)add, (Set<BsonObjectId>)remove), (List)Nil$.MODULE$);
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        Nil$ privilegesChange = nil$;
        return package$.MODULE$.Right().apply((Object)UserManager$Updates$.MODULE$.apply((List<UserManager.Update>)nameChange.$colon$colon$colon((List)privilegesChange).$colon$colon$colon((List)rolesChange).$colon$colon$colon((List)enabledChange)));
    }

    public Task<Either<LogMessage, UserManager.Result>> applyUpdates(UserDB.User user, BsonObjectId id, UserManager.Updates updates) {
        Option<CodexUpdate> option = this.combine((List<CodexUpdate>)updates.all().flatMap((Function1 & Serializable)update -> MODULE$.buildCodexUpdate((UserManager.Update)update)));
        if (option instanceof Some) {
            CodexUpdate update2 = (CodexUpdate)((Some)option).value();
            return AdminCollections$.MODULE$.usersT().flatMap((Function1 & Serializable)_$2 -> _$2.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)id), update2)).map((Function1 & Serializable)reply -> {
                if (reply.matchedCount() == 1L) {
                    return ambience.arch.package$.MODULE$.right((Object)UserManager$Result$.Updated);
                }
                return ambience.arch.package$.MODULE$.right((Object)UserManager$Result$.Failed);
            });
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)ambience.arch.package$.MODULE$.right((Object)UserManager$Result$.NoChange));
        }
        throw new MatchError(option);
    }

    public Task<Either<LogMessage, UserManager.Updates>> closeSessionsIfNecessary(UserDB.User user, BsonObjectId id, UserManager.Updates updates) {
        if (this.isDisable(updates)) {
            SessionManager sessionManager = (SessionManager)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(SessionManager.class));
            UserDB userDB = (UserDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(UserDB.class));
            return userDB.getUserById(id.getValue().toHexString()).flatMap((Function1 & Serializable)optTarget -> ((Task)optTarget.map((Function1 & Serializable)target -> sessionManager.getCurrentSessions(target)).getOrElse(UserUpdate$::closeSessionsIfNecessary$$anonfun$1$$anonfun$2)).flatMap((Function1 & Serializable)sessions -> ((Task)optTarget.map((Function1 & Serializable)target -> {
                if (sessions.nonEmpty()) {
                    return sessionManager.endUserSessions(target, sessions.map((Function1 & Serializable)_$3 -> new SessionManager.SessionId(_$3.id())), "user enabled=false");
                }
                return Task$.MODULE$.unit();
            }).getOrElse(UserUpdate$::closeSessionsIfNecessary$$anonfun$1$$anonfun$3$$anonfun$2)).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package$.MODULE$.Right().apply((Object)UserManager$Updates$.MODULE$.apply((List<UserManager.Update>)((List)updates.all().$plus$plus((IterableOnce)new .colon.colon((Object)UserManager$CloseSessions$.MODULE$.apply(sessions.size()), (List)Nil$.MODULE$)))));
            })));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)updates));
    }

    public boolean isDisable(UserManager.Updates updates) {
        return updates.all().contains((Object)UserManager$SetEnabled$.MODULE$.apply(BsonBoolean$.MODULE$.apply(false)));
    }

    public Task<Either<LogMessage, BoxedUnit>> auditUpdates(UserDB.User user, BsonObjectId id, String originalName, Map<BsonObjectId, String> lookup, UserManager.Updates updates, UserManager.Result result) {
        return Task$.MODULE$.apply(() -> UserUpdate$.auditUpdates$$anonfun$1(updates, user, id, originalName, lookup, result));
    }

    public void auditUpdate(UserDB.User user, BsonObjectId id, String originalName, Map<BsonObjectId, String> lookup, UserManager.Result result, UserManager.Update update) {
        String obj = id.getValue().toHexString() + "[" + originalName + "]";
        String verb = this.getVerb(update);
        String info = this.getInfo(update, lookup).noSpaces();
        UserManager.Result result2 = result;
        UserManager.Result result3 = UserManager$Result$.Updated;
        AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(!(result2 != null ? !result2.equals(result3) : result3 != null), obj, verb, (Option)Some$.MODULE$.apply((Object)info));
        AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(user.name(), UsersModule$.MODULE$.AuditComponent(), action);
        ((AuditAPI.AuditAppender)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(AuditAPI.AuditAppender.class))).append(auditMsg);
    }

    public String getVerb(UserManager.Update update) {
        UserManager.Update update2 = update;
        if (update2 instanceof UserManager.SetName) {
            UserManager.SetName u = (UserManager.SetName)update2;
            return "SetName";
        }
        if (update2 instanceof UserManager.SetEnabled) {
            UserManager.SetEnabled u = (UserManager.SetEnabled)update2;
            return "SetEnabled";
        }
        if (update2 instanceof UserManager.SetRoles) {
            UserManager.SetRoles u = (UserManager.SetRoles)update2;
            return "SetRoles";
        }
        if (update2 instanceof UserManager.SetPrivileges) {
            UserManager.SetPrivileges u = (UserManager.SetPrivileges)update2;
            return "SetPrivileges";
        }
        if (update2 instanceof UserManager.CloseSessions) {
            UserManager.CloseSessions u = (UserManager.CloseSessions)update2;
            return "CloseSessions";
        }
        throw new MatchError((Object)update2);
    }

    public Json getInfo(UserManager.Update update, Map<BsonObjectId, String> lookup) {
        UserManager.Update update2 = update;
        if (update2 instanceof UserManager.SetName) {
            BsonString bsonString;
            UserManager.SetName setName = UserManager$SetName$.MODULE$.unapply((UserManager.SetName)update2);
            BsonString name = bsonString = setName._1();
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(name.getValue()));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (update2 instanceof UserManager.SetEnabled) {
            BsonBoolean bsonBoolean;
            UserManager.SetEnabled setEnabled = UserManager$SetEnabled$.MODULE$.unapply((UserManager.SetEnabled)update2);
            BsonBoolean b = bsonBoolean = setEnabled._1();
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"enabled");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromBoolean(b.getValue()));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (update2 instanceof UserManager.SetRoles) {
            UserManager.SetRoles setRoles = UserManager$SetRoles$.MODULE$.unapply((UserManager.SetRoles)update2);
            Set<BsonObjectId> set = setRoles._1();
            Set<BsonObjectId> set2 = setRoles._2();
            Set<BsonObjectId> set3 = setRoles._3();
            Set<BsonObjectId> added = set2;
            Set<BsonObjectId> removed = set3;
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"added");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)LookupMap$.MODULE$.idsToJson(added, lookup));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"removed");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)LookupMap$.MODULE$.idsToJson(removed, lookup));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (update2 instanceof UserManager.SetPrivileges) {
            UserManager.SetPrivileges setPrivileges = UserManager$SetPrivileges$.MODULE$.unapply((UserManager.SetPrivileges)update2);
            Set<BsonObjectId> set = setPrivileges._1();
            Set<BsonObjectId> set4 = setPrivileges._2();
            Set<BsonObjectId> set5 = setPrivileges._3();
            Set<BsonObjectId> added = set4;
            Set<BsonObjectId> removed = set5;
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"added");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)LookupMap$.MODULE$.idsToJson(added, lookup));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"removed");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)LookupMap$.MODULE$.idsToJson(removed, lookup));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (update2 instanceof UserManager.CloseSessions) {
            int n;
            UserManager.CloseSessions closeSessions = UserManager$CloseSessions$.MODULE$.unapply((UserManager.CloseSessions)update2);
            int count = n = closeSessions._1();
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"closed-sessions");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromInt(count));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        throw new MatchError((Object)update2);
    }

    public Option<CodexUpdate> buildCodexUpdate(UserManager.Update update) {
        UserManager.Update update2 = update;
        if (update2 instanceof UserManager.SetName) {
            BsonString bsonString;
            UserManager.SetName setName = UserManager$SetName$.MODULE$.unapply((UserManager.SetName)update2);
            BsonString name = bsonString = setName._1();
            return Some$.MODULE$.apply((Object)CodexUpdate.Set$.MODULE$.apply("name", (BsonValue)name));
        }
        if (update2 instanceof UserManager.SetEnabled) {
            BsonBoolean bsonBoolean;
            UserManager.SetEnabled setEnabled = UserManager$SetEnabled$.MODULE$.unapply((UserManager.SetEnabled)update2);
            BsonBoolean b = bsonBoolean = setEnabled._1();
            return Some$.MODULE$.apply((Object)CodexUpdate.Set$.MODULE$.apply("enabled", (BsonValue)b));
        }
        if (update2 instanceof UserManager.SetRoles) {
            UserManager.SetRoles setRoles = UserManager$SetRoles$.MODULE$.unapply((UserManager.SetRoles)update2);
            Set<BsonObjectId> set = setRoles._1();
            Set<BsonObjectId> set2 = setRoles._2();
            Set<BsonObjectId> set3 = setRoles._3();
            Set<BsonObjectId> ids = set;
            return Some$.MODULE$.apply((Object)CodexUpdate.Set$.MODULE$.apply("roles", (BsonValue)BsonArray$.MODULE$.fromIterable(ids)));
        }
        if (update2 instanceof UserManager.SetPrivileges) {
            UserManager.SetPrivileges setPrivileges = UserManager$SetPrivileges$.MODULE$.unapply((UserManager.SetPrivileges)update2);
            Set<BsonObjectId> set = setPrivileges._1();
            Set<BsonObjectId> set4 = setPrivileges._2();
            Set<BsonObjectId> set5 = setPrivileges._3();
            Set<BsonObjectId> ids = set;
            return Some$.MODULE$.apply((Object)CodexUpdate.Set$.MODULE$.apply("privileges", (BsonValue)BsonArray$.MODULE$.fromIterable(ids)));
        }
        if (update2 instanceof UserManager.CloseSessions) {
            UserManager.CloseSessions closeSessions = UserManager$CloseSessions$.MODULE$.unapply((UserManager.CloseSessions)update2);
            int n = closeSessions._1();
            return None$.MODULE$;
        }
        throw new MatchError((Object)update2);
    }

    public Option<CodexUpdate> combine(List<CodexUpdate> updates) {
        List<CodexUpdate> list = updates;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<CodexUpdate> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            CodexUpdate head = (CodexUpdate)colon2.head();
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                return Some$.MODULE$.apply((Object)head);
            }
        }
        List<CodexUpdate> rest = list;
        return Some$.MODULE$.apply((Object)CodexUpdate.Combine$.MODULE$.apply(rest));
    }

    private static final Either $anonfun$1$$anonfun$1(Document prevDoc$1) {
        return MODULE$.asUserInfo(prevDoc$1);
    }

    private static final Either $anonfun$1$$anonfun$2$$anonfun$1(Document doc$3) {
        return MODULE$.asUserInfo(doc$3);
    }

    private static final Either $anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(UserManager.UserInfo prev$3, UserManager.UserInfo current$2) {
        return MODULE$.computeUpdates(prev$3, current$2);
    }

    private static final LogMessage.Error getById$$anonfun$1$$anonfun$1$$anonfun$1(BsonObjectId id$10) {
        return LogMessage.Error$.MODULE$.apply("User " + id$10 + " not found");
    }

    private static final LogMessage.Error asUserInfo$$anonfun$2(Document doc$7) {
        return LogMessage.Error$.MODULE$.apply("Can't build UserInfo from " + doc$7);
    }

    private static final Nil$ closeSessionsIfNecessary$$anonfun$1$$anonfun$2$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final Task closeSessionsIfNecessary$$anonfun$1$$anonfun$2() {
        return Task$.MODULE$.apply(UserUpdate$::closeSessionsIfNecessary$$anonfun$1$$anonfun$2$$anonfun$1);
    }

    private static final Task closeSessionsIfNecessary$$anonfun$1$$anonfun$3$$anonfun$2() {
        return Task$.MODULE$.unit();
    }

    private static final Either auditUpdates$$anonfun$1(UserManager.Updates updates$5, UserDB.User user$8, BsonObjectId id$12, String originalName$1, Map lookup$4, UserManager.Result result$3) {
        updates$5.all().foreach((Function1)(JProcedure1 & Serializable)update -> MODULE$.auditUpdate(user$8, id$12, originalName$1, (Map<BsonObjectId, String>)lookup$4, result$3, (UserManager.Update)update));
        return ambience.arch.package$.MODULE$.RUnit();
    }
}

