/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.gravity.netty4;

import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.Gravity$Header$;
import com.elixirtech.gravity.Gravity$Headers$;
import com.elixirtech.gravity.Gravity$Host$;
import com.elixirtech.gravity.Gravity$Parameter$;
import com.elixirtech.gravity.Gravity$Parameters$;
import com.elixirtech.gravity.Gravity$Path$;
import com.elixirtech.gravity.Gravity$RequestBody$;
import com.elixirtech.gravity.Gravity$RequestId$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityRequest$;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class Request$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Request$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final Request$ MODULE$ = new Request$();

    private Request$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Request$.class);
    }

    public Either<LogMessage, GravityRequest> apply(HttpRequest request) {
        return this.getMethod(request.method()).map((Function1 & Serializable)method -> {
            String id = Gravity$RequestId$.MODULE$.apply(UUID.randomUUID().toString());
            String host = Gravity$Host$.MODULE$.apply(request.headers().get((CharSequence)HttpHeaderNames.HOST, "unknown"));
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.uri());
            Gravity.Path path = MODULE$.extractPath(queryStringDecoder);
            Gravity.Headers headers = MODULE$.getHeaders(request);
            Gravity.Parameters parameters = MODULE$.getParameters(queryStringDecoder);
            String queryString = queryStringDecoder.rawQuery();
            return GravityRequest$.MODULE$.apply(id, host, path, path, (Gravity.Method)method, headers, parameters, Gravity$RequestBody$.MODULE$.empty(), queryString);
        });
    }

    public Gravity.Path extractPath(QueryStringDecoder decoder) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(decoder.rawPath()), "/").split("/"));
        Vector parts = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)s -> MODULE$.decodeComponent((String)s), ClassTag$.MODULE$.apply(String.class))).toVector();
        return Gravity$Path$.MODULE$.fromRaw((Vector<String>)parts);
    }

    public String decodeComponent(String s) {
        return QueryStringDecoder.decodeComponent((String)s.replace("+", "%2B"));
    }

    public Either<LogMessage, Gravity.Method> getMethod(HttpMethod method) {
        HttpMethod httpMethod = method;
        HttpMethod httpMethod2 = HttpMethod.GET;
        if (!(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null)) {
            return package$.MODULE$.Right().apply((Object)Gravity$.MODULE$.GET());
        }
        HttpMethod httpMethod3 = method;
        HttpMethod httpMethod4 = HttpMethod.POST;
        if (!(httpMethod3 != null ? !httpMethod3.equals(httpMethod4) : httpMethod4 != null)) {
            return package$.MODULE$.Right().apply((Object)Gravity$.MODULE$.POST());
        }
        HttpMethod httpMethod5 = method;
        HttpMethod httpMethod6 = HttpMethod.DELETE;
        if (!(httpMethod5 != null ? !httpMethod5.equals(httpMethod6) : httpMethod6 != null)) {
            return package$.MODULE$.Right().apply((Object)Gravity$.MODULE$.DELETE());
        }
        return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Unsupported method: " + method.name()));
    }

    public Gravity.Headers getHeaders(HttpRequest request) {
        return Gravity$Headers$.MODULE$.apply((List<Gravity.Header>)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)request.headers()).asScala().filter((Function1 & Serializable)h -> MODULE$.allowedHeader((Map.Entry<String, String>)h))).map((Function1 & Serializable)h -> Gravity$Header$.MODULE$.apply((String)h.getKey(), (String)h.getValue()))).toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean allowedHeader(Map.Entry<String, String> h) {
        String string = h.getKey();
        String string2 = Gravity$.MODULE$.ElxPeerCertificateSubjectDN();
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = h.getKey();
        String string4 = Gravity$.MODULE$.ElxPeerIP();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    public Gravity.Parameters getParameters(QueryStringDecoder queryStringDecoder) {
        Map params = queryStringDecoder.parameters();
        return Gravity$Parameters$.MODULE$.apply((List<Gravity.Parameter>)((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(params).asScala().flatMap((Function1 & Serializable)h -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)h._2()).asScala().map((Function1 & Serializable)value -> Gravity$Parameter$.MODULE$.apply((String)h._1(), (String)value)))).toList());
    }
}

