/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.webserver;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.param.Template$;
import com.elixirtech.webserver.I18N;
import com.elixirtech.webserver.I18N$;
import com.elixirtech.webserver.WebReply$;
import com.elixirtech.webserver.WebReply$ProcessState$;
import com.elixirtech.webserver.WebReply$Supplier$;
import com.elixirtech.webserver.WebReply$SupplyChain$;
import com.elixirtech.webserver.WebTree;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class WebReply
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WebReply.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private Supplier supplier;

    public static String safeOutput(String string) {
        return WebReply$.MODULE$.safeOutput(string);
    }

    public WebReply(WebTree webFile) {
        this.supplier = WebReply$SupplyChain$.MODULE$.apply(webFile, WebReply$Supplier$.MODULE$.empty());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void addSupplier(Supplier s) {
        this.supplier = WebReply$SupplyChain$.MODULE$.apply(s, this.supplier);
    }

    public Option<String> buildHtml(String name, PartialFunction<String, String> pfss) {
        return this.buildHtml(name, I18N$.MODULE$.EmptyLanguage(), pfss);
    }

    public Option<String> buildHtml(String name, String language, PartialFunction<String, String> pfss) {
        return this.supplier.content(name, language).map((Function1 & Serializable)text -> {
            StringWriter out = new StringWriter();
            this.process(new StringReader((String)text), out, language, pfss, true);
            return out.toString();
        });
    }

    public void sendHtml(Reader r, Writer w, PartialFunction<String, String> pfss) {
        this.process(r, w, I18N$.MODULE$.EmptyLanguage(), pfss, true);
    }

    public void sendHtml(Reader r, Writer w, String language, PartialFunction<String, String> pfss) {
        this.process(r, w, language, pfss, true);
    }

    public String process(String in, String language, PartialFunction<String, String> pfss, boolean initialPass) {
        StringWriter w = new StringWriter();
        this.processLine(WebReply$ProcessState$.MODULE$.apply(new BufferedReader(new StringReader(in)), w, language, pfss), initialPass);
        return w.toString();
    }

    public boolean process$default$4() {
        return true;
    }

    public void process(Reader r, Writer w, String language, PartialFunction<String, String> pfss, boolean initialPass) {
        BufferedReader bufferedReader;
        Reader reader = r;
        if (reader instanceof BufferedReader) {
            BufferedReader br;
            bufferedReader = br = (BufferedReader)reader;
        } else {
            Reader r2 = reader;
            bufferedReader = new BufferedReader(r2);
        }
        BufferedReader br = bufferedReader;
        this.processLine(WebReply$ProcessState$.MODULE$.apply(br, w, language, pfss), initialPass);
        w.flush();
    }

    private void processLine(ProcessState state, boolean pass) {
        String line;
        while ((line = state.br().readLine()) != null) {
            if (line.startsWith("$")) {
                String key = line.substring(1).trim();
                if (state.pfss().isDefinedAt((Object)key)) {
                    state.w().append(WebReply$.MODULE$.safeOutput((String)state.pfss().apply((Object)key)));
                }
                state.w().append('\n');
                return;
            }
            if (line.startsWith("#ifdef ")) {
                pass = state.pfss().isDefinedAt((Object)line.substring(7).trim());
                continue;
            }
            if (line.startsWith("#ifndef ")) {
                pass = !state.pfss().isDefinedAt((Object)line.substring(8).trim());
                continue;
            }
            if (line.startsWith("#else")) {
                pass = !pass;
                continue;
            }
            if (line.startsWith("#endif")) {
                pass = true;
                continue;
            }
            if (line.startsWith("#include ") && pass) {
                String name = line.substring(9);
                Option<String> option = this.supplier.content(name, state.language());
                if (option instanceof Some) {
                    String text = (String)((Some)option).value();
                    this.sendHtml(new StringReader(text), state.w(), state.language(), state.pfss());
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().warn(() -> WebReply.processLine$$anonfun$1(name), Line$.MODULE$.apply(119), FullName$.MODULE$.apply("com.elixirtech.webserver.WebReply.processLine"));
                    continue;
                }
                throw new MatchError(option);
            }
            if (!pass) continue;
            state.w().append(Template$.MODULE$.apply(line).substitute(state.pfss().lift()));
            state.w().append('\n');
        }
        return;
    }

    private static final Object processLine$$anonfun$1(String name$1) {
        return "Can't include " + name$1;
    }

    public static final class ProcessState
    implements Product,
    Serializable {
        private final BufferedReader br;
        private final Writer w;
        private final String language;
        private final PartialFunction pfss;

        public static ProcessState apply(BufferedReader bufferedReader, Writer writer, String string, PartialFunction<String, String> partialFunction) {
            return WebReply$ProcessState$.MODULE$.apply(bufferedReader, writer, string, partialFunction);
        }

        public static ProcessState fromProduct(Product product) {
            return WebReply$ProcessState$.MODULE$.fromProduct(product);
        }

        public static ProcessState unapply(ProcessState processState) {
            return WebReply$ProcessState$.MODULE$.unapply(processState);
        }

        public ProcessState(BufferedReader br, Writer w, String language, PartialFunction<String, String> pfss) {
            this.br = br;
            this.w = w;
            this.language = language;
            this.pfss = pfss;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProcessState)) return false;
            ProcessState processState = (ProcessState)object;
            BufferedReader bufferedReader = this.br();
            BufferedReader bufferedReader2 = processState.br();
            if (bufferedReader == null) {
                if (bufferedReader2 != null) {
                    return false;
                }
            } else if (!bufferedReader.equals(bufferedReader2)) return false;
            Writer writer = this.w();
            Writer writer2 = processState.w();
            if (writer == null) {
                if (writer2 != null) {
                    return false;
                }
            } else if (!writer.equals(writer2)) return false;
            String string = this.language();
            String string2 = processState.language();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            PartialFunction<String, String> partialFunction = this.pfss();
            PartialFunction<String, String> partialFunction2 = processState.pfss();
            if (partialFunction == null) {
                if (partialFunction2 == null) return true;
                return false;
            } else {
                if (!partialFunction.equals(partialFunction2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ProcessState;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ProcessState";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return new I18N.Language(this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "br";
                }
                case 1: {
                    return "w";
                }
                case 2: {
                    return "language";
                }
                case 3: {
                    return "pfss";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BufferedReader br() {
            return this.br;
        }

        public Writer w() {
            return this.w;
        }

        public String language() {
            return this.language;
        }

        public PartialFunction<String, String> pfss() {
            return this.pfss;
        }

        public ProcessState copy(BufferedReader br, Writer w, String language, PartialFunction<String, String> pfss) {
            return new ProcessState(br, w, language, pfss);
        }

        public BufferedReader copy$default$1() {
            return this.br();
        }

        public Writer copy$default$2() {
            return this.w();
        }

        public String copy$default$3() {
            return this.language();
        }

        public PartialFunction<String, String> copy$default$4() {
            return this.pfss();
        }

        public BufferedReader _1() {
            return this.br();
        }

        public Writer _2() {
            return this.w();
        }

        public String _3() {
            return this.language();
        }

        public PartialFunction<String, String> _4() {
            return this.pfss();
        }
    }

    public static interface Supplier {
        public static Supplier empty() {
            return WebReply$Supplier$.MODULE$.empty();
        }

        public Option<String> content(String var1, String var2);
    }

    public static final class SupplyChain
    implements Supplier,
    Product,
    Serializable {
        private final Supplier s;
        private final Supplier next;

        public static SupplyChain apply(Supplier supplier, Supplier supplier2) {
            return WebReply$SupplyChain$.MODULE$.apply(supplier, supplier2);
        }

        public static SupplyChain fromProduct(Product product) {
            return WebReply$SupplyChain$.MODULE$.fromProduct(product);
        }

        public static SupplyChain unapply(SupplyChain supplyChain) {
            return WebReply$SupplyChain$.MODULE$.unapply(supplyChain);
        }

        public SupplyChain(Supplier s, Supplier next) {
            this.s = s;
            this.next = next;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SupplyChain)) return false;
            SupplyChain supplyChain = (SupplyChain)object;
            Supplier supplier = this.s();
            Supplier supplier2 = supplyChain.s();
            if (supplier == null) {
                if (supplier2 != null) {
                    return false;
                }
            } else if (!supplier.equals(supplier2)) return false;
            Supplier supplier3 = this.next();
            Supplier supplier4 = supplyChain.next();
            if (supplier3 == null) {
                if (supplier4 == null) return true;
                return false;
            } else {
                if (!supplier3.equals(supplier4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SupplyChain;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SupplyChain";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "s";
            }
            if (1 == n2) {
                return "next";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Supplier s() {
            return this.s;
        }

        public Supplier next() {
            return this.next;
        }

        @Override
        public Option<String> content(String name, String language) {
            return this.s().content(name, language).orElse(() -> this.content$$anonfun$1(name, language));
        }

        public SupplyChain copy(Supplier s, Supplier next) {
            return new SupplyChain(s, next);
        }

        public Supplier copy$default$1() {
            return this.s();
        }

        public Supplier copy$default$2() {
            return this.next();
        }

        public Supplier _1() {
            return this.s();
        }

        public Supplier _2() {
            return this.next();
        }

        private final Option content$$anonfun$1(String name$2, String language$2) {
            return this.next().content(name$2, language$2);
        }
    }
}

