## SFTP Reader

This step reads a file from an SFTP Server and stores as `bytes` in the emitted record.

### Structure
1 => 1

### Input

Each incoming record should contain a path string identified by `Path Field`. 

### Parameters

* `Host` - the SFTP Server

* `Port` - the port to connect to on the SFTP Server

* `Path Field` - the SFTP server location from which the bytes will be read

* `User` - the user information (from the conf) to use for authentication 

### Output

Each record is output with `bytes` where successful, and an additional field:

* `sftpTransfer` - a boolean true/false indicating whether the transfer was successful.

### Notes

If `bytes` is larger than 16MB you will not be able to view the records in the output. 
To avoid this, use a Discard step on the `bytes` field after writing, you can then see the output 
(minus the bytes). This is because the output is stored in MongoDB, which has a 16MB limit. The ETL
itself does not have a limit, the limit is only in the output stored for viewing.

A connection failure will log an exception

### See Also

* SFTP Writer
 
* SFTP Writer (Field)
