## SFTP Writer (Field)

This step takes the bytes from an incoming record along with a file path and sends the bytes
to an SFTP Server to be stored at the file path. 

### Structure
1 ⇒ 1

### Input

Each incoming record should contain a `bytes` binary field and a path string identified by `Path Field`. 

Remember you can convert strings to binary (UTF-8) with Change Field Type.

### Parameters

* `Host` - the SFTP Server

* `Port` - the port to connect to on the SFTP Server

* `Path Field` - the SFTP server location into which the bytes will be written

* `User` - the user information (from the conf) to use for authentication 

### Output

Each record is output with a single additional field:

* `sftpTransfer` - a boolean true/false indicating whether the transfer was successful.

### Notes

If `bytes` is larger than 16MB you will not be able to view the records in the output. 
To avoid this, use a Discard step on the `bytes` field after writing, you can then see the output 
(minus the bytes). This is because the output is stored in MongoDB, which has a 16MB limit. The ETL
itself does not have a limit, the limit is only in the output stored for viewing.

### See Also

* SFTP Reader
 
* SFTP Writer
