## Add API Token (Field)

This step adds an API Token which can then be composed into a URL, allowing access to Ambience resources
for a limited time (depending on the access rights of the user assigned to the API Token). This variant 
takes the user name from a field in the incoming record.

Only users with mod-api-tokens privilege can run this step.

### Structure
1 => 1

### Input
The incoming record should contain a string field holding the user name for which an API Token is to be generated.
(This should be a limited account, with minimal privileges for the task needed).

### Parameters
* `User Name Field` - the name of string field holding the user that the API Token will represent.
* `Expire After` - the timeframe for which the API Token will be valid
* `Add Cookie` - set to true if the user needs UI interaction, eg. with a form, leave false for single API calls.

### Output
The input record is passed through with the following fields set:

* `token` - a string holding the generated API Token value
* `userId` - the id (BsonObjectId) of the user that the API Token will represent
* `expireAt` - the timestamp (BsonDateTime) at which the API Token will expire

#### Notes

* The API Token is a useful way to allow temporary access to the system, but use must be carefully
controlled and the token should be configured to represent a user with the minimum set of privileges
to complete the task. Creating an API Token which represents `admin` is basically giving admin rights
to everyone who knows the API Token. 
 
* Add Cookie should only be set where interactive actions are needed over a period of time - 
eg. where a form must be edited, do not add a cookie for single API calls, for example to 
render a report.

* Adding a cookie will allow that cookie to exist after the API Token itself has expired. Ambience
cookies remain while there is activity and are automatically terminated after 15 minutes of 
inactivity (configurable). If the cookie expires due to inactivity, the user will need to supply the 
API token again to get a new cookie (provided the API Token has not itself expired).

#### See Also

* Add API Token
