## Add Identity

This step adds a new identity to Ambience.
This step will only work for administrators with mod-identity privilege.
This step will only work if the default identity module is used (ie. not LDAP or custom OAuth2)

### Structure
1 => 1

### Input
A record containing the following fields (extra fields are ignored):

* name (mandatory) - a string holding the user name
 
* email (mandatory) - a string holding the user's email address
 
* enabled (optional) - a boolean - defaults to true
 
### Parameters

None

### Output
Each incoming record will be annotated with the result of the operation. The extra fields added are:

`success` - whether the add was successful (boolean)

`identityId` - the user id (BsonObjectId) only on success

`error` - the error message, only when success = false

#### Notes

This step will automatically generate a password and email it to the user.
The user can then login and may be forced to change the password (depending on the config setting `elixir.identity.on-add.changePassword`)
This series of steps proves ownership of the email address.
The format of the email is identical to that generated from the Identity module itself.

This step does not create a user corresponding to the new identity. There is a separate step for this.
Alternatively, the system supports auto-creation of users based on identity when the user logs in.
See `elixir.sso.client.add-authenticated-users` for more details.

#### See Also

* Add User
