## Authenticated Users

This fetches user authentication logs from the sso system and emits a record for each login attempt.
The information loaded is: user name, timestamp, success, any error.
This step will only work for administrators with mod-identity privilege.

### Structure
1 => N

### Input
A record holding the From and To fields identified by the parameter list

### Parameters
* `From Field` - the field holding the start instant of the search - this may be a Timestamp, a Date (eg. "yyyy-MM-dd", 
   where 00:00:00 is assumed) or a Long (epoch milliseconds)

* `To Field (Optional)` - the field holding the end instant of the search - this may be a Timestamp, a Date (eg. "yyyy-MM-dd",
  where 00:00:00 + 24 hours is assumed) or a Long (epoch milliseconds). This field is optional 
  - the default (current time) is used when omitted.

### Output
The incoming record will be duplicated once for each login known to the system, with extra fields added:

`user` - the name of the user (string)
`success` - whether the login was successful (boolean)
`error` - only when success = false
`timestamp` - the timestamp of the login activity (timestamp)

#### Notes
* The From timestamp is inclusive, the To timestamp is exclusive. Where date strings in the format yyyy-MM-dd are
  used the From field is rounded down to the start of the day (00:00:00 inclusive), 
  whereas the To field is rounded up to the end of the day (00:00:00 of the next day - exclusive)

#### See Also
