## Lookup Constant

This step looks up a constant in the Ambience constant list. 
A constant may be a single value, eg. 123 or "hello", or it may be a more complex 
nested object or even an array.

```
Limit = 1000
Range = {min: 20, max: 80}
Choices = ["hello", "world"]
```

See the Lookup module: Constants section for more details.

### Structure
1 => 1

### Input

Incoming records have a string field which must be mapped to a constant.

### Parameters

* `Lookup Field` - the field holding the text to look up in the constant map
* `To Field (Optional)` - the field to hold the lookup result (if empty, the from field is overwritten).

### Output
Each incoming record will be passed through with the addition of a constant where the 
lookup was successful. If the lookup key is not found, the output field is not touched.

#### Notes

* There is one global list, so you might choose to prefix constant names to retain distinct categories. 
  You can use the string manipulation steps for this. 

#### See Also
