## Read Event Log

This step reads the event log and outputs a record for each event that matches the provided filter.

Only users with mod-events-log-viewer privilege can run this step.

### Structure
1 => N

### Input
There are no input requirements, however a start and end value are recommended, as otherwise the results can be huge.
If `Start Field` or `End Field` is defined, then the field must be present in the incoming record.

### Parameters
* `Start Field` - the name of the field holding either a start date or start timestamp. 
* `End Field` - the name of the field holding either an end date (String) or end timestamp.
* `Min. Level` - DEBUG, INFO, WARN or ERROR.

### Output
The input record is discarded. The output is the list of records that match the filter 
criteria provided by the parameters.

#### Notes

* If the Start Field name is blank, then records are not filtered by start date. 
 
* If the End Field name is blank, then records are not filtered by end date.
 
* If the Start or End Field name is defined then it must be either a string or a timestamp. 
  Any other type raises an error. If the field is not present, that also raises an error. 
  In the event of an error, no records are output (see the job log for the error message). 

#### See Also

* Read Activity Log

* Read Audit Log
