## Rename User

This step renames an Ambience user.
This step will only work for administrators with mod-users privilege.

Note that this is not enough to allow a user to login with a different name. 
If using the Ambience Identity (SSO) system, you must also use Rename Identity as well.
If you are using an external authenticator, eg. LDAP or AD etc. then the name 
must also be changed there.

### Structure
1 => 1

### Input
A record with strings defining the old user name and the new user name.

### Parameters

* `Old Name Field` - the string field holding the current user name
 
* `New Name Field` - the string field holding the new user name

### Output
Each incoming record will be annotated with the result of the operation. The extra fields added are:

`success` - whether the rename was successful (boolean)

`error` - the error message, only when success = false

#### Notes

* Given this step may be chained with Rename Identity, if the incoming record has success = false, 
  this step will be ignored and any error string will be from the previous failure, presumably Rename Identity.

* Note that Rename Identity and Rename User have different privilege requirements.

#### See Also

* Rename Identity
